/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlayng;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBHexFileReader;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.operation.overlayng.OverlayNG;

public class OverlayCaseDumper {
    private static final int MAX_CASES = 100;
    private static final int MAX_POINTS = 100;
    private static GeometryFactory geomFact = new GeometryFactory();
    private String inFilename = null;
    private String outputFilename = null;
    private PrintStream outStream = System.out;
    private int caseCount;
    private Geometry prevGeom0;
    private Geometry prevGeom1;

    public static void main(String[] args) {
        OverlayCaseDumper opd = new OverlayCaseDumper();
        opd.parseArgs(args);
        try {
            opd.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void parseArgs(String[] args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Input filename is required");
        }
        this.inFilename = args[0];
        if (args.length >= 2) {
            this.outputFilename = args[1];
        }
    }

    private void run() throws ParseException, IOException {
        if (this.outputFilename != null) {
            this.outStream = new PrintStream(new File(this.outputFilename));
        }
        List<Geometry> geomsIn = OverlayCaseDumper.readWKBFile(this.inFilename);
        List<Geometry> geoms = this.flatten(geomsIn);
        System.out.println("Number of geoms read: " + geoms.size());
        List<Geometry> geomsFilt = this.filter(geoms);
        this.logHeader();
        this.doIntersections(geomsFilt);
        this.logFooter();
        System.out.println("Number of geoms filtered: " + geomsFilt.size());
        System.out.println("Number of cases output: " + this.caseCount);
        this.outStream.flush();
        this.outStream.close();
    }

    private List<Geometry> flatten(List<Geometry> geoms) {
        ArrayList<Geometry> flat = new ArrayList<Geometry>();
        for (Geometry geom : geoms) {
            if (geom.getNumGeometries() == 1) {
                flat.add(geom);
                continue;
            }
            PolygonExtracter.getPolygons(geom, flat);
        }
        return flat;
    }

    private void doIntersections(List<Geometry> geoms) {
        this.caseCount = 0;
        for (int i = 0; i < geoms.size(); ++i) {
            Geometry geom = geoms.get(i);
            for (int j = i + 1; j < geoms.size(); ++j) {
                Geometry geom1 = geoms.get(j);
                if (!geom.getEnvelopeInternal().intersects(geom1.getEnvelopeInternal()) || this.prevGeom0 != null && this.prevGeom0.equalsExact(geom) || this.prevGeom1 != null && this.prevGeom1.equalsExact(geom1)) continue;
                this.prevGeom0 = geom;
                this.prevGeom1 = geom1;
                boolean isDumped = this.doIntersection(geom, geom1);
                if (isDumped) {
                    ++this.caseCount;
                }
                if (this.caseCount < 100) continue;
                return;
            }
        }
    }

    private boolean doIntersection(Geometry geom, Geometry geom1) {
        try {
            Geometry result = OverlayNG.overlay(geom, geom1, 1);
            return false;
        }
        catch (TopologyException ex) {
            this.log(geom, geom1);
            return true;
        }
    }

    private void logHeader() {
        this.outStream.println("<run>\n");
    }

    private void logFooter() {
        this.outStream.println("\n</run>");
    }

    private void log(Geometry geom0, Geometry geom1) {
        this.outStream.println("<case>\n<a>");
        this.outStream.println(geom0);
        this.outStream.println("</a>\n<b>");
        this.outStream.println(geom1);
        this.outStream.println("</b>\n<test><op name='union' arg1='A' arg2='B' >  </op></test>\n</case>\n\n");
    }

    private List<Geometry> filter(List<Geometry> geoms) {
        ArrayList<Geometry> filt = new ArrayList<Geometry>();
        for (Geometry geom : geoms) {
            if (geom.getNumPoints() > 100) continue;
            filt.add(geom);
        }
        return filt;
    }

    private static List<Geometry> readWKBFile(String filename) throws ParseException, IOException {
        File file = new File(filename);
        FileReader fileReader = new FileReader(file);
        WKBReader wkbrdr = new WKBReader(geomFact);
        WKBHexFileReader wkbhexReader = new WKBHexFileReader(fileReader, wkbrdr);
        return wkbhexReader.read();
    }
}

