/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.distance;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.index.strtree.EnvelopeDistance;

public class TestStressEnvelopeMinMaxDistance {
    static GeometryFactory factory = new GeometryFactory();
    boolean testFailed = false;
    boolean verbose = true;

    public static void main(String[] args) {
        TestStressEnvelopeMinMaxDistance test = new TestStressEnvelopeMinMaxDistance();
        test.test();
    }

    public void test() {
        int sizeX = 6;
        int sizeY = 6;
        Coordinate[] pts = this.createPoints(sizeX, sizeY);
        MultiPoint[] boxes = this.createPointPairs(pts);
        this.run(boxes);
    }

    private void run(MultiPoint[] boxes) {
        int n = boxes.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.run(boxes[i], boxes[j]);
            }
        }
    }

    private void run(MultiPoint a, MultiPoint b) {
        double distance = a.distance(b);
        double minMaxDistance = EnvelopeDistance.minMaxDistance(a.getEnvelopeInternal(), b.getEnvelopeInternal());
        System.out.println("distance: " + distance + "   minMaxDist: " + minMaxDistance);
        if (distance > minMaxDistance) {
            System.out.println("ERROR - distance: " + distance + "   minMaxDist: " + minMaxDistance);
        }
    }

    private MultiPoint[] createPointPairs(Coordinate[] pts) {
        int npts = pts.length;
        MultiPoint[] pairs = new MultiPoint[npts * npts];
        for (int i = 0; i < npts; ++i) {
            for (int j = 0; j < npts; ++j) {
                MultiPoint pair;
                int index = i * npts + j;
                pairs[index] = pair = factory.createMultiPointFromCoords(new Coordinate[]{pts[i], pts[j]});
            }
        }
        return pairs;
    }

    private Coordinate[] createPoints(int sizeX, int sizeY) {
        int npts = sizeX * sizeY;
        Coordinate[] pts = new Coordinate[npts];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                pts[x * sizeX + y] = new Coordinate(x, y);
            }
        }
        return pts;
    }
}

