/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;

public class RandomOffsetLineStringGenerator {
    private double maxSegLen;
    private int numPts;
    private int exponent2 = 5;
    private Coordinate[] pts;
    private Coordinate endPoint;

    public static Geometry generate(double maxSegLen, int numPts, GeometryFactory fact) {
        RandomOffsetLineStringGenerator rlg = new RandomOffsetLineStringGenerator(maxSegLen, numPts);
        return rlg.generate(fact);
    }

    public RandomOffsetLineStringGenerator(double maxSegLen, int numPts) {
        this.maxSegLen = maxSegLen;
        this.exponent2 = (int)(Math.log(numPts) / Math.log(2.0));
        int pow2 = RandomOffsetLineStringGenerator.pow2(this.exponent2);
        if (pow2 < numPts) {
            ++this.exponent2;
        }
        this.numPts = RandomOffsetLineStringGenerator.pow2(this.exponent2) + 1;
    }

    public Geometry generate(GeometryFactory fact) {
        this.pts = new Coordinate[this.numPts];
        this.pts[0] = new Coordinate();
        double ang = Math.PI * Math.random();
        this.pts[this.numPts - 1] = this.endPoint = new Coordinate(this.maxSegLen * Math.cos(ang), this.maxSegLen * Math.sin(ang));
        for (int interval = this.numPts / 2; interval >= 1; interval /= 2) {
            this.createRandomOffsets(interval);
        }
        return fact.createLineString(this.pts);
    }

    private void createRandomOffsets(int interval) {
        for (int inc = RandomOffsetLineStringGenerator.pow2(this.exponent2); inc > 1; inc /= 2) {
            this.computeRandomOffsets(inc);
        }
    }

    private void computeRandomOffsets(int inc) {
        int inc2 = inc / 2;
        int i = 0;
        while (i + inc2 < this.numPts) {
            Coordinate segEndPoint;
            int midIndex = i + inc2;
            int endIndex = i + inc;
            double segFrac = 0.5 + this.randomFractionPerturbation();
            if (endIndex >= this.numPts) {
                segEndPoint = this.endPoint;
                segFrac = midIndex / this.numPts;
            } else {
                segEndPoint = this.pts[i + inc];
            }
            this.pts[midIndex] = this.computeRandomOffset(this.pts[i], segEndPoint, segFrac);
            i += inc;
        }
    }

    private Coordinate computeRandomOffset(Coordinate p0, Coordinate p1, double segFrac) {
        double len = p0.distance(p1);
        double len2 = len / 2.0;
        double offsetLen = len * Math.random() - len2;
        LineSegment seg = new LineSegment(p0, p1);
        return seg.pointAlongOffset(segFrac, offsetLen);
    }

    private double randomFractionPerturbation() {
        double rnd = Math.random();
        double mag = rnd * rnd * rnd;
        int sign = Math.random() > 0.5 ? 1 : -1;
        return (double)sign * mag;
    }

    private static int pow2(int exponent) {
        int pow2 = 1;
        for (int i = 0; i < exponent; ++i) {
            pow2 *= 2;
        }
        return pow2;
    }
}

