/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.math;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.util.Stopwatch;
import test.jts.perf.math.TriPredicate;

public class InCirclePerf {
    Coordinate pa = new Coordinate(687958.05, 7460725.97);
    Coordinate pb = new Coordinate(687957.43, 7460725.93);
    Coordinate pc = new Coordinate(687957.58, 7460721.0);
    Coordinate pp = new Coordinate(687958.13, 7460720.99);

    public static void main(String[] args) throws Exception {
        InCirclePerf test = new InCirclePerf();
        test.run();
    }

    public void run() {
        System.out.println("InCircle perf");
        int n = 1000000;
        double doubleTime = this.runDouble(n);
        double ddSelfTime = this.runDDSelf(n);
        double ddSelf2Time = this.runDDSelf2(n);
        double ddTime = this.runDD(n);
        System.out.println("DD VS double performance factor      = " + ddTime / doubleTime);
        System.out.println("DDSelf VS double performance factor  = " + ddSelfTime / doubleTime);
        System.out.println("DDSelf2 VS double performance factor = " + ddSelf2Time / doubleTime);
    }

    public double runDouble(int nIter) {
        Stopwatch sw = new Stopwatch();
        for (int i = 0; i < nIter; ++i) {
            TriPredicate.isInCircle(this.pa, this.pb, this.pc, this.pp);
        }
        sw.stop();
        System.out.println("double:   nIter = " + nIter + "   time = " + sw.getTimeString());
        return (double)sw.getTime() / (double)nIter;
    }

    public double runDD(int nIter) {
        Stopwatch sw = new Stopwatch();
        for (int i = 0; i < nIter; ++i) {
            TriPredicate.isInCircleDD(this.pa, this.pb, this.pc, this.pp);
        }
        sw.stop();
        System.out.println("DD:       nIter = " + nIter + "   time = " + sw.getTimeString());
        return (double)sw.getTime() / (double)nIter;
    }

    public double runDDSelf(int nIter) {
        Stopwatch sw = new Stopwatch();
        for (int i = 0; i < nIter; ++i) {
            TriPredicate.isInCircleDD2(this.pa, this.pb, this.pc, this.pp);
        }
        sw.stop();
        System.out.println("DD-Self:  nIter = " + nIter + "   time = " + sw.getTimeString());
        return (double)sw.getTime() / (double)nIter;
    }

    public double runDDSelf2(int nIter) {
        Stopwatch sw = new Stopwatch();
        for (int i = 0; i < nIter; ++i) {
            TriPredicate.isInCircleDD3(this.pa, this.pb, this.pc, this.pp);
        }
        sw.stop();
        System.out.println("DD-Self2: nIter = " + nIter + "   time = " + sw.getTimeString());
        return (double)sw.getTime() / (double)nIter;
    }
}

