/*
 * Decompiled with CFR 0.152.
 */
package test.jts.geom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import test.jts.geom.GeometryTestFactory;

public class TestSerializable {
    public static final String FILENAME = "c:\\testSerial.txt";
    public static final GeometryFactory fact = new GeometryFactory();

    public static void main(String[] args) {
        TestSerializable test = new TestSerializable();
        test.run();
    }

    public void run() {
        List objList = this.createData();
        this.writeData(objList);
        this.readData(objList);
    }

    List createData() {
        ArrayList<Comparable> objList = new ArrayList<Comparable>();
        Envelope env = new Envelope(123.0, 456.0, 123.0, 456.0);
        objList.add(env);
        objList.add(GeometryTestFactory.createBox(fact, 0.0, 100.0, 10, 10.0));
        return objList;
    }

    void writeData(List objList) {
        File file = new File(FILENAME);
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            ObjectOutputStream objStream = new ObjectOutputStream(outStream);
            objStream.writeObject(objList);
            objStream.close();
        }
        catch (IOException e) {
            System.err.println("Things not going as planned.");
            e.printStackTrace();
        }
    }

    void readData(List objList) {
        File file = new File(FILENAME);
        try {
            FileInputStream stream = new FileInputStream(file);
            ObjectInputStream objStream = new ObjectInputStream(stream);
            int count = 0;
            Object obj = objStream.readObject();
            List inputList = (List)obj;
            Iterator i = inputList.iterator();
            while (i.hasNext()) {
                this.compare(objList.get(count++), i.next());
            }
            objStream.close();
        }
        catch (Exception e) {
            System.err.println("Things not going as planned.");
            e.printStackTrace();
        }
    }

    boolean compare(Object o1, Object o2) {
        boolean matched = false;
        if (o1 instanceof Envelope) {
            if (!((Envelope)o1).equals(o2)) {
                System.out.println("expected " + o1 + ", found " + o2);
            } else {
                matched = true;
            }
        } else if (o1 instanceof Geometry) {
            if (!((Geometry)o1).equalsExact((Geometry)o2)) {
                System.out.println("expected " + o1 + ", found " + o2);
            } else {
                matched = true;
            }
        }
        if (matched) {
            System.out.println("found match for object");
        }
        return true;
    }
}

