/*
 * Decompiled with CFR 0.152.
 */
package test.jts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import junit.framework.TestCase;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import test.jts.WKTorBReader;

public abstract class GeometryTestCase
extends TestCase {
    private static final String CHECK_EQUAL_FAIL = "FAIL - Expected = %s -- Actual = %s\n";
    final GeometryFactory geomFactory;
    final WKTReader readerWKT;
    final WKTWriter writerZ = new WKTWriter(3);

    protected GeometryTestCase(String name) {
        this(name, CoordinateArraySequenceFactory.instance());
    }

    protected GeometryTestCase(String name, CoordinateSequenceFactory coordinateSequenceFactory) {
        super(name);
        this.geomFactory = new GeometryFactory(coordinateSequenceFactory);
        this.readerWKT = new WKTReader(this.geomFactory);
    }

    protected GeometryFactory getGeometryFactory() {
        return this.geomFactory;
    }

    protected void checkEqual(Geometry expected, Geometry actual) {
        Geometry expectedNorm;
        Geometry actualNorm = actual.norm();
        boolean equal = actualNorm.equalsExact(expectedNorm = expected.norm());
        if (!equal) {
            System.out.format(CHECK_EQUAL_FAIL, expectedNorm, actualNorm);
        }
        GeometryTestCase.assertTrue((boolean)equal);
    }

    protected void checkEqualExact(Geometry expected, Geometry actual) {
        boolean equal = actual.equalsExact(expected);
        if (!equal) {
            System.out.format(CHECK_EQUAL_FAIL, expected, actual);
        }
        GeometryTestCase.assertTrue((boolean)equal);
    }

    protected void checkEqual(Geometry expected, Geometry actual, double tolerance) {
        Geometry expectedNorm;
        Geometry actualNorm = actual.norm();
        boolean equal = actualNorm.equalsExact(expectedNorm = expected.norm(), tolerance);
        if (!equal) {
            System.out.format(CHECK_EQUAL_FAIL, expectedNorm, actualNorm);
        }
        GeometryTestCase.assertTrue((boolean)equal);
    }

    protected void checkEqualXYZ(Geometry expected, Geometry actual) {
        Geometry expectedNorm;
        Geometry actualNorm = actual.norm();
        boolean equal = this.equalsExactXYZ(actualNorm, expectedNorm = expected.norm());
        if (!equal) {
            System.out.format(CHECK_EQUAL_FAIL, this.writerZ.write(expectedNorm), this.writerZ.write(actualNorm));
        }
        GeometryTestCase.assertTrue((boolean)equal);
    }

    private boolean equalsExactXYZ(Geometry a, Geometry b) {
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a.getNumGeometries() != b.getNumGeometries()) {
            return false;
        }
        if (a instanceof Point) {
            return GeometryTestCase.isEqualDim(((Point)a).getCoordinateSequence(), ((Point)b).getCoordinateSequence(), 3);
        }
        if (a instanceof LineString) {
            return GeometryTestCase.isEqualDim(((LineString)a).getCoordinateSequence(), ((LineString)b).getCoordinateSequence(), 3);
        }
        if (a instanceof Polygon) {
            return this.equalsExactXYZPolygon((Polygon)a, (Polygon)b);
        }
        if (a instanceof GeometryCollection) {
            for (int i = 0; i < a.getNumGeometries(); ++i) {
                if (this.equalsExactXYZ(a.getGeometryN(i), b.getGeometryN(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalsExactXYZPolygon(Polygon a, Polygon b) {
        LinearRing aShell = a.getExteriorRing();
        LinearRing bShell = b.getExteriorRing();
        if (!GeometryTestCase.isEqualDim(aShell.getCoordinateSequence(), bShell.getCoordinateSequence(), 3)) {
            return false;
        }
        if (a.getNumInteriorRing() != b.getNumInteriorRing()) {
            return false;
        }
        for (int i = 0; i < a.getNumInteriorRing(); ++i) {
            LinearRing aHole = a.getInteriorRingN(i);
            LinearRing bHole = b.getInteriorRingN(i);
            if (GeometryTestCase.isEqualDim(aHole.getCoordinateSequence(), bHole.getCoordinateSequence(), 3)) continue;
            return false;
        }
        return true;
    }

    protected void checkEqual(Collection expected, Collection actual) {
        this.checkEqual(this.toGeometryCollection(expected), this.toGeometryCollection(actual));
    }

    GeometryCollection toGeometryCollection(Collection geoms) {
        return this.geomFactory.createGeometryCollection(GeometryFactory.toGeometryArray(geoms));
    }

    protected void checkEqualXY(Coordinate expected, Coordinate actual) {
        GeometryTestCase.assertEquals((String)"Coordinate X", (Object)expected.getX(), (Object)actual.getX());
        GeometryTestCase.assertEquals((String)"Coordinate Y", (Object)expected.getY(), (Object)actual.getY());
    }

    protected void checkEqualXYZ(Coordinate expected, Coordinate actual) {
        GeometryTestCase.assertEquals((String)"Coordinate X", (Object)expected.getX(), (Object)actual.getX());
        GeometryTestCase.assertEquals((String)"Coordinate Y", (Object)expected.getY(), (Object)actual.getY());
        GeometryTestCase.assertEquals((String)"Coordinate Z", (Object)expected.getZ(), (Object)actual.getZ());
    }

    protected void checkEqualXY(String message, Coordinate expected, Coordinate actual) {
        GeometryTestCase.assertEquals((String)(message + " X"), (Object)expected.getX(), (Object)actual.getX());
        GeometryTestCase.assertEquals((String)(message + " Y"), (Object)expected.getY(), (Object)actual.getY());
    }

    protected void checkEqualXY(Coordinate expected, Coordinate actual, double tolerance) {
        GeometryTestCase.assertEquals((String)"Coordinate X", (double)expected.getX(), (double)actual.getX(), (double)tolerance);
        GeometryTestCase.assertEquals((String)"Coordinate Y", (double)expected.getY(), (double)actual.getY(), (double)tolerance);
    }

    protected void checkEqualXY(String message, Coordinate expected, Coordinate actual, double tolerance) {
        GeometryTestCase.assertEquals((String)(message + " X"), (double)expected.getX(), (double)actual.getX(), (double)tolerance);
        GeometryTestCase.assertEquals((String)(message + " Y"), (double)expected.getY(), (double)actual.getY(), (double)tolerance);
    }

    protected static Geometry read(GeometryFactory geomFactory, String wkt) {
        WKTReader reader = new WKTReader(geomFactory);
        try {
            return reader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected Geometry read(String wkt) {
        return WKTorBReader.read(wkt, this.geomFactory);
    }

    public static Geometry read(WKTReader reader, String wkt) {
        try {
            return reader.read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected List readList(String[] wkt) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(wkt.length);
        for (int i = 0; i < wkt.length; ++i) {
            geometries.add(this.read(wkt[i]));
        }
        return geometries;
    }

    public static List readList(WKTReader reader, String[] wkt) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>(wkt.length);
        for (int i = 0; i < wkt.length; ++i) {
            geometries.add(GeometryTestCase.read(reader, wkt[i]));
        }
        return geometries;
    }

    public static WKTReader getWKTReader(EnumSet<Ordinate> ordinateFlags) {
        return GeometryTestCase.getWKTReader(ordinateFlags, new PrecisionModel());
    }

    public static WKTReader getWKTReader(EnumSet<Ordinate> ordinateFlags, double scale) {
        return GeometryTestCase.getWKTReader(ordinateFlags, new PrecisionModel(scale));
    }

    public static WKTReader getWKTReader(EnumSet<Ordinate> ordinateFlags, PrecisionModel precisionModel) {
        WKTReader result;
        if (!ordinateFlags.contains((Object)Ordinate.X)) {
            ordinateFlags.add(Ordinate.X);
        }
        if (!ordinateFlags.contains((Object)Ordinate.Y)) {
            ordinateFlags.add(Ordinate.Y);
        }
        if (ordinateFlags.size() == 2) {
            result = new WKTReader(new GeometryFactory(precisionModel, 0, CoordinateArraySequenceFactory.instance()));
            result.setIsOldJtsCoordinateSyntaxAllowed(false);
        } else if (ordinateFlags.contains((Object)Ordinate.Z)) {
            result = new WKTReader(new GeometryFactory(precisionModel, 0, CoordinateArraySequenceFactory.instance()));
        } else if (ordinateFlags.contains((Object)Ordinate.M)) {
            result = new WKTReader(new GeometryFactory(precisionModel, 0, PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
            result.setIsOldJtsCoordinateSyntaxAllowed(false);
        } else {
            result = new WKTReader(new GeometryFactory(precisionModel, 0, PackedCoordinateSequenceFactory.DOUBLE_FACTORY));
        }
        return result;
    }

    public static boolean isEqual(CoordinateSequence seq1, CoordinateSequence seq2) {
        return GeometryTestCase.isEqualTol(seq1, seq2, 0.0);
    }

    public static boolean isEqualTol(CoordinateSequence seq1, CoordinateSequence seq2, double tolerance) {
        if (seq1.getDimension() != seq2.getDimension()) {
            return false;
        }
        return GeometryTestCase.isEqual(seq1, seq2, seq1.getDimension(), tolerance);
    }

    public static boolean isEqualDim(CoordinateSequence seq1, CoordinateSequence seq2, int dimension) {
        return GeometryTestCase.isEqual(seq1, seq2, dimension, 0.0);
    }

    public static boolean isEqual(CoordinateSequence seq1, CoordinateSequence seq2, int dimension, double tolerance) {
        if (seq1 != null && seq2 == null) {
            return false;
        }
        if (seq1 == null && seq2 != null) {
            return false;
        }
        if (seq1.size() != seq2.size()) {
            return false;
        }
        if (seq1.getDimension() < dimension) {
            throw new IllegalArgumentException("dimension too high for seq1");
        }
        if (seq2.getDimension() < dimension) {
            throw new IllegalArgumentException("dimension too high for seq2");
        }
        for (int i = 0; i < seq1.size(); ++i) {
            for (int j = 0; j < dimension; ++j) {
                double val1 = seq1.getOrdinate(i, j);
                double val2 = seq2.getOrdinate(i, j);
                if (Double.isNaN(val1) || Double.isNaN(val2)) {
                    return Double.isNaN(val1) && Double.isNaN(val2);
                }
                if (!(Math.abs(val1 - val2) > tolerance)) continue;
                return false;
            }
        }
        return true;
    }

    public static CoordinateSequenceFactory getCSFactory(EnumSet<Ordinate> ordinateFlags) {
        if (ordinateFlags.contains((Object)Ordinate.M)) {
            return PackedCoordinateSequenceFactory.DOUBLE_FACTORY;
        }
        return CoordinateArraySequenceFactory.instance();
    }
}

