/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.util.IntArrayList;

public class IntArrayListTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(IntArrayListTest.class);
    }

    public IntArrayListTest(String name) {
        super(name);
    }

    public void testEmpty() {
        IntArrayList iar = new IntArrayList();
        IntArrayListTest.assertEquals((int)0, (int)iar.size());
    }

    public void testAddFew() {
        IntArrayList iar = new IntArrayList();
        iar.add(1);
        iar.add(2);
        iar.add(3);
        IntArrayListTest.assertEquals((int)3, (int)iar.size());
        int[] data = iar.toArray();
        IntArrayListTest.assertEquals((int)3, (int)data.length);
        IntArrayListTest.assertEquals((int)1, (int)data[0]);
        IntArrayListTest.assertEquals((int)2, (int)data[1]);
        IntArrayListTest.assertEquals((int)3, (int)data[2]);
    }

    public void testAddMany() {
        IntArrayList iar = new IntArrayList(20);
        int max = 100;
        for (int i = 0; i < max; ++i) {
            iar.add(i);
        }
        IntArrayListTest.assertEquals((int)max, (int)iar.size());
        int[] data = iar.toArray();
        IntArrayListTest.assertEquals((int)max, (int)data.length);
        for (int j = 0; j < max; ++j) {
            IntArrayListTest.assertEquals((int)j, (int)data[j]);
        }
    }

    public void testAddAll() {
        IntArrayList iar = new IntArrayList();
        iar.addAll(null);
        iar.addAll(new int[0]);
        iar.addAll(new int[]{1, 2, 3});
        IntArrayListTest.assertEquals((int)3, (int)iar.size());
        int[] data = iar.toArray();
        IntArrayListTest.assertEquals((int)3, (int)data.length);
        IntArrayListTest.assertEquals((int)1, (int)data[0]);
        IntArrayListTest.assertEquals((int)2, (int)data[1]);
        IntArrayListTest.assertEquals((int)3, (int)data[2]);
    }
}

