/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;
import test.jts.GeometryTestCase;

public class VoronoiDiagramBuilderTest
extends GeometryTestCase {
    private static final double TRIANGULATION_TOLERANCE = 0.0;

    public static void main(String[] args) {
        TestRunner.run(VoronoiDiagramBuilderTest.class);
    }

    public VoronoiDiagramBuilderTest(String name) {
        super(name);
    }

    public void testClipEnvelope() {
        Geometry sites = this.read("MULTIPOINT ((50 100), (50 50), (100 50), (100 100))");
        Geometry clip = this.read("POLYGON ((0 0, 0 200, 200 200, 200 0, 0 0))");
        Geometry voronoi = VoronoiDiagramBuilderTest.voronoiDiagram(sites, clip);
        VoronoiDiagramBuilderTest.assertTrue((boolean)voronoi.getEnvelopeInternal().equals(clip.getEnvelopeInternal()));
    }

    public void testClipEnvelopeBig() {
        Geometry sites = this.read("MULTIPOINT ((50 100), (50 50), (100 50), (100 100))");
        Geometry clip = this.read("POLYGON ((-1000 1000, 1000 1000, 1000 -1000, -1000 -1000, -1000 1000))");
        Geometry voronoi = VoronoiDiagramBuilderTest.voronoiDiagram(sites, clip);
        VoronoiDiagramBuilderTest.assertTrue((boolean)voronoi.getEnvelopeInternal().equals(clip.getEnvelopeInternal()));
    }

    public static Geometry voronoiDiagram(Geometry sitesGeom, Geometry clipGeom) {
        VoronoiDiagramBuilder builder = new VoronoiDiagramBuilder();
        builder.setSites(sitesGeom);
        if (clipGeom != null) {
            builder.setClipEnvelope(clipGeom.getEnvelopeInternal());
        }
        builder.setTolerance(0.0);
        Geometry diagram = builder.getDiagram(sitesGeom.getFactory());
        return diagram;
    }
}

