/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import test.jts.GeometryTestCase;

public class IsValidTest
extends GeometryTestCase {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run(IsValidTest.class);
    }

    public IsValidTest(String name) {
        super(name);
    }

    public void testInvalidCoordinate() throws Exception {
        Coordinate badCoord = new Coordinate(1.0, Double.NaN);
        Coordinate[] pts = new Coordinate[]{new Coordinate(0.0, 0.0), badCoord};
        LineString line = this.geometryFactory.createLineString(pts);
        IsValidOp isValidOp = new IsValidOp(line);
        boolean valid = isValidOp.isValid();
        TopologyValidationError err = isValidOp.getValidationError();
        Coordinate errCoord = err.getCoordinate();
        IsValidTest.assertEquals((int)10, (int)err.getErrorType());
        IsValidTest.assertTrue((boolean)Double.isNaN(errCoord.y));
        IsValidTest.assertEquals((boolean)false, (boolean)valid);
    }

    public void testZeroAreaPolygon() {
        this.checkInvalid("POLYGON((0 0, 0 0, 0 0, 0 0, 0 0))");
    }

    public void testValidSimplePolygon() {
        this.checkValid("POLYGON ((10 89, 90 89, 90 10, 10 10, 10 89))");
    }

    public void testInvalidSimplePolygonRingSelfIntersection() {
        this.checkInvalid(5, "POLYGON ((10 90, 90 10, 90 90, 10 10, 10 90))");
    }

    public void testInvalidPolygonInverted() {
        this.checkInvalid(6, "POLYGON ((70 250, 40 500, 100 400, 70 250, 80 350, 60 350, 70 250))");
    }

    public void testInvalidPolygonSelfCrossing() {
        this.checkInvalid(5, "POLYGON ((70 250, 70 500, 80 400, 40 400, 70 250))");
    }

    public void testSimplePolygonHole() {
        this.checkValid("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (60 20, 20 70, 90 90, 60 20))");
    }

    public void testPolygonTouchingHoleAtVertex() {
        this.checkValid("POLYGON ((240 260, 40 260, 40 80, 240 80, 240 260), (140 180, 40 260, 140 240, 140 180))");
    }

    public void testPolygonMultipleHolesTouchAtSamePoint() {
        this.checkValid("POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (40 80, 60 80, 50 50, 40 80), (20 60, 20 40, 50 50, 20 60), (40 20, 60 20, 50 50, 40 20))");
    }

    public void testPolygonHoleOutsideShellAllTouch() {
        this.checkInvalid(2, "POLYGON ((10 10, 30 10, 30 50, 70 50, 70 10, 90 10, 90 90, 10 90, 10 10), (50 50, 30 10, 70 10, 50 50))");
    }

    public void testPolygonHoleOutsideShellDoubleTouch() {
        this.checkInvalid(2, "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 80, 80 80, 80 20, 20 20, 20 80), (90 70, 150 50, 90 20, 110 40, 90 70))");
    }

    public void testPolygonNestedHolesAllTouch() {
        this.checkInvalid(3, "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 80, 80 80, 80 20, 20 20, 20 80), (50 80, 80 50, 50 20, 20 50, 50 80))");
    }

    public void testInvalidPolygonHoleProperIntersection() {
        this.checkInvalid(5, "POLYGON ((10 90, 50 50, 10 10, 10 90), (20 50, 60 70, 60 30, 20 50))");
    }

    public void testInvalidPolygonDisconnectedInterior() {
        this.checkInvalid(4, "POLYGON ((10 90, 90 90, 90 10, 10 10, 10 90), (20 80, 30 80, 20 20, 20 80), (80 30, 20 20, 80 20, 80 30), (80 80, 30 80, 80 30, 80 80))");
    }

    public void testValidMultiPolygonTouchAtVertices() {
        this.checkValid("MULTIPOLYGON (((10 10, 10 90, 90 90, 90 10, 80 80, 50 20, 20 80, 10 10)), ((90 10, 10 10, 50 20, 90 10)))");
    }

    public void testInvalidMultiPolygonHoleOverlapCrossing() {
        this.checkInvalid(5, "MULTIPOLYGON (((20 380, 420 380, 420 20, 20 20, 20 380), (220 340, 180 240, 60 200, 140 100, 340 60, 300 240, 220 340)), ((60 200, 340 60, 220 340, 60 200)))");
    }

    public void testValidMultiPolygonTouchAtVerticesSegments() {
        this.checkValid("MULTIPOLYGON (((60 40, 90 10, 90 90, 10 90, 10 10, 40 40, 60 40)), ((50 40, 20 20, 80 20, 50 40)))");
    }

    public void testInvalidMultiPolygonNestedAllTouchAtVertices() {
        this.checkInvalid(7, "MULTIPOLYGON (((10 10, 20 30, 10 90, 90 90, 80 30, 90 10, 50 20, 10 10)), ((80 30, 20 30, 50 20, 80 30)))");
    }

    public void testValidMultiPolygonHoleTouchVertices() {
        this.checkValid("MULTIPOLYGON (((20 380, 420 380, 420 20, 20 20, 20 380), (220 340, 80 320, 60 200, 140 100, 340 60, 300 240, 220 340)), ((60 200, 340 60, 220 340, 60 200)))");
    }

    public void testLineString() {
        this.checkInvalid("LINESTRING(0 0, 0 0)");
    }

    public void testLinearRingTriangle() {
        this.checkValid("LINEARRING (100 100, 150 200, 200 100, 100 100)");
    }

    public void testLinearRingSelfCrossing() {
        this.checkInvalid(6, "LINEARRING (150 100, 300 300, 100 300, 350 100, 150 100)");
    }

    public void testLinearRingSelfCrossing2() {
        this.checkInvalid(6, "LINEARRING (0 0, 100 100, 100 0, 0 100, 0 0)");
    }

    private void checkValid(String wkt) {
        this.checkValid(true, wkt);
    }

    private void checkValid(boolean isExpectedValid, String wkt) {
        Geometry geom = this.read(wkt);
        boolean isValid = geom.isValid();
        IsValidTest.assertEquals((boolean)isExpectedValid, (boolean)isValid);
    }

    private void checkInvalid(String wkt) {
        this.checkValid(false, wkt);
    }

    private void checkInvalid(int exepctedErrType, String wkt) {
        Geometry geom = this.read(wkt);
        IsValidOp validOp = new IsValidOp(geom);
        TopologyValidationError err = validOp.getValidationError();
        IsValidTest.assertEquals((int)exepctedErrType, (int)err.getErrorType());
    }
}

