/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.overlayng.OverlayNGTest;
import test.jts.GeometryTestCase;

public class OverlayNGPointsTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(OverlayNGPointsTest.class);
    }

    public OverlayNGPointsTest(String name) {
        super(name);
    }

    public void testSimpleIntersection() {
        Geometry a = this.read("MULTIPOINT ((1 1), (2 1))");
        Geometry b = this.read("POINT (2 1)");
        Geometry expected = this.read("POINT (2 1)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testSimpleMergeIntersection() {
        Geometry a = this.read("MULTIPOINT ((1 1), (1.5 1.1), (2 1), (2.1 1.1))");
        Geometry b = this.read("POINT (2 1)");
        Geometry expected = this.read("POINT (2 1)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testSimpleUnion() {
        Geometry a = this.read("MULTIPOINT ((1 1), (2 1))");
        Geometry b = this.read("POINT (2 1)");
        Geometry expected = this.read("MULTIPOINT ((1 1), (2 1))");
        this.checkEqual(expected, OverlayNGTest.union(a, b, 1.0));
    }

    public void testSimpleDifference() {
        Geometry a = this.read("MULTIPOINT ((1 1), (2 1))");
        Geometry b = this.read("POINT (2 1)");
        Geometry expected = this.read("POINT (1 1)");
        this.checkEqual(expected, OverlayNGTest.difference(a, b, 1.0));
    }

    public void testSimpleSymDifference() {
        Geometry a = this.read("MULTIPOINT ((1 2), (1 1), (2 2), (2 1))");
        Geometry b = this.read("MULTIPOINT ((2 2), (2 1), (3 2), (3 1))");
        Geometry expected = this.read("MULTIPOINT ((1 2), (1 1), (3 2), (3 1))");
        this.checkEqual(expected, OverlayNGTest.symDifference(a, b, 1.0));
    }

    public void testSimpleFloatUnion() {
        Geometry a = this.read("MULTIPOINT ((1 1), (1.5 1.1), (2 1), (2.1 1.1))");
        Geometry b = this.read("MULTIPOINT ((1.5 1.1), (2 1), (2 1.2))");
        Geometry expected = this.read("MULTIPOINT ((1 1), (1.5 1.1), (2 1), (2 1.2), (2.1 1.1))");
        this.checkEqual(expected, OverlayNGTest.union(a, b));
    }

    public void testDisjointPointsRoundedIntersection() {
        Geometry a = this.read("POINT (10.1 10)");
        Geometry b = this.read("POINT (10 10.1)");
        Geometry expected = this.read("POINT (10 10)");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testEmptyIntersection() {
        Geometry a = this.read("MULTIPOINT ((1 1), (3 1))");
        Geometry b = this.read("POINT (2 1)");
        Geometry expected = this.read("POINT EMPTY");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testEmptyInputIntersection() {
        Geometry a = this.read("MULTIPOINT ((1 1), (3 1))");
        Geometry b = this.read("POINT EMPTY");
        Geometry expected = this.read("POINT EMPTY");
        this.checkEqual(expected, OverlayNGTest.intersection(a, b, 1.0));
    }

    public void testEmptyInputUUnion() {
        Geometry a = this.read("MULTIPOINT ((1 1), (3 1))");
        Geometry b = this.read("POINT EMPTY");
        Geometry expected = this.read("MULTIPOINT ((1 1), (3 1))");
        this.checkEqual(expected, OverlayNGTest.union(a, b, 1.0));
    }

    public void testEmptyDifference() {
        Geometry a = this.read("MULTIPOINT ((1 1), (3 1))");
        Geometry b = this.read("MULTIPOINT ((1 1), (2 1), (3 1))");
        Geometry expected = this.read("POINT EMPTY");
        this.checkEqual(expected, OverlayNGTest.difference(a, b, 1.0));
    }
}

