/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance3d;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.distance3d.Distance3DOp;

public class Distance3DOpTest
extends TestCase {
    static GeometryFactory geomFact = new GeometryFactory();
    static WKTReader rdr = new WKTReader();
    String polyHoleFlat = "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0), (120 180 0, 180 180 0, 180 120 0, 120 120 0, 120 180 0))";
    String poly2HoleFlat = "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0), (110 110 0, 110 130 0, 130 130 0, 130 110 0, 110 110 0), (190 110 0, 170 110 0, 170 130 0, 190 130 0, 190 110 0))";
    private static final double DIST_TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(Distance3DOpTest.class);
    }

    public Distance3DOpTest(String name) {
        super(name);
    }

    public void testEmpty() {
        this.checkDistance("POINT EMPTY", "POINT EMPTY", 0.0);
        this.checkDistance("LINESTRING EMPTY", "POINT (0 0 0)", 0.0);
        this.checkDistance("MULTILINESTRING EMPTY", "POLYGON EMPTY", 0.0);
        this.checkDistance("MULTIPOLYGON EMPTY", "POINT (0 0 0)", 0.0);
    }

    public void testPartiallyEmpty() {
        this.checkDistance("GEOMETRYCOLLECTION( MULTIPOINT (0 0 0), POLYGON EMPTY)", "POINT (0 1 0)", 1.0, this.coord(0.0, 0.0, 0.0), this.coord(0.0, 1.0, 0.0));
        this.checkDistance("GEOMETRYCOLLECTION( MULTIPOINT (11 11 0), POLYGON EMPTY)", "GEOMETRYCOLLECTION( MULTIPOINT EMPTY, LINESTRING (10 10 0, 10 20 0 ))", 1.0, this.coord(11.0, 11.0, 0.0), this.coord(10.0, 11.0, Double.NaN));
    }

    public void testPointPointFlat() {
        this.checkDistance("POINT (10 10 0 )", "POINT (20 20 0 )", 14.1421356, this.coord(10.0, 10.0, 0.0), this.coord(20.0, 20.0, 0.0));
        this.checkDistance("POINT (5 10 0 )", "POINT (15 20 0 )", 14.1421356, this.coord(5.0, 10.0, 0.0), this.coord(15.0, 20.0, 0.0));
    }

    public void testPointPoint() {
        this.checkDistance("POINT (0 0 0 )", "POINT (0 0 1 )", 1.0, this.coord(0.0, 0.0, 0.0), this.coord(0.0, 0.0, 1.0));
        this.checkDistance("POINT (10 10 1 )", "POINT (11 11 2 )", 1.7320508075688772, this.coord(10.0, 10.0, 1.0), this.coord(11.0, 11.0, 2.0));
        this.checkDistance("POINT (10 10 0 )", "POINT (10 20 10 )", 14.142135623730951, this.coord(10.0, 10.0, 0.0), this.coord(10.0, 20.0, 10.0));
    }

    public void testPointSegFlat() {
        this.checkDistance("LINESTRING (10 10 0, 10 20 0 )", "POINT (20 15 0 )", 10.0, this.coord(10.0, 15.0, Double.NaN), this.coord(20.0, 15.0, 0.0));
    }

    public void testPointSeg() {
        this.checkDistance("LINESTRING (0 0 0, 10 10 10 )", "POINT (5 5 5 )", 0.0, this.coord(5.0, 5.0, Double.NaN), this.coord(5.0, 5.0, 5.0));
        this.checkDistance("LINESTRING (10 10 10, 20 20 20 )", "POINT (11 11 10 )", 0.816496580927726, this.coord(11.0, 11.0, Double.NaN), this.coord(11.0, 11.0, 10.0));
    }

    public void testPointSegRobust() {
        this.checkDistance("LINESTRING (0 0 0, 10000000 10000000 1 )", "POINT (9999999 9999999 .9999999 )", 0.0);
        this.checkDistance("LINESTRING (0 0 0, 10000000 10000000 1 )", "POINT (5000000 5000000 .5 )", 0.0);
    }

    public void testCrossSegmentsFlat() {
        this.checkDistance("LINESTRING (0 0 0, 10 10 0 )", "LINESTRING (10 0 0, 0 10 0 )", 0.0);
        this.checkDistance("LINESTRING (0 0 10, 30 10 10 )", "LINESTRING (10 0 10, 0 10 10 )", 0.0);
    }

    public void testCrossSegments() {
        this.checkDistance("LINESTRING (0 0 0, 10 10 0 )", "LINESTRING (10 0 1, 0 10 1 )", 1.0);
        this.checkDistance("LINESTRING (0 0 0, 20 20 0 )", "LINESTRING (10 0 1, 0 10 1 )", 1.0);
        this.checkDistance("LINESTRING (20 10 20, 10 20 10 )", "LINESTRING (10 10 20, 20 20 10 )", 0.0);
    }

    public void testCrossSegmentsRobust() {
        this.checkDistance("LINESTRING (0 0 0, 10000000 10000000 1 )", "LINESTRING (0 0 1, 10000000 10000000 0 )", 0.0, 0.001);
        this.checkDistance("LINESTRING (-10000 -10000 0, 10000 10000 1 )", "LINESTRING (-10000 -10000 1, 10000 10000 0 )", 0.0);
        this.checkDistance("LINESTRING (-10000000 -10000000 0, 10000000 10000000 1 )", "LINESTRING (-10000000 -10000000 1, 10000000 10000000 0 )", 0.0, 0.02);
        this.checkDistance("LINESTRING (20000000 10000000 20, 10000000 20000000 10 )", "LINESTRING (10000000 10000000 20, 20000000 20000000 10 )", 0.0);
    }

    public void testTSegmentsFlat() {
        this.checkDistance("LINESTRING (10 10 0, 10 20 0 )", "LINESTRING (20 15 0, 25 15 0 )", 10.0, this.coord(10.0, 15.0, Double.NaN), this.coord(20.0, 15.0, 0.0));
    }

    public void testParallelSegmentsFlat() {
        this.checkDistance("LINESTRING (10 10 0, 20 20 0 )", "LINESTRING (10 20 0, 20 30 0 )", 7.0710678118654755);
    }

    public void testParallelSegments() {
        this.checkDistance("LINESTRING (0 0 0, 1 0 0 )", "LINESTRING (0 0 1, 1 0 1 )", 1.0);
        this.checkDistance("LINESTRING (10 10 0, 20 10 0 )", "LINESTRING (10 20 10, 20 20 10 )", 14.142135623730951);
        this.checkDistance("LINESTRING (10 10 0, 20 20 0 )", "LINESTRING (10 20 10, 20 30 10 )", 12.24744871391589);
    }

    public void testLineLine() {
        this.checkDistance("LINESTRING (0 1 2, 1 1 1, 1 0 2 )", "LINESTRING (0 0 0.1, .5 .5 0, 1 1 0, 1.5 1.5 0, 2 2 0 )", 1.0);
        this.checkDistance("LINESTRING (10 10 20, 20 20 30, 20 20 1, 30 30 5 )", "LINESTRING (1 80 10, 0 39 5, 39 0 5, 80 1 20)", 0.7071067811865476, this.coord(20.0, 20.0, 30.0), this.coord(19.5, 19.5, Double.NaN));
    }

    public void testPointPolygon() {
        this.checkDistance("POINT (150 150 10)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 10.0);
        this.checkDistance("POINT (150 150 -10)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 10.0);
        this.checkDistance("POINT (10 150 150)", "POLYGON ((0 100 200, 0 200 200, 0 200 100, 0 100 100, 0 100 200))", 10.0);
    }

    public void testPointPolygonFlat() {
        this.checkDistance("POINT (150 150 0)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 0.0, this.coord(150.0, 150.0, 0.0), this.coord(150.0, 150.0, 0.0));
        this.checkDistance("POINT (250 250 0)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 70.71067811865476, this.coord(250.0, 250.0, 0.0), this.coord(200.0, 200.0, 0.0));
        this.checkDistance("POINT (200 200 0)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 0.0);
    }

    public void testLinePolygonFlat() {
        this.checkDistance("LINESTRING (150 150 0, 160 160 0)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 0.0);
        this.checkDistance("LINESTRING (200 250 0, 260 260 0)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 50.0, this.coord(200.0, 250.0, 0.0), this.coord(200.0, 200.0, 0.0));
        this.checkDistance("LINESTRING (200 200 0, 260 260 0)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 0.0);
    }

    public void testLinePolygonSimple() {
        this.checkDistance("LINESTRING (150 150 10, 150 150 -10)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 0.0);
        this.checkDistance("LINESTRING (200 200 10, 260 260 100)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 10.0);
        this.checkDistance("LINESTRING (200 200 0, 260 260 100)", "POLYGON ((100 200 0, 200 200 0, 200 100 0, 100 100 0, 100 200 0))", 0.0);
    }

    public void testLinePolygonHoleFlat() {
        this.checkDistance("LINESTRING (150 150 10, 150 150 -10)", this.polyHoleFlat, 30.0, this.coord(150.0, 150.0, 10.0), this.coord(150.0, 180.0, Double.NaN));
        this.checkDistance("LINESTRING (110 110 10, 110 110 -10)", this.polyHoleFlat, 0.0, this.coord(110.0, 110.0, -10.0), this.coord(110.0, 110.0, -10.0));
        this.checkDistance("LINESTRING (130 130 10, 150 150 100)", this.polyHoleFlat, 14.14213562373095, this.coord(130.0, 130.0, 10.0), this.coord(130.0, 120.0, Double.NaN));
        this.checkDistance("LINESTRING (120 180 0, 120 180 100)", this.polyHoleFlat, 0.0, this.coord(120.0, 180.0, 0.0), this.coord(120.0, 180.0, 0.0));
    }

    public void testPointPolygonHoleFlat() {
        this.checkDistance("POINT (130 130 10)", this.polyHoleFlat, 14.14213562373095, this.coord(130.0, 130.0, 10.0), this.coord(130.0, 120.0, Double.NaN));
        this.checkDistance("POINT (130 130 -10)", this.polyHoleFlat, 14.14213562373095, this.coord(130.0, 130.0, -10.0), this.coord(130.0, 120.0, Double.NaN));
        this.checkDistance("POINT (110 110 100)", this.polyHoleFlat, 100.0, this.coord(110.0, 110.0, 100.0), this.coord(110.0, 110.0, 100.0));
    }

    public void testPolygonPolygonLinkedThruHoles() {
        this.checkDistance(this.poly2HoleFlat, "POLYGON ((120 120 -10, 120 120 100, 180 120 100, 180 120 -10, 120 120 -10))", 0.0);
        this.checkDistance(this.poly2HoleFlat, "LINESTRING (120 120 -10, 120 120 100, 180 120 100, 180 120 -10, 120 120 -10)", 10.0);
    }

    public void testMultiPoint() {
        this.checkDistance("MULTIPOINT ((0 0 0), (0 0 100), (100 100 100))", "MULTIPOINT ((100 100 99), (50 50 50), (25 100 33))", 1.0, this.coord(100.0, 100.0, 100.0), this.coord(100.0, 100.0, 99.0));
    }

    public void testMultiLineString() {
        this.checkDistance("MULTILINESTRING ((0 0 0, 10 10 10), (0 0 100, 25 25 25, 40 40 50), (100 100 100, 100 101 102))", "MULTILINESTRING ((100 100 99, 100 100 99), (100 102 102, 200 200 20), (25 100 33, 25 100 35))", 1.0);
    }

    public void testMultiPolygon() {
        this.checkDistance("MULTIPOLYGON ( ((120 120 -10, 120 120 100, 180 120 100, 180 120 -10, 120 120 -10)), ((120 200 -10, 120 200 190, 180 200 190, 180 200 -10, 120 200 -10)) )", "MULTIPOLYGON ( ((100 200 200, 200 200 200, 200 100 200, 100 100 200, 100 200 200)), ((100 200 210, 200 200 210, 200 100 210, 100 100 210, 100 200 210)) )", 10.0);
    }

    public void testMultiMixed() {
        this.checkDistance("MULTILINESTRING ((0 0 0, 10 10 10), (0 0 100, 25 25 25, 40 40 50), (100 100 100, 100 101 101))", "MULTIPOINT ((100 100 99), (50 50 50), (25 100 33))", 1.0, this.coord(100.0, 100.0, 100.0), this.coord(100.0, 100.0, 99.0));
    }

    private void checkDistance(String wkt1, String wkt2, double expectedDistance) {
        this.checkDistance(wkt1, wkt2, expectedDistance, 1.0E-5);
    }

    private void checkDistance(String wkt1, String wkt2, double expectedDistance, Coordinate ... expectedCoordinates) {
        this.checkDistance(wkt1, wkt2, expectedDistance, expectedCoordinates, 1.0E-5);
    }

    private void checkDistance(String wkt1, String wkt2, double expectedDistance, double tolerance) {
        this.checkDistance(wkt1, wkt2, expectedDistance, new Coordinate[0], tolerance);
    }

    private void checkDistance(String wkt1, String wkt2, double expectedDistance, Coordinate[] expectedCoords, double tolerance) {
        Geometry g2;
        Geometry g1;
        try {
            g1 = rdr.read(wkt1);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
        try {
            g2 = rdr.read(wkt2);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
        this.checkDistance(g1, g2, expectedDistance, expectedCoords, tolerance);
        this.checkDistance(g2, g1, expectedDistance, this.reversed(expectedCoords), tolerance);
    }

    private void checkDistance(Geometry g1, Geometry g2, double expectedDistance, Coordinate[] expectedCoords, double tolerance) {
        Distance3DOp distOp = new Distance3DOp(g1, g2);
        double dist = distOp.distance();
        Distance3DOpTest.assertEquals((double)expectedDistance, (double)dist, (double)tolerance);
        if (expectedCoords.length == 2) {
            Coordinate[] nearestCoords = distOp.nearestPoints();
            Distance3DOpTest.assertTrue((boolean)nearestCoords[0].equals2D(expectedCoords[0], tolerance));
            Distance3DOpTest.assertTrue((boolean)nearestCoords[1].equals2D(expectedCoords[1], tolerance));
            if (!Double.isNaN(expectedCoords[0].getZ())) {
                Distance3DOpTest.assertTrue((boolean)nearestCoords[0].equalInZ(expectedCoords[0], tolerance));
            }
            if (!Double.isNaN(expectedCoords[1].getZ())) {
                Distance3DOpTest.assertTrue((boolean)nearestCoords[1].equalInZ(expectedCoords[1], tolerance));
            }
        }
    }

    private Coordinate coord(double x, double y, double z) {
        return new Coordinate(x, y, z);
    }

    private Coordinate[] reversed(Coordinate[] coordinates) {
        Coordinate[] reversed = new Coordinate[coordinates.length];
        int maxIndex = coordinates.length - 1;
        for (int i = 0; i < coordinates.length; ++i) {
            reversed[i] = coordinates[maxIndex - i];
        }
        return reversed;
    }
}

