/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.BoundaryOp;
import test.jts.GeometryTestCase;

public class BoundaryTest
extends GeometryTestCase {
    private static final double TOLERANCE = 5.0E-5;
    private GeometryFactory fact = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.fact);

    public static void main(String[] args) {
        TestRunner.run(BoundaryTest.class);
    }

    public BoundaryTest(String name) {
        super(name);
    }

    public void test1() throws Exception {
        String a = "MULTILINESTRING ((0 0, 10 10), (10 10, 20 20))";
        this.runBoundaryTest(a, BoundaryNodeRule.MULTIVALENT_ENDPOINT_BOUNDARY_RULE, "POINT (10 10)");
    }

    public void test2LinesTouchAtEndpoint2() throws Exception {
        String a = "MULTILINESTRING ((0 0, 10 10), (10 10, 20 20))";
        this.runBoundaryTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT ((0 0), (20 20))");
        this.runBoundaryTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "MULTIPOINT ((0 0), (10 10), (20 20))");
        this.runBoundaryTest(a, BoundaryNodeRule.MONOVALENT_ENDPOINT_BOUNDARY_RULE, "MULTIPOINT ((0 0), (20 20))");
        this.runBoundaryTest(a, BoundaryNodeRule.MULTIVALENT_ENDPOINT_BOUNDARY_RULE, "POINT (10 10)");
    }

    public void test3LinesTouchAtEndpoint2() throws Exception {
        String a = "MULTILINESTRING ((0 0, 10 10), (10 10, 20 20), (10 10, 10 20))";
        this.runBoundaryTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT ((0 0), (10 10), (10 20), (20 20))");
        this.runBoundaryTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "MULTIPOINT ((0 0), (10 10), (10 20), (20 20))");
        this.runBoundaryTest(a, BoundaryNodeRule.MONOVALENT_ENDPOINT_BOUNDARY_RULE, "MULTIPOINT ((0 0), (10 20), (20 20))");
        this.runBoundaryTest(a, BoundaryNodeRule.MULTIVALENT_ENDPOINT_BOUNDARY_RULE, "POINT (10 10)");
    }

    public void testMultiLineStringWithRingTouchAtEndpoint() throws Exception {
        String a = "MULTILINESTRING ((100 100, 20 20, 200 20, 100 100), (100 200, 100 100))";
        this.runBoundaryTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT ((100 100), (100 200))");
        this.runBoundaryTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "MULTIPOINT ((100 100), (100 200))");
    }

    public void testRing() throws Exception {
        String a = "LINESTRING (100 100, 20 20, 200 20, 100 100)";
        this.runBoundaryTest(a, BoundaryNodeRule.MOD2_BOUNDARY_RULE, "MULTIPOINT EMPTY");
        this.runBoundaryTest(a, BoundaryNodeRule.ENDPOINT_BOUNDARY_RULE, "POINT (100 100)");
    }

    public void testHasBoundaryPoint() throws Exception {
        this.checkHasBoundary("POINT (0 0)", false);
    }

    public void testHasBoundaryPointEmpty() throws Exception {
        this.checkHasBoundary("POINT EMPTY", false);
    }

    public void testHasBoundaryRingClosed() throws Exception {
        this.checkHasBoundary("LINESTRING (100 100, 20 20, 200 20, 100 100)", false);
    }

    public void testHasBoundaryMultiLineStringClosed() throws Exception {
        this.checkHasBoundary("MULTILINESTRING ((0 0, 0 1), (0 1, 1 1, 1 0, 0 0))", false);
    }

    public void testHasBoundaryMultiLineStringOpen() throws Exception {
        this.checkHasBoundary("MULTILINESTRING ((0 0, 0 2), (0 1, 1 1, 1 0, 0 0))");
    }

    public void testHasBoundaryPolygon() throws Exception {
        this.checkHasBoundary("POLYGON ((1 9, 9 9, 9 1, 1 1, 1 9))");
    }

    public void testHasBoundaryPolygonEmpty() throws Exception {
        this.checkHasBoundary("POLYGON EMPTY", false);
    }

    private void runBoundaryTest(String wkt, BoundaryNodeRule bnRule, String wktExpected) throws ParseException {
        Geometry g = this.rdr.read(wkt);
        Geometry expected = this.rdr.read(wktExpected);
        BoundaryOp op = new BoundaryOp(g, bnRule);
        Geometry boundary = op.getBoundary();
        boundary.normalize();
        BoundaryTest.assertTrue((boolean)boundary.equalsExact(expected));
    }

    private void checkHasBoundary(String wkt) {
        this.checkHasBoundary(wkt, BoundaryNodeRule.MOD2_BOUNDARY_RULE, true);
    }

    private void checkHasBoundary(String wkt, boolean expected) {
        this.checkHasBoundary(wkt, BoundaryNodeRule.MOD2_BOUNDARY_RULE, expected);
    }

    private void checkHasBoundary(String wkt, BoundaryNodeRule bnRule, boolean expected) {
        Geometry g = this.read(wkt);
        BoundaryTest.assertEquals((boolean)expected, (boolean)BoundaryOp.hasBoundary(g, bnRule));
    }
}

