/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;

public class SpatialIndexTester {
    private static boolean VERBOSE = false;
    private SpatialIndex index;
    private ArrayList sourceData;
    private boolean isSuccess = true;
    private static final double CELL_EXTENT = 20.31;
    private static final int CELLS_PER_GRID_SIDE = 10;
    private static final double FEATURE_EXTENT = 10.1;
    private static final double OFFSET = 5.03;
    private static final double QUERY_ENVELOPE_EXTENT_1 = 1.009;
    private static final double QUERY_ENVELOPE_EXTENT_2 = 11.7;

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setSpatialIndex(SpatialIndex index) {
        this.index = index;
    }

    public SpatialIndex getSpatialIndex() {
        return this.index;
    }

    public void init() {
        this.sourceData = new ArrayList();
        this.addSourceData(0.0, this.sourceData);
        this.addSourceData(5.03, this.sourceData);
        if (VERBOSE) {
            // empty if block
        }
        this.insert(this.sourceData, this.index);
    }

    public void run() {
        this.doTest(this.index, 1.009, this.sourceData);
        this.doTest(this.index, 11.7, this.sourceData);
    }

    private void insert(List sourceData, SpatialIndex index) {
        for (Envelope envelope : sourceData) {
            index.insert(envelope, envelope);
        }
    }

    private void addSourceData(double offset, List sourceData) {
        for (int i = 0; i < 10; ++i) {
            double minx = (double)i * 20.31 + offset;
            double maxx = minx + 10.1;
            for (int j = 0; j < 10; ++j) {
                double miny = (double)j * 20.31 + offset;
                double maxy = miny + 10.1;
                Envelope e = new Envelope(minx, maxx, miny, maxy);
                sourceData.add(e);
            }
        }
    }

    private void doTest(SpatialIndex index, double queryEnvelopeExtent, List sourceData) {
        int extraMatchCount = 0;
        int expectedMatchCount = 0;
        int actualMatchCount = 0;
        int queryCount = 0;
        int x = 0;
        while ((double)x < 203.1) {
            int y = 0;
            while ((double)y < 203.1) {
                Envelope queryEnvelope = new Envelope(x, (double)x + queryEnvelopeExtent, y, (double)y + queryEnvelopeExtent);
                List expectedMatches = this.intersectingEnvelopes(queryEnvelope, sourceData);
                List actualMatches = index.query(queryEnvelope);
                if (expectedMatches.size() > actualMatches.size()) {
                    this.isSuccess = false;
                }
                extraMatchCount += actualMatches.size() - expectedMatches.size();
                expectedMatchCount += expectedMatches.size();
                actualMatchCount += actualMatches.size();
                this.compare(expectedMatches, actualMatches);
                ++queryCount;
                y = (int)((double)y + queryEnvelopeExtent);
            }
            x = (int)((double)x + queryEnvelopeExtent);
        }
        if (VERBOSE) {
            // empty if block
        }
    }

    private void compare(List expectedEnvelopes, List actualEnvelopes) {
        for (Envelope expected : expectedEnvelopes) {
            boolean found = false;
            for (Envelope actual : actualEnvelopes) {
                if (!actual.equals(expected)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.isSuccess = false;
        }
    }

    private List intersectingEnvelopes(Envelope queryEnvelope, List envelopes) {
        ArrayList<Envelope> intersectingEnvelopes = new ArrayList<Envelope>();
        for (Envelope candidate : envelopes) {
            if (!candidate.intersects(queryEnvelope)) continue;
            intersectingEnvelopes.add(candidate);
        }
        return intersectingEnvelopes;
    }
}

