/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.List;
import junit.framework.TestCase;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryExtracter;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryExtracterTest
extends TestCase {
    static WKTReader reader = new WKTReader();

    public GeometryExtracterTest(String name) {
        super(name);
    }

    public void testExtract() throws ParseException {
        Geometry gc = reader.read("GEOMETRYCOLLECTION ( POINT (1 1), LINESTRING (0 0, 10 10), LINESTRING (10 10, 20 20), LINEARRING (10 10, 20 20, 15 15, 10 10), POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0)), GEOMETRYCOLLECTION ( POINT (1 1) ) )");
        List lineStringsAndLinearRings = GeometryExtracter.extract(gc, "LineString");
        GeometryExtracterTest.assertEquals((int)3, (int)lineStringsAndLinearRings.size());
        List linearRings = GeometryExtracter.extract(gc, "LinearRing");
        GeometryExtracterTest.assertEquals((int)1, (int)linearRings.size());
        List points = GeometryExtracter.extract(gc, "Point");
        GeometryExtracterTest.assertEquals((int)2, (int)points.size());
    }
}

