/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;

public class SegmentDensifier {
    private LineString inputLine;
    private CoordinateList newCoords;

    public SegmentDensifier(LineString line) {
        this.inputLine = line;
    }

    public Geometry densify(double segLength) {
        this.newCoords = new CoordinateList();
        CoordinateSequence seq = this.inputLine.getCoordinateSequence();
        Coordinate p0 = new Coordinate();
        Coordinate p1 = new Coordinate();
        seq.getCoordinate(0, p0);
        this.newCoords.add(new Coordinate(p0));
        for (int i = 0; i < seq.size() - 1; ++i) {
            seq.getCoordinate(i, p0);
            seq.getCoordinate(i + 1, p1);
            this.densify(p0, p1, segLength);
        }
        Coordinate[] newPts = this.newCoords.toCoordinateArray();
        return this.inputLine.getFactory().createLineString(newPts);
    }

    private void densify(Coordinate p0, Coordinate p1, double segLength) {
        double origLen = p1.distance(p0);
        int nPtsToAdd = (int)Math.floor(origLen / segLength);
        double delx = p1.x - p0.x;
        double dely = p1.y - p0.y;
        double segLenFrac = segLength / origLen;
        for (int i = 0; i <= nPtsToAdd; ++i) {
            double addedPtFrac = (double)i * segLenFrac;
            Coordinate pt = new Coordinate(p0.x + addedPtFrac * delx, p0.y + addedPtFrac * dely);
            this.newCoords.add(pt, false);
        }
        this.newCoords.add(new Coordinate(p1), false);
    }
}

