/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.SegmentDensifier;
import org.locationtech.jts.io.WKTReader;

public class RectanglePredicateSyntheticTest
extends TestCase {
    private WKTReader rdr = new WKTReader();
    private GeometryFactory fact = new GeometryFactory();
    double baseX = 10.0;
    double baseY = 10.0;
    double rectSize = 20.0;
    double bufSize = 10.0;
    double testGeomSize = 10.0;
    double bufferWidth = 1.0;
    Envelope rectEnv = new Envelope(this.baseX, this.baseX + this.rectSize, this.baseY, this.baseY + this.rectSize);
    Geometry rect = this.fact.toGeometry(this.rectEnv);

    public static void main(String[] args) {
        TestRunner.run(RectanglePredicateSyntheticTest.class);
    }

    public RectanglePredicateSyntheticTest(String name) {
        super(name);
    }

    public void testLines() {
        List testGeoms = this.getTestGeometries();
        for (Geometry testGeom : testGeoms) {
            this.runRectanglePredicates(this.rect, testGeom);
        }
    }

    public void testDenseLines() {
        List testGeoms = this.getTestGeometries();
        for (Geometry testGeom : testGeoms) {
            SegmentDensifier densifier = new SegmentDensifier((LineString)testGeom);
            LineString denseLine = (LineString)densifier.densify(this.testGeomSize / 400.0);
            this.runRectanglePredicates(this.rect, denseLine);
        }
    }

    public void testPolygons() {
        List testGeoms = this.getTestGeometries();
        for (Geometry testGeom : testGeoms) {
            this.runRectanglePredicates(this.rect, testGeom.buffer(this.bufferWidth));
        }
    }

    private List getTestGeometries() {
        Envelope testEnv = new Envelope(this.rectEnv.getMinX() - this.bufSize, this.rectEnv.getMaxX() + this.bufSize, this.rectEnv.getMinY() - this.bufSize, this.rectEnv.getMaxY() + this.bufSize);
        List testGeoms = this.createTestGeometries(testEnv, 5.0, this.testGeomSize);
        return testGeoms;
    }

    private void runRectanglePredicates(Geometry rect, Geometry testGeom) {
        boolean containsOK;
        boolean relateIntersectsValue;
        boolean intersectsValue = rect.intersects(testGeom);
        boolean intersectsOK = intersectsValue == (relateIntersectsValue = rect.relate(testGeom).isIntersects());
        boolean containsValue = rect.contains(testGeom);
        boolean relateContainsValue = rect.relate(testGeom).isContains();
        boolean bl = containsOK = containsValue == relateContainsValue;
        if (!intersectsOK || !containsOK) {
            System.out.println(testGeom);
        }
        RectanglePredicateSyntheticTest.assertTrue((boolean)intersectsOK);
        RectanglePredicateSyntheticTest.assertTrue((boolean)containsOK);
    }

    public List createTestGeometries(Envelope env, double inc, double size) {
        ArrayList<Geometry> testGeoms = new ArrayList<Geometry>();
        for (double y = env.getMinY(); y <= env.getMaxY(); y += inc) {
            for (double x = env.getMinX(); x <= env.getMaxX(); x += inc) {
                Coordinate base = new Coordinate(x, y);
                testGeoms.add(this.createAngle(base, size, 0));
                testGeoms.add(this.createAngle(base, size, 1));
                testGeoms.add(this.createAngle(base, size, 2));
                testGeoms.add(this.createAngle(base, size, 3));
            }
        }
        return testGeoms;
    }

    public Geometry createAngle(Coordinate base, double size, int quadrant) {
        int[][] factor = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};
        int xFac = factor[quadrant][0];
        int yFac = factor[quadrant][1];
        Coordinate p0 = new Coordinate(base.x + (double)xFac * size, base.y + (double)yFac * size);
        Coordinate p2 = new Coordinate(base.x + (double)yFac * size, base.y + (double)(-xFac) * size);
        return this.fact.createLineString(new Coordinate[]{p0, base, p2});
    }
}

