/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryFactoryTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel();
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run(GeometryFactoryTest.class);
    }

    public GeometryFactoryTest(String name) {
        super(name);
    }

    public void testCreateGeometry() throws ParseException {
        this.checkCreateGeometryExact("POINT EMPTY");
        this.checkCreateGeometryExact("POINT ( 10 20 )");
        this.checkCreateGeometryExact("LINESTRING EMPTY");
        this.checkCreateGeometryExact("LINESTRING(0 0, 10 10)");
        this.checkCreateGeometryExact("MULTILINESTRING ((50 100, 100 200), (100 100, 150 200))");
        this.checkCreateGeometryExact("POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200))");
        this.checkCreateGeometryExact("MULTIPOLYGON (((100 200, 200 200, 200 100, 100 100, 100 200)), ((300 200, 400 200, 400 100, 300 100, 300 200)))");
        this.checkCreateGeometryExact("GEOMETRYCOLLECTION (POLYGON ((100 200, 200 200, 200 100, 100 100, 100 200)), LINESTRING (250 100, 350 200), POINT (350 150))");
    }

    public void testCreateEmpty() {
        this.checkEmpty(this.geometryFactory.createEmpty(0), Point.class);
        this.checkEmpty(this.geometryFactory.createEmpty(1), LineString.class);
        this.checkEmpty(this.geometryFactory.createEmpty(2), Polygon.class);
        this.checkEmpty(this.geometryFactory.createPoint(), Point.class);
        this.checkEmpty(this.geometryFactory.createLineString(), LineString.class);
        this.checkEmpty(this.geometryFactory.createPolygon(), Polygon.class);
        this.checkEmpty(this.geometryFactory.createMultiPoint(), MultiPoint.class);
        this.checkEmpty(this.geometryFactory.createMultiLineString(), MultiLineString.class);
        this.checkEmpty(this.geometryFactory.createMultiPolygon(), MultiPolygon.class);
        this.checkEmpty(this.geometryFactory.createGeometryCollection(), GeometryCollection.class);
    }

    private void checkEmpty(Geometry geom, Class clz) {
        GeometryFactoryTest.assertTrue((boolean)geom.isEmpty());
        GeometryFactoryTest.assertTrue((geom.getClass() == clz ? 1 : 0) != 0);
    }

    public void testDeepCopy() throws ParseException {
        Point g = (Point)this.read("POINT ( 10 10) ");
        Geometry g2 = this.geometryFactory.createGeometry(g);
        g.getCoordinateSequence().setOrdinate(0, 0, 99.0);
        GeometryFactoryTest.assertTrue((!g.equalsExact(g2) ? 1 : 0) != 0);
    }

    public void testMultiPointCS() {
        GeometryFactory gf = new GeometryFactory(new PackedCoordinateSequenceFactory());
        CoordinateSequence mpSeq = gf.getCoordinateSequenceFactory().create(1, 4);
        mpSeq.setOrdinate(0, 0, 50.0);
        mpSeq.setOrdinate(0, 1, -2.0);
        mpSeq.setOrdinate(0, 2, 10.0);
        mpSeq.setOrdinate(0, 3, 20.0);
        MultiPoint mp = gf.createMultiPoint(mpSeq);
        CoordinateSequence pSeq = ((Point)mp.getGeometryN(0)).getCoordinateSequence();
        GeometryFactoryTest.assertEquals((int)4, (int)pSeq.getDimension());
        for (int i = 0; i < 4; ++i) {
            GeometryFactoryTest.assertEquals((Object)mpSeq.getOrdinate(0, i), (Object)pSeq.getOrdinate(0, i));
        }
    }

    public void testCopyGeometryWithNonDefaultDimension() throws ParseException {
        GeometryFactory gf = new GeometryFactory(CoordinateArraySequenceFactory.instance());
        CoordinateSequence mpSeq = gf.getCoordinateSequenceFactory().create(1, 2);
        mpSeq.setOrdinate(0, 0, 50.0);
        mpSeq.setOrdinate(0, 1, -2.0);
        Point g = gf.createPoint(mpSeq);
        CoordinateSequence pSeq = ((Point)g.getGeometryN(0)).getCoordinateSequence();
        GeometryFactoryTest.assertEquals((int)2, (int)pSeq.getDimension());
        Point g2 = (Point)this.geometryFactory.createGeometry(g);
        GeometryFactoryTest.assertEquals((int)2, (int)g2.getCoordinateSequence().getDimension());
    }

    private void checkCreateGeometryExact(String wkt) throws ParseException {
        Geometry g = this.read(wkt);
        Geometry g2 = this.geometryFactory.createGeometry(g);
        GeometryFactoryTest.assertTrue((boolean)g.equalsExact(g2));
    }

    private Geometry read(String wkt) throws ParseException {
        return this.reader.read(wkt);
    }
}

