/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.generator;

import org.locationtech.jts.generator.GeometryGenerator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;

public class LineStringGenerator
extends GeometryGenerator {
    protected int numberPoints = 2;
    protected int generationAlgorithm = 0;
    public static final int VERT = 1;
    public static final int HORZ = 2;
    public static final int ARC = 0;
    private static final int RUNS = 5;

    @Override
    public Geometry create() {
        if (this.geometryFactory == null) {
            throw new NullPointerException("GeometryFactory is not declared");
        }
        if (this.boundingBox == null || this.boundingBox.isNull()) {
            throw new NullPointerException("Bounding Box is not declared");
        }
        if (this.numberPoints < 2) {
            throw new IllegalStateException("Too few points");
        }
        Coordinate[] coords = new Coordinate[this.numberPoints];
        double x = this.boundingBox.getMinX();
        double dx = this.boundingBox.getMaxX() - x;
        double y = this.boundingBox.getMinY();
        double dy = this.boundingBox.getMaxY() - y;
        for (int i = 0; i < 5; ++i) {
            switch (this.getGenerationAlgorithm()) {
                case 1: {
                    LineStringGenerator.fillVert(x, dx, y, dy, coords, this.geometryFactory);
                    break;
                }
                case 2: {
                    LineStringGenerator.fillHorz(x, dx, y, dy, coords, this.geometryFactory);
                    break;
                }
                case 0: {
                    LineStringGenerator.fillArc(x, dx, y, dy, coords, this.geometryFactory);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Alg. Specified");
                }
            }
            LineString ls = this.geometryFactory.createLineString(coords);
            IsValidOp valid = new IsValidOp(ls);
            if (!valid.isValid()) continue;
            return ls;
        }
        return null;
    }

    private static void fillVert(double x, double dx, double y, double dy, Coordinate[] coords, GeometryFactory gf) {
        double fx = x + Math.random() * dx;
        double ry = dy;
        coords[0] = new Coordinate(fx, y);
        gf.getPrecisionModel().makePrecise(coords[0]);
        for (int i = 1; i < coords.length - 1; ++i) {
            ry -= Math.random() * ry;
            coords[i] = new Coordinate(fx, y + dy - ry);
            gf.getPrecisionModel().makePrecise(coords[i]);
        }
        coords[coords.length - 1] = new Coordinate(fx, y + dy);
        gf.getPrecisionModel().makePrecise(coords[coords.length - 1]);
    }

    private static void fillHorz(double x, double dx, double y, double dy, Coordinate[] coords, GeometryFactory gf) {
        double fy = y + Math.random() * dy;
        double rx = dx;
        coords[0] = new Coordinate(x, fy);
        gf.getPrecisionModel().makePrecise(coords[0]);
        for (int i = 1; i < coords.length - 1; ++i) {
            rx -= Math.random() * rx;
            coords[i] = new Coordinate(x + dx - rx, fy);
            gf.getPrecisionModel().makePrecise(coords[i]);
        }
        coords[coords.length - 1] = new Coordinate(x + dx, fy);
        gf.getPrecisionModel().makePrecise(coords[coords.length - 1]);
    }

    private static void fillArc(double x, double dx, double y, double dy, Coordinate[] coords, GeometryFactory gf) {
        if (coords.length == 2) {
            throw new IllegalStateException("Too few points for Arc");
        }
        double theta = 360 / coords.length;
        double start = theta / 2.0;
        double radius = dx < dy ? dx / 3.0 : dy / 3.0;
        double cx = x + dx / 2.0;
        double cy = y + dy / 2.0;
        for (int i = 0; i < coords.length; ++i) {
            double angle = Math.toRadians(start + theta * (double)i);
            double fx = Math.sin(angle) * radius;
            double fy = Math.cos(angle) * radius;
            coords[i] = new Coordinate(cx + fx, cy + fy);
            gf.getPrecisionModel().makePrecise(coords[i]);
        }
    }

    public int getNumberPoints() {
        return this.numberPoints;
    }

    public void setNumberPoints(int numberPoints) {
        this.numberPoints = numberPoints;
    }

    public int getGenerationAlgorithm() {
        return this.generationAlgorithm;
    }

    public void setGenerationAlgorithm(int generationAlgorithm) {
        this.generationAlgorithm = generationAlgorithm;
    }
}

