/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.Arrays;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.shape.random.RandomPointsBuilder;

public class AngleTest
extends TestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(AngleTest.class);
    }

    public AngleTest(String name) {
        super(name);
    }

    public void testAngle() {
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(10.0, 0.0)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(10.0, 10.0)), (double)0.7853981633974483, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(0.0, 10.0)), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(-10.0, 10.0)), (double)2.356194490192345, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(-10.0, 0.0)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(-10.0, -0.1)), (double)-3.131592986903128, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle(new Coordinate(-10.0, -10.0)), (double)-2.356194490192345, (double)1.0E-5);
    }

    public void testIsAcute() {
        AngleTest.assertEquals((boolean)Angle.isAcute(new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(5.0, 10.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute(new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(5.0, -10.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute(new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(10.0, 0.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute(new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(-5.0, 10.0)), (boolean)false);
        AngleTest.assertEquals((boolean)Angle.isAcute(new Coordinate(10.0, 0.0), new Coordinate(0.0, 0.0), new Coordinate(-5.0, -10.0)), (boolean)false);
    }

    public void testNormalizePositive() {
        AngleTest.assertEquals((double)Angle.normalizePositive(0.0), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(-1.5707963267948966), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(-Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(-4.71238898038469), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI * -2), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(-7.853981633974483), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI * -3), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI * -4), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(1.5707963267948966), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(4.71238898038469), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI * 2), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(7.853981633974483), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI * 3), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive(Math.PI * 4), (double)0.0, (double)1.0E-5);
    }

    public void testNormalize() {
        AngleTest.assertEquals((double)Angle.normalize(0.0), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(-1.5707963267948966), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(-Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(-4.71238898038469), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI * -2), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(-7.853981633974483), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI * -3), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI * -4), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(1.5707963267948966), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(4.71238898038469), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI * 2), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(7.853981633974483), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI * 3), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize(Math.PI * 4), (double)0.0, (double)1.0E-5);
    }

    public void testInteriorAngle() {
        CoordinateXY p1 = new CoordinateXY(1.0, 2.0);
        CoordinateXY p2 = new CoordinateXY(3.0, 2.0);
        CoordinateXY p3 = new CoordinateXY(2.0, 1.0);
        AngleTest.assertEquals((double)45.0, (double)Math.toDegrees(Angle.interiorAngle(p1, p2, p3)), (double)0.01);
        AngleTest.assertEquals((double)90.0, (double)Math.toDegrees(Angle.interiorAngle(p2, p3, p1)), (double)0.01);
        AngleTest.assertEquals((double)45.0, (double)Math.toDegrees(Angle.interiorAngle(p3, p1, p2)), (double)0.01);
        AngleTest.assertEquals((double)315.0, (double)Math.toDegrees(Angle.interiorAngle(p3, p2, p1)), (double)0.01);
        AngleTest.assertEquals((double)270.0, (double)Math.toDegrees(Angle.interiorAngle(p1, p3, p2)), (double)0.01);
        AngleTest.assertEquals((double)315.0, (double)Math.toDegrees(Angle.interiorAngle(p2, p1, p3)), (double)0.01);
    }

    public void testInteriorAngle_randomTriangles() {
        GeometryFactory geometryFactory = new GeometryFactory();
        CoordinateSequenceFactory coordinateSequenceFactory = geometryFactory.getCoordinateSequenceFactory();
        for (int i = 0; i < 100; ++i) {
            RandomPointsBuilder builder = new RandomPointsBuilder();
            builder.setNumPoints(3);
            Geometry threeRandomPoints = builder.getGeometry();
            Polygon triangle = geometryFactory.createPolygon(CoordinateSequences.ensureValidRing(coordinateSequenceFactory, coordinateSequenceFactory.create(threeRandomPoints.getCoordinates())));
            Object[] c = Orientation.isCCW(triangle.getCoordinates()) ? triangle.reverse().getCoordinates() : triangle.getCoordinates();
            double sumOfInteriorAngles = Angle.interiorAngle(c[0], c[1], c[2]) + Angle.interiorAngle(c[1], c[2], c[0]) + Angle.interiorAngle(c[2], c[0], c[1]);
            AngleTest.assertEquals((String)(i + ": The sum of the angles of a triangle is not equal to two right angles for points: " + Arrays.toString(c)), (double)Math.PI, (double)sumOfInteriorAngles, (double)0.01);
        }
    }
}

