/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.UnitFormat;
import tec.uom.se.format.SimpleUnitFormat;
import tec.uom.se.function.AddConverter;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.BaseUnit;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;

public abstract class GeoToolsUnitFormat
extends SimpleUnitFormat {
    private static BaseGT2Format INSTANCE = new BaseGT2Format();

    public static SimpleUnitFormat getInstance() {
        return INSTANCE;
    }

    static {
        INSTANCE.initUnits(SimpleUnitFormat.getInstance());
    }

    protected static class BaseGT2Format
    extends SimpleUnitFormat.DefaultFormat {
        HashMap<Unit, String> unitToName = new HashMap();

        protected void initUnits(UnitFormat base) {
            try {
                Field nameToUnitField = SimpleUnitFormat.DefaultFormat.class.getDeclaredField("_nameToUnit");
                nameToUnitField.setAccessible(true);
                HashMap nameToUnitMap = (HashMap)nameToUnitField.get(base);
                Field unitToNameField = SimpleUnitFormat.DefaultFormat.class.getDeclaredField("_unitToName");
                unitToNameField.setAccessible(true);
                HashMap unitToNameMap = (HashMap)unitToNameField.get(base);
                for (Map.Entry entry : nameToUnitMap.entrySet()) {
                    String name = (String)entry.getKey();
                    Unit unit = (Unit)entry.getValue();
                    if (unitToNameMap.containsKey(unit) && name.equals(unitToNameMap.get(unit))) {
                        this.label(unit, name);
                        this.addUnit(unit);
                        continue;
                    }
                    this.alias(unit, name);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to initialize the NetCDF format unit parser with the same values as the default one", t);
            }
        }

        protected void addUnit(Unit<?> unit) {
        }

        @Override
        public void label(Unit<?> unit, String label) {
            super.label(unit, label);
            this.unitToName.put(unit, label);
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            boolean start = true;
            for (int i = 0; i < productUnit.getUnitCount(); ++i) {
                int pow = productUnit.getUnitPow(i);
                if (!start) {
                    appendable.append('*');
                }
                name = this.nameFor(productUnit.getUnit(i));
                int root = productUnit.getUnitRoot(i);
                this.append(appendable, name, pow, root);
                start = false;
            }
            return appendable;
        }

        private void append(Appendable appendable, CharSequence symbol, int pow, int root) throws IOException {
            appendable.append(symbol);
            if (pow != 1 || root != 1) {
                appendable.append('^');
                appendable.append(String.valueOf(pow));
                if (root != 1) {
                    appendable.append(':');
                    appendable.append(String.valueOf(root));
                }
            }
        }

        @Override
        protected String nameFor(Unit<?> unit) {
            String label = this.unitToName.get(unit);
            if (label != null) {
                return label;
            }
            if (unit instanceof BaseUnit) {
                return ((BaseUnit)unit).getSymbol();
            }
            if (unit instanceof AlternateUnit) {
                return ((AlternateUnit)unit).getSymbol();
            }
            if (unit instanceof TransformedUnit) {
                TransformedUnit tfmUnit = (TransformedUnit)unit;
                Unit baseUnit = tfmUnit.getParentUnit();
                UnitConverter cvtr = tfmUnit.getConverter();
                StringBuilder result = new StringBuilder();
                String baseUnitName = this.format(baseUnit);
                String prefix = this.prefixFor(cvtr);
                if (baseUnitName.indexOf(183) >= 0 || baseUnitName.indexOf(42) >= 0 || baseUnitName.indexOf(47) >= 0) {
                    result.append('(');
                    result.append(baseUnitName);
                    result.append(')');
                } else {
                    result.append(baseUnitName);
                }
                if (prefix != null) {
                    result.insert(0, prefix);
                } else if (cvtr instanceof AddConverter) {
                    result.append('+');
                    result.append(((AddConverter)cvtr).getOffset());
                } else if (cvtr instanceof RationalConverter) {
                    double divisor;
                    double dividend = ((RationalConverter)cvtr).getDividend().doubleValue();
                    if (dividend != 1.0) {
                        result.append('*');
                        result.append(dividend);
                    }
                    if ((divisor = ((RationalConverter)cvtr).getDivisor().doubleValue()) != 1.0) {
                        result.append('/');
                        result.append(divisor);
                    }
                } else if (cvtr instanceof MultiplyConverter) {
                    result.append('*');
                    result.append(((MultiplyConverter)cvtr).getFactor());
                } else {
                    return "[" + baseUnit + "?]";
                }
                return result.toString();
            }
            return null;
        }
    }
}

