/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Displacement;
import org.opengis.style.ExternalGraphic;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Mark;
import org.opengis.util.Cloneable;

public class GraphicImpl
implements Graphic,
Cloneable {
    private final List<GraphicalSymbol> graphics = new ArrayList<GraphicalSymbol>();
    private AnchorPointImpl anchor;
    private Expression gap;
    private Expression initialGap;
    private Expression rotation = null;
    private Expression size = null;
    private DisplacementImpl displacement = null;
    private Expression opacity = null;

    protected GraphicImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public GraphicImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    public GraphicImpl(FilterFactory factory, org.opengis.style.AnchorPoint anchor, Expression gap, Expression initialGap) {
        this.anchor = AnchorPointImpl.cast(anchor);
        this.gap = gap == null ? ConstantExpression.constant(0) : gap;
        this.initialGap = initialGap == null ? ConstantExpression.constant(0) : initialGap;
    }

    @Override
    public List<GraphicalSymbol> graphicalSymbols() {
        return this.graphics;
    }

    @Override
    public AnchorPointImpl getAnchorPoint() {
        return this.anchor;
    }

    public void setAnchorPoint(AnchorPoint anchor) {
        this.anchor = AnchorPointImpl.cast(anchor);
    }

    @Override
    public void setAnchorPoint(org.opengis.style.AnchorPoint anchorPoint) {
        this.anchor = AnchorPointImpl.cast(anchorPoint);
    }

    @Override
    public Expression getOpacity() {
        return this.opacity;
    }

    @Override
    public Expression getRotation() {
        return this.rotation;
    }

    @Override
    public Expression getSize() {
        return this.size;
    }

    @Override
    public DisplacementImpl getDisplacement() {
        return this.displacement;
    }

    @Override
    public Expression getInitialGap() {
        return this.initialGap;
    }

    @Override
    public void setInitialGap(Expression initialGap) {
        this.initialGap = initialGap;
    }

    @Override
    public Expression getGap() {
        return this.gap;
    }

    @Override
    public void setGap(Expression gap) {
        this.gap = gap;
    }

    @Override
    public void setDisplacement(Displacement offset) {
        this.displacement = DisplacementImpl.cast(offset);
    }

    @Override
    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    @Override
    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setSize(Expression size) {
        this.size = size;
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        GraphicImpl clone;
        try {
            clone = (GraphicImpl)super.clone();
            clone.graphics.clear();
            clone.graphics.addAll(this.graphics);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.graphics != null) {
            result = 1000003 * result + this.graphics.hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof GraphicImpl) {
            GraphicImpl other = (GraphicImpl)oth;
            return Utilities.equals(this.size, other.size) && Utilities.equals(this.rotation, other.rotation) && Utilities.equals(this.opacity, other.opacity) && Objects.equals(this.graphicalSymbols(), other.graphicalSymbols());
        }
        return false;
    }

    static GraphicImpl cast(org.opengis.style.Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        if (graphic instanceof GraphicImpl) {
            return (GraphicImpl)graphic;
        }
        GraphicImpl copy = new GraphicImpl();
        copy.setAnchorPoint(graphic.getAnchorPoint());
        copy.setDisplacement(graphic.getDisplacement());
        if (graphic.graphicalSymbols() != null) {
            for (GraphicalSymbol item : graphic.graphicalSymbols()) {
                if (item instanceof ExternalGraphic) {
                    copy.graphicalSymbols().add(ExternalGraphicImpl.cast(item));
                    continue;
                }
                if (!(item instanceof Mark)) continue;
                copy.graphicalSymbols().add(MarkImpl.cast(item));
            }
        }
        return copy;
    }
}

