/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.TimeZone;
import java.util.logging.Level;
import org.geotools.data.shapefile.IndexManager;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShapefileFeatureReader;
import org.geotools.data.shapefile.ShapefileFeatureWriter;
import org.geotools.data.shapefile.fid.FidIndexer;
import org.geotools.data.shapefile.fid.IndexedFidWriter;
import org.geotools.data.shapefile.files.FileWriter;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.StorageFile;
import org.geotools.util.URLs;
import org.opengis.feature.simple.SimpleFeature;

class IndexedShapefileFeatureWriter
extends ShapefileFeatureWriter
implements FileWriter {
    private IndexedFidWriter fidWriter;
    private String currentFid;
    private IndexManager indexes;

    public IndexedShapefileFeatureWriter(IndexManager indexes, ShapefileFeatureReader featureReader, Charset charset, TimeZone timeZone) throws IOException {
        super(indexes.shpFiles, featureReader, charset, timeZone);
        this.indexes = indexes;
        if (!indexes.shpFiles.isLocal()) {
            this.fidWriter = IndexedFidWriter.EMPTY_WRITER;
        } else {
            StorageFile storageFile = this.shpFiles.getStorageFile(ShpFileType.FIX);
            this.storageFiles.put(ShpFileType.FIX, storageFile);
            this.fidWriter = new IndexedFidWriter(this.shpFiles, storageFile);
        }
    }

    @Override
    public SimpleFeature next() throws IOException {
        if (this.featureReader == null) {
            throw new IOException("Writer closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        long next = this.fidWriter.next();
        this.currentFid = this.getFeatureType().getTypeName() + "." + next;
        SimpleFeature feature = super.next();
        return feature;
    }

    @Override
    protected String nextFeatureId() {
        return this.currentFid;
    }

    @Override
    public void remove() throws IOException {
        this.fidWriter.remove();
        super.remove();
    }

    @Override
    public void write() throws IOException {
        this.fidWriter.write();
        super.write();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fidWriter.close();
        try {
            if (this.shpFiles.isLocal()) {
                if (this.indexes.isIndexStale(ShpFileType.FIX)) {
                    FidIndexer.generate(this.shpFiles);
                }
                this.deleteFile(ShpFileType.QIX);
            }
        }
        catch (Throwable e) {
            ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "Error creating Spatial index", e);
        }
    }

    @Override
    protected void doClose() throws IOException {
        super.doClose();
        try {
            this.fidWriter.close();
        }
        catch (Throwable e) {
            ShapefileDataStoreFactory.LOGGER.log(Level.WARNING, "Error creating Feature ID index", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(ShpFileType shpFileType) {
        URL url = this.shpFiles.acquireWrite(shpFileType, this);
        try {
            File toDelete = URLs.urlToFile(url);
            if (toDelete.exists()) {
                toDelete.delete();
            }
        }
        finally {
            this.shpFiles.unlockWrite(url, (FileWriter)this);
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }
}

