/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.coverage.io.CoverageRequest;
import org.geotools.data.util.NullProgressListener;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.util.ProgressListener;

public class CoverageResponse {
    private List<Exception> exceptions = Collections.synchronizedList(new ArrayList());
    private String handle = null;
    private CoverageRequest originatingRequest = null;
    private List<GridCoverage> results = Collections.synchronizedList(new ArrayList());
    private Status status = Status.UNAVAILABLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Exception> getExceptions() {
        List<Exception> list = this.exceptions;
        synchronized (list) {
            return new ArrayList<Exception>(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptions(Collection<Exception> exceptions) {
        List<Exception> list = this.exceptions;
        synchronized (list) {
            this.exceptions.addAll(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(Exception exception) {
        List<Exception> list = this.exceptions;
        synchronized (list) {
            this.exceptions.add(exception);
        }
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public CoverageRequest getRequest() {
        return this.originatingRequest;
    }

    public void setRequest(CoverageRequest coverageRequest) {
        this.originatingRequest = coverageRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends Coverage> getResults(ProgressListener listener) {
        if (listener == null) {
            listener = new NullProgressListener();
        }
        listener.started();
        try {
            List<GridCoverage> list = this.results;
            synchronized (list) {
                ArrayList<GridCoverage> arrayList = new ArrayList<GridCoverage>(this.results);
                return arrayList;
            }
        }
        finally {
            listener.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(Collection<GridCoverage> results) {
        List<GridCoverage> list = this.results;
        synchronized (list) {
            this.results.addAll(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(GridCoverage grid) {
        List<GridCoverage> list = this.results;
        synchronized (list) {
            this.results.add(grid);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static enum Status {
        FAILURE,
        WARNING,
        SUCCESS,
        UNAVAILABLE;

    }
}

