/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.ResourceLoader;
import org.apache.fontbox.util.autodetect.FontFileFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontManager {
    private static final Log LOG = LogFactory.getLog(FontManager.class);
    private static HashMap<String, String> ttfFontfiles = new HashMap();
    private static boolean fontsLoaded = false;
    private static HashMap<String, String> fontMappingTTF = new HashMap();

    private FontManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFonts() {
        try {
            FontFileFinder fontfinder = new FontFileFinder();
            List<URI> fonts = fontfinder.find();
            for (URI font : fonts) {
                try {
                    String fontfilename = new File(font).getPath();
                    if (fontfilename.toLowerCase().endsWith(".ttf")) {
                        FontManager.analyzeTTF(fontfilename);
                        continue;
                    }
                    LOG.debug("Unsupported font format for external font: " + fontfilename);
                }
                catch (IOException exception) {
                    LOG.debug("Can't read external font: " + font.getPath(), exception);
                }
            }
            FontManager.addFontMapping(fontfinder.getCommonTTFMapping(), fontMappingTTF);
            FontManager.createFontmapping();
        }
        catch (IOException exception) {
            LOG.error("An error occured when collecting external fonts.", exception);
        }
        finally {
            fontsLoaded = true;
        }
    }

    private static void analyzeTTF(String ttfFilename) throws IOException {
        TTFParser ttfParser = new TTFParser(false, true);
        TrueTypeFont ttfFont = ttfParser.parseTTF(ttfFilename);
        if (ttfFont != null) {
            String normalizedName;
            NamingTable namingTable = ttfFont.getNaming();
            if (namingTable != null && namingTable.getPSName() != null && !ttfFontfiles.containsKey(normalizedName = FontManager.normalizeFontname(namingTable.getPSName()))) {
                LOG.debug("Added font mapping " + normalizedName + " -=> " + ttfFilename);
                ttfFontfiles.put(normalizedName, ttfFilename);
            }
            if (namingTable != null && namingTable.getFontFamily() != null && !ttfFontfiles.containsKey(normalizedName = FontManager.normalizeFontFamily(namingTable.getFontFamily(), namingTable.getPSName()))) {
                LOG.debug("Added font mapping " + normalizedName + " -=> " + ttfFilename);
                ttfFontfiles.put(normalizedName, ttfFilename);
            }
        }
    }

    private static String normalizeFontname(String fontname) {
        String normalizedFontname = fontname.toLowerCase().replaceAll(" ", "").replaceAll(",", "").replaceAll("-", "");
        if (normalizedFontname.indexOf("+") > -1) {
            normalizedFontname = normalizedFontname.substring(normalizedFontname.indexOf("+") + 1);
        }
        boolean isBold = normalizedFontname.indexOf("bold") > -1;
        boolean isItalic = normalizedFontname.indexOf("italic") > -1 || normalizedFontname.indexOf("oblique") > -1;
        normalizedFontname = normalizedFontname.replaceAll("bold", "").replaceAll("italic", "").replaceAll("oblique", "");
        if (isBold) {
            normalizedFontname = normalizedFontname + "bold";
        }
        if (isItalic) {
            normalizedFontname = normalizedFontname + "italic";
        }
        return normalizedFontname;
    }

    private static String normalizeFontFamily(String fontFamily, String psFontName) {
        String normalizedFontFamily = fontFamily.toLowerCase().replaceAll(" ", "").replaceAll(",", "").replaceAll("-", "");
        if (psFontName != null) {
            boolean isItalic;
            boolean isBold = (psFontName = psFontName.toLowerCase()).indexOf("bold") > -1;
            boolean bl = isItalic = psFontName.indexOf("italic") > -1 || psFontName.indexOf("oblique") > -1;
            if (isBold) {
                normalizedFontFamily = normalizedFontFamily + "bold";
            }
            if (isItalic) {
                normalizedFontFamily = normalizedFontFamily + "italic";
            }
        }
        return normalizedFontFamily;
    }

    private static void addFontMapping(String font, String mappedName, Map<String, String> mapping) {
        String fontname = FontManager.normalizeFontname(font);
        if (mapping.containsKey(fontname)) {
            return;
        }
        String mappedFontname = FontManager.normalizeFontname(mappedName);
        if (ttfFontfiles.containsKey(mappedFontname)) {
            mapping.put(fontname, mappedFontname);
        } else if (mapping.containsKey(mappedFontname)) {
            mapping.put(fontname, mapping.get(mappedFontname));
        }
    }

    private static void addFontMapping(Map<String, String> fontMappingSrc, Map<String, String> fontMappingDest) {
        for (String fontname : fontMappingSrc.keySet()) {
            FontManager.addFontMapping(fontname, fontMappingSrc.get(fontname), fontMappingDest);
        }
    }

    private static String getMappedTTFName(String fontname) {
        String normalizedFontname = FontManager.normalizeFontname(fontname);
        if (fontMappingTTF.containsKey(normalizedFontname)) {
            return fontMappingTTF.get(normalizedFontname);
        }
        return null;
    }

    private static void createFontmapping() {
        FontManager.addFontFamilyMapping("ArialNarrow", "Arial", fontMappingTTF);
        FontManager.addFontFamilyMapping("ArialMT", "Arial", fontMappingTTF);
        FontManager.addFontFamilyMapping("CourierNew", "Courier", fontMappingTTF);
        FontManager.addFontFamilyMapping("TimesNewRomanPSMT", "TimesNewRoman", fontMappingTTF);
    }

    private static void addFontFamilyMapping(String fontfamily, String mappedFontfamily, Map<String, String> mapping) {
        FontManager.addFontMapping(fontfamily + ",BoldItalic", mappedFontfamily + ",BoldItalic", mapping);
        FontManager.addFontMapping(fontfamily + ",Bold", mappedFontfamily + ",Bold", mapping);
        FontManager.addFontMapping(fontfamily + ",Italic", mappedFontfamily + ",Italic", mapping);
        FontManager.addFontMapping(fontfamily, mappedFontfamily, mapping);
    }

    public static String findTTFontname(String fontname) {
        String mappedFontname;
        if (!fontsLoaded) {
            FontManager.loadFonts();
        }
        String fontfile = null;
        String normalizedFontname = FontManager.normalizeFontname(fontname);
        if (ttfFontfiles.containsKey(normalizedFontname)) {
            fontfile = ttfFontfiles.get(normalizedFontname);
        }
        if (fontfile == null && (mappedFontname = FontManager.getMappedTTFName(fontname)) != null && ttfFontfiles.containsKey(mappedFontname)) {
            fontfile = ttfFontfiles.get(mappedFontname);
        }
        if (fontfile != null) {
            LOG.debug("Using ttf mapping " + fontname + " -=> " + fontfile);
        } else {
            LOG.warn("Font not found: " + fontname);
        }
        return fontfile;
    }

    public static TrueTypeFont findTTFont(String fontname) throws IOException {
        String ttffontname = FontManager.findTTFontname(fontname);
        TrueTypeFont ttfFont = null;
        if (ttffontname != null) {
            TTFParser ttfParser = new TTFParser();
            InputStream fontStream = ResourceLoader.loadResource(ttffontname);
            if (fontStream == null) {
                throw new IOException("Can't load external font: " + ttffontname);
            }
            ttfFont = ttfParser.parseTTF(fontStream);
        }
        return ttfFont;
    }
}

