/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpsblam;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamInputData;

class GPSBlamMarker {
    private final CachedLatLon mean;
    private final CachedLatLon hair1Coord1;
    private final CachedLatLon hair1Coord2;
    private final CachedLatLon hair2Coord1;
    private final CachedLatLon hair2Coord2;
    private final CachedLatLon ellipseCoord1;
    private final CachedLatLon ellipseCoord2;
    private final CachedLatLon ellipseCoord3;
    private static final double FAC = 2.45;

    GPSBlamMarker(GPSBlamInputData inputData) {
        Projection projection = ProjectionRegistry.getProjection();
        double meanEast = 0.0;
        double meanNorth = 0.0;
        for (CachedLatLon cll : inputData) {
            EastNorth en = cll.getEastNorth((Projecting)projection);
            meanEast += en.east();
            meanNorth += en.north();
        }
        double n = inputData.size();
        meanEast /= n;
        meanNorth /= n;
        double ca = 0.0;
        double cb = 0.0;
        double cc = 0.0;
        double cd = 0.0;
        for (CachedLatLon cll : inputData) {
            EastNorth en = cll.getEastNorth((Projecting)projection);
            double deast = en.east() - meanEast;
            double dnorth = en.north() - meanNorth;
            ca += deast * deast;
            cb += deast * dnorth;
            cd += dnorth * dnorth;
        }
        cc = cb;
        double t = (ca /= n) + (cd /= n);
        double d = ca * cd - (cb /= n) * (cc /= n);
        double variance1 = 0.5 * t + Math.sqrt(0.25 * t * t - d);
        double variance2 = 0.5 * t - Math.sqrt(0.25 * t * t - d);
        double evec1East = variance1 - cd;
        double evec1North = cc;
        double evec2East = variance2 - cd;
        double evec2North = cc;
        double evec1Fac = Math.sqrt(variance1) / Math.sqrt(evec1East * evec1East + evec1North * evec1North);
        double evec2Fac = Math.sqrt(variance2) / Math.sqrt(evec2East * evec2East + evec2North * evec2North);
        double sigma1East = evec1East * evec1Fac;
        double sigma1North = evec1North * evec1Fac;
        double sigma2East = evec2East * evec2Fac;
        double sigma2North = evec2North * evec2Fac;
        Projection proj = ProjectionRegistry.getProjection();
        this.mean = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast, meanNorth)));
        this.hair1Coord1 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast - sigma1East * 2.45, meanNorth - sigma1North * 2.45)));
        this.hair1Coord2 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast + sigma1East * 2.45, meanNorth + sigma1North * 2.45)));
        this.hair2Coord1 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast - sigma2East * 2.45, meanNorth - sigma2North * 2.45)));
        this.hair2Coord2 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast + sigma2East * 2.45, meanNorth + sigma2North * 2.45)));
        double efac = 2.45 / Math.sqrt(inputData.getNDays());
        this.ellipseCoord1 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast + (-sigma1East + sigma2East) * efac, meanNorth + (-sigma1North + sigma2North) * efac)));
        this.ellipseCoord2 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast + (sigma1East + sigma2East) * efac, meanNorth + (sigma1North + sigma2North) * efac)));
        this.ellipseCoord3 = new CachedLatLon(proj.eastNorth2latlon(new EastNorth(meanEast + (-sigma1East - sigma2East) * efac, meanNorth + (-sigma1North - sigma2North) * efac)));
    }

    void paint(Graphics2D g, MapView mv) {
        Projection projection = ProjectionRegistry.getProjection();
        g.setColor(Color.GREEN);
        g.setPaintMode();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f));
        Point hair1Point1 = mv.getPoint(this.hair1Coord1.getEastNorth((Projecting)projection));
        Point hair1Point2 = mv.getPoint(this.hair1Coord2.getEastNorth((Projecting)projection));
        Point hair2Point1 = mv.getPoint(this.hair2Coord1.getEastNorth((Projecting)projection));
        Point hair2Point2 = mv.getPoint(this.hair2Coord2.getEastNorth((Projecting)projection));
        g.drawLine(hair1Point1.x, hair1Point1.y, hair1Point2.x, hair1Point2.y);
        g.drawLine(hair2Point1.x, hair2Point1.y, hair2Point2.x, hair2Point2.y);
        Point2D meanPoint = mv.getPoint2D(this.mean.getEastNorth((Projecting)projection));
        Point2D ellipsePoint1 = mv.getPoint2D(this.ellipseCoord1.getEastNorth((Projecting)projection));
        Point2D ellipsePoint2 = mv.getPoint2D(this.ellipseCoord2.getEastNorth((Projecting)projection));
        Point2D ellipsePoint3 = mv.getPoint2D(this.ellipseCoord3.getEastNorth((Projecting)projection));
        double majorAxis = ellipsePoint2.distance(ellipsePoint1);
        double minorAxis = ellipsePoint3.distance(ellipsePoint1);
        double angle = -Math.atan2(-(ellipsePoint2.getY() - ellipsePoint1.getY()), ellipsePoint2.getX() - ellipsePoint1.getX());
        Ellipse2D.Double e = new Ellipse2D.Double(meanPoint.getX() - majorAxis * 0.5, meanPoint.getY() - minorAxis * 0.5, majorAxis, minorAxis);
        g.rotate(angle, meanPoint.getX(), meanPoint.getY());
        g.draw(e);
        g.rotate(-angle, meanPoint.getX(), meanPoint.getY());
    }
}

