/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.file;

import crosby.binary.file.BlockReaderAdapter;
import crosby.binary.file.FileBlock;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BlockInputStream
implements Closeable {
    InputStream input;
    BlockReaderAdapter adaptor;

    public BlockInputStream(InputStream input, BlockReaderAdapter adaptor) {
        this.input = input;
        this.adaptor = adaptor;
    }

    public void process() throws IOException {
        try {
            while (true) {
                FileBlock.process(this.input, this.adaptor);
            }
        }
        catch (EOFException e) {
            this.adaptor.complete();
            return;
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

