/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class Location {
    @Nullable
    private final PhysicalLocation physicalLocation;
    @NonNull
    private final List<LogicalLocation> logicalLocations;

    Location(@Nullable PhysicalLocation physicalLocation, @NonNull Collection<LogicalLocation> logicalLocations) {
        if (physicalLocation == null && Objects.requireNonNull(logicalLocations).isEmpty()) {
            throw new IllegalArgumentException("One of physicalLocation or logicalLocations should exist");
        }
        this.physicalLocation = physicalLocation;
        this.logicalLocations = new ArrayList<LogicalLocation>(logicalLocations);
    }

    @CheckForNull
    PhysicalLocation getPhysicalLocation() {
        return this.physicalLocation;
    }

    JsonObject toJsonObject() {
        JsonObject result = new JsonObject();
        if (this.physicalLocation != null) {
            result.add("physicalLocation", (JsonElement)this.physicalLocation.toJsonObject());
        }
        JsonArray logicalLocationArray = new JsonArray();
        this.logicalLocations.stream().map(LogicalLocation::toJsonObject).forEach(logicalLocation -> logicalLocationArray.add((JsonElement)logicalLocation));
        if (logicalLocationArray.size() > 0) {
            result.add("logicalLocations", (JsonElement)logicalLocationArray);
        }
        return result;
    }

    static Optional<Location> fromBugInstance(@NonNull BugInstance bugInstance, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
        Objects.requireNonNull(bugInstance);
        Objects.requireNonNull(sourceFinder);
        Objects.requireNonNull(baseToId);
        PhysicalLocation physicalLocation = Location.findPhysicalLocation(bugInstance, sourceFinder, baseToId);
        return LogicalLocation.fromBugInstance(bugInstance).map(logicalLocation -> new Location(physicalLocation, Collections.singleton(logicalLocation)));
    }

    static Location fromStackTraceElement(@NonNull StackTraceElement element, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(sourceFinder);
        Objects.requireNonNull(baseToId);
        Optional<PhysicalLocation> physicalLocation = Location.findPhysicalLocation(element, sourceFinder, baseToId);
        LogicalLocation logicalLocation = LogicalLocation.fromStackTraceElement(element);
        return new Location(physicalLocation.orElse(null), Collections.singleton(logicalLocation));
    }

    @CheckForNull
    private static PhysicalLocation findPhysicalLocation(@NonNull BugInstance bugInstance, @NonNull SourceFinder sourceFinder, Map<URI, String> baseToId) {
        try {
            return PhysicalLocation.fromBugAnnotation(bugInstance, sourceFinder, baseToId).orElse(null);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @CheckForNull
    private static Optional<PhysicalLocation> findPhysicalLocation(@NonNull StackTraceElement element, @NonNull SourceFinder sourceFinder, Map<URI, String> baseToId) {
        Optional<Region> region = Optional.of(element.getLineNumber()).filter(line -> line > 0).map(line -> new Region((int)line, (int)line));
        return ArtifactLocation.fromStackTraceElement(element, sourceFinder, baseToId).map(artifactLocation -> new PhysicalLocation((ArtifactLocation)artifactLocation, region.orElse(null)));
    }

    static final class PhysicalLocation {
        @NonNull
        final ArtifactLocation artifactLocation;
        @Nullable
        final Region region;

        PhysicalLocation(@NonNull ArtifactLocation artifactLocation, @Nullable Region region) {
            this.artifactLocation = Objects.requireNonNull(artifactLocation);
            this.region = region;
        }

        JsonObject toJsonObject() {
            JsonObject result = new JsonObject();
            result.add("artifactLocation", (JsonElement)this.artifactLocation.toJsonObject());
            if (this.region != null) {
                result.add("region", (JsonElement)this.region.toJsonObject());
            }
            return result;
        }

        static Optional<PhysicalLocation> fromBugAnnotation(@NonNull BugInstance bugInstance, SourceFinder sourceFinder, Map<URI, String> baseToId) {
            ClassAnnotation primaryClass = bugInstance.getPrimaryClass();
            SourceLineAnnotation sourceLine = bugInstance.getPrimarySourceLineAnnotation();
            Optional<ArtifactLocation> artifactLocation = ArtifactLocation.fromBugAnnotation(primaryClass, sourceLine, sourceFinder, baseToId);
            Optional<Region> region = Region.fromBugAnnotation(sourceLine);
            return artifactLocation.map(location -> new PhysicalLocation((ArtifactLocation)location, region.orElse(null)));
        }
    }

    static final class LogicalLocation {
        @NonNull
        final String name;
        @Nullable
        final String decoratedName;
        @NonNull
        final String kind;
        @Nullable
        final String fullyQualifiedName;
        @Nullable
        final Map<String, String> properties = new HashMap<String, String>();

        LogicalLocation(@NonNull String name, @Nullable String decoratedName, @NonNull String kind, @Nullable String fullyQualifiedName, @Nullable Map<String, String> properties) {
            this.name = Objects.requireNonNull(name);
            this.decoratedName = decoratedName;
            this.kind = Objects.requireNonNull(kind);
            this.fullyQualifiedName = fullyQualifiedName;
            if (properties != null) {
                this.properties.putAll(properties);
            }
        }

        JsonObject toJsonObject() {
            JsonObject propertiesBag = new JsonObject();
            this.properties.forEach((k, v) -> propertiesBag.addProperty(k, v));
            JsonObject locationJson = new JsonObject();
            locationJson.addProperty("name", this.name);
            if (this.decoratedName != null) {
                locationJson.addProperty("decoratedName", this.decoratedName);
            }
            locationJson.addProperty("kind", this.kind);
            if (this.fullyQualifiedName != null) {
                locationJson.addProperty("fullyQualifiedName", this.fullyQualifiedName);
            }
            if (propertiesBag != null && propertiesBag.size() > 0) {
                locationJson.add("properties", (JsonElement)propertiesBag);
            }
            return locationJson;
        }

        @NonNull
        static LogicalLocation fromStackTraceElement(@NonNull StackTraceElement element) {
            String fullyQualifiedName = String.format("%s.%s", element.getClassName(), element.getMethodName());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("line-number", Integer.toString(element.getLineNumber()));
            return new LogicalLocation(element.getMethodName(), null, "function", fullyQualifiedName, properties);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        static Optional<LogicalLocation> fromBugInstance(@NonNull BugInstance bugInstance) {
            void var6_12;
            Objects.requireNonNull(bugInstance);
            ClassAnnotation classAnnotation = null;
            MethodAnnotation methodAnnotation = null;
            FieldAnnotation fieldAnnotation = null;
            LocalVariableAnnotation localVariableAnnotation = null;
            for (BugAnnotation bugAnnotation : bugInstance.getAnnotations()) {
                if (bugAnnotation instanceof ClassAnnotation) {
                    classAnnotation = (ClassAnnotation)bugAnnotation;
                    continue;
                }
                if (bugAnnotation instanceof MethodAnnotation) {
                    methodAnnotation = (MethodAnnotation)bugAnnotation;
                    continue;
                }
                if (bugAnnotation instanceof FieldAnnotation) {
                    fieldAnnotation = (FieldAnnotation)bugAnnotation;
                    continue;
                }
                if (!(bugAnnotation instanceof LocalVariableAnnotation)) continue;
                localVariableAnnotation = (LocalVariableAnnotation)bugAnnotation;
            }
            String fullyQualifiedName = "";
            Object var6_7 = null;
            if (localVariableAnnotation != null) {
                LocalVariableAnnotation localVariableAnnotation2 = localVariableAnnotation;
                fullyQualifiedName = String.format("%s#%s", methodAnnotation.getFullMethod(classAnnotation), localVariableAnnotation.getName());
            } else if (fieldAnnotation != null) {
                FieldAnnotation fieldAnnotation2 = fieldAnnotation;
                fullyQualifiedName = String.format("%s.%s", classAnnotation.getClassName(), fieldAnnotation.getFieldName());
            } else if (methodAnnotation != null) {
                MethodAnnotation methodAnnotation2 = methodAnnotation;
                fullyQualifiedName = methodAnnotation.getFullMethod(classAnnotation);
            } else if (classAnnotation != null) {
                ClassAnnotation classAnnotation2 = classAnnotation;
                fullyQualifiedName = classAnnotation.getClassName();
            }
            if (var6_12 == null) {
                return Optional.empty();
            }
            String kind = LogicalLocation.findKind((BugAnnotation)var6_12);
            String name = var6_12.format("givenClass", classAnnotation);
            return Optional.of(new LogicalLocation(name, null, kind, fullyQualifiedName, null));
        }

        @CheckForNull
        static String findKind(@NonNull BugAnnotation annotation) {
            if (annotation instanceof ClassAnnotation) {
                return "type";
            }
            if (annotation instanceof MethodAnnotation) {
                return "function";
            }
            if (annotation instanceof FieldAnnotation) {
                return "member";
            }
            if (annotation instanceof LocalVariableAnnotation) {
                return "variable";
            }
            return null;
        }
    }

    static final class ArtifactLocation {
        @NonNull
        final URI uri;
        @Nullable
        final String uriBaseId;

        ArtifactLocation(@NonNull URI uri, @Nullable String uriBaseId) {
            this.uri = Objects.requireNonNull(uri);
            this.uriBaseId = uriBaseId;
        }

        JsonObject toJsonObject() {
            JsonObject locationJson = new JsonObject();
            locationJson.addProperty("uri", this.uri.toString());
            locationJson.addProperty("uriBaseId", this.uriBaseId);
            return locationJson;
        }

        static Optional<ArtifactLocation> fromBugAnnotation(@NonNull ClassAnnotation classAnnotation, @NonNull SourceLineAnnotation bugAnnotation, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
            Objects.requireNonNull(bugAnnotation);
            Objects.requireNonNull(sourceFinder);
            Objects.requireNonNull(baseToId);
            Optional<ArtifactLocation> location = sourceFinder.getBase(bugAnnotation).map(base -> {
                String uriBaseId = baseToId.computeIfAbsent((URI)base, s -> Integer.toString(s.hashCode()));
                try {
                    SourceFile sourceFile = sourceFinder.findSourceFile(bugAnnotation);
                    return new ArtifactLocation(base.relativize(sourceFile.getFullURI()), uriBaseId);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            if (location.isPresent()) {
                return location;
            }
            try {
                String path = bugAnnotation.format("full", classAnnotation);
                String pathWithoutLine = path.contains(":") ? path.split(":")[0] : path;
                return Optional.of(new ArtifactLocation(new URI(pathWithoutLine), null));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }

        static Optional<ArtifactLocation> fromStackTraceElement(StackTraceElement element, SourceFinder sourceFinder, Map<URI, String> baseToId) {
            Objects.requireNonNull(element);
            Objects.requireNonNull(sourceFinder);
            Objects.requireNonNull(baseToId);
            String packageName = ClassName.extractPackageName(element.getClassName());
            String fileName = element.getFileName();
            try {
                SourceFile sourceFile = sourceFinder.findSourceFile(packageName, fileName);
                String fullFileName = sourceFile.getFullFileName();
                int index = fullFileName.indexOf(packageName.replace('.', File.separatorChar));
                assert (index >= 0);
                String relativeFileName = fullFileName.substring(index);
                return sourceFinder.getBase(relativeFileName).map(base -> {
                    String baseId = baseToId.computeIfAbsent((URI)base, s -> Integer.toString(s.hashCode()));
                    URI relativeUri = base.relativize(sourceFile.getFullURI());
                    return new ArtifactLocation(relativeUri, baseId);
                });
            }
            catch (IOException fileNotFound) {
                return Optional.empty();
            }
        }
    }

    static final class Region {
        final int startLine;
        final int endLine;

        Region(int startLine, int endLine) {
            assert (startLine > 0);
            assert (endLine > 0);
            this.startLine = startLine;
            this.endLine = startLine == endLine ? 0 : endLine;
        }

        static Optional<Region> fromBugAnnotation(SourceLineAnnotation annotation) {
            if (annotation.getStartLine() <= 0 || annotation.getEndLine() <= 0) {
                return Optional.empty();
            }
            return Optional.of(new Region(annotation.getStartLine(), annotation.getEndLine()));
        }

        JsonObject toJsonObject() {
            JsonObject json = new JsonObject();
            json.addProperty("startLine", (Number)this.startLine);
            if (this.endLine != 0) {
                json.addProperty("endLine", (Number)this.endLine);
            }
            return json;
        }
    }
}

