/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.sarif.Level;
import edu.umd.cs.findbugs.sarif.Location;
import edu.umd.cs.findbugs.sarif.Message;
import edu.umd.cs.findbugs.sarif.MessageFormat;
import edu.umd.cs.findbugs.sarif.Placeholder;
import edu.umd.cs.findbugs.sarif.Result;
import edu.umd.cs.findbugs.sarif.Rule;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class BugCollectionAnalyser {
    @NonNull
    private final List<Rule> rules = new ArrayList<Rule>();
    @NonNull
    private final List<Result> results = new ArrayList<Result>();
    @NonNull
    private final Map<String, Integer> typeToIndex = new HashMap<String, Integer>();
    @NonNull
    private final List<List<Placeholder>> indexToPlaceholders = new ArrayList<List<Placeholder>>();
    @NonNull
    private final Map<URI, String> baseToId = new HashMap<URI, String>();

    BugCollectionAnalyser(@NonNull BugCollection bugCollection) {
        SourceFinder sourceFinder = bugCollection.getProject().getSourceFinder();
        bugCollection.forEach(bug -> {
            String type = bug.getType();
            int index = this.typeToIndex.computeIfAbsent(type, t -> this.processRule(bug.getBugPattern()));
            this.processResult(index, (BugInstance)bug, sourceFinder);
        });
    }

    JsonArray getRules() {
        JsonArray array = new JsonArray();
        this.rules.stream().map(Rule::toJsonObject).forEach(jsonObject -> array.add((JsonElement)jsonObject));
        return array;
    }

    JsonArray getResults() {
        JsonArray array = new JsonArray();
        this.results.stream().map(Result::toJsonObject).forEach(jsonObject -> array.add((JsonElement)jsonObject));
        return array;
    }

    @NonNull
    JsonObject getOriginalUriBaseIds() {
        JsonObject result = new JsonObject();
        this.baseToId.forEach((uri, uriBaseId) -> {
            JsonObject uriJson = new JsonObject();
            uriJson.addProperty("uri", uri.toString());
            result.add(uriBaseId, (JsonElement)uriJson);
        });
        return result;
    }

    private void processResult(int index, BugInstance bug, SourceFinder sourceFinder) {
        List<String> arguments = this.indexToPlaceholders.get(index).stream().map(placeholder -> placeholder.toArgument(bug.getAnnotations(), bug.getPrimaryClass())).collect(Collectors.toList());
        ArrayList<Location> locations = new ArrayList<Location>();
        Location.fromBugInstance(bug, sourceFinder, this.baseToId).ifPresent(locations::add);
        int bugRank = BugRanker.findRank(bug);
        Message msg = new Message(arguments);
        msg.text = bug.getBugPattern().getShortDescription();
        Result result = new Result(bug.getType(), index, msg, locations, Level.fromBugRank(bugRank));
        this.results.add(result);
    }

    private int processRule(BugPattern bugPattern) {
        assert (this.indexToPlaceholders.size() == this.rules.size());
        int ruleIndex = this.rules.size();
        ArrayList placeholders = new ArrayList();
        MessageFormat formatter = new MessageFormat(bugPattern.getLongDescription());
        String formattedMessage = formatter.format((index, key) -> {
            int indexOfPlaceholder = placeholders.size();
            placeholders.add(new Placeholder((int)index, (String)key));
            return String.format("{%d}", indexOfPlaceholder);
        });
        Rule rule = Rule.fromBugPattern(bugPattern, formattedMessage);
        this.rules.add(rule);
        this.indexToPlaceholders.add(placeholders);
        return ruleIndex;
    }

    Map<URI, String> getBaseToId() {
        return this.baseToId;
    }
}

