/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;

public class FindUselessControlFlow
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final BitSet ifInstructionSet = new BitSet();
    private final BugAccumulator bugAccumulator;

    public FindUselessControlFlow(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        if (ifInstructionSet.get(seen) && this.getBranchTarget() == this.getBranchFallThrough()) {
            int priority = 2;
            LineNumberTable lineNumbers = this.getCode().getLineNumberTable();
            if (lineNumbers != null) {
                int branchLineNumber = lineNumbers.getSourceLine(this.getPC());
                int targetLineNumber = lineNumbers.getSourceLine(this.getBranchFallThrough());
                int nextLine = FindUselessControlFlow.getNextSourceLine(lineNumbers, branchLineNumber);
                if (branchLineNumber + 1 == targetLineNumber || branchLineNumber == targetLineNumber && nextLine == branchLineNumber + 1) {
                    priority = 1;
                } else if (branchLineNumber + 2 < Math.max(targetLineNumber, nextLine)) {
                    priority = 3;
                }
            } else {
                priority = 3;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, priority == 1 ? "UCF_USELESS_CONTROL_FLOW_NEXT_LINE" : "UCF_USELESS_CONTROL_FLOW", priority).addClassAndMethod(this), this);
        }
    }

    public static int getNextSourceLine(LineNumberTable lineNumbers, int sourceLine) {
        int result = Integer.MAX_VALUE;
        for (LineNumber ln : lineNumbers.getLineNumberTable()) {
            int thisLine = ln.getLineNumber();
            if (sourceLine >= thisLine || thisLine >= result) continue;
            result = thisLine;
        }
        return result;
    }

    static {
        ifInstructionSet.set(165);
        ifInstructionSet.set(166);
        ifInstructionSet.set(159);
        ifInstructionSet.set(160);
        ifInstructionSet.set(161);
        ifInstructionSet.set(164);
        ifInstructionSet.set(163);
        ifInstructionSet.set(162);
        ifInstructionSet.set(153);
        ifInstructionSet.set(154);
        ifInstructionSet.set(155);
        ifInstructionSet.set(158);
        ifInstructionSet.set(157);
        ifInstructionSet.set(156);
        ifInstructionSet.set(198);
        ifInstructionSet.set(199);
    }
}

