/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.NestedAccessUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindUncalledPrivateMethods
extends BytecodeScanningDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private String className;
    private HashSet<MethodAnnotation> definedPrivateMethods;
    private HashSet<MethodAnnotation> calledMethods;
    private HashSet<String> calledMethodNames;

    public FindUncalledPrivateMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitMethod(Method obj) {
        if (!obj.isPrivate() || obj.isSynthetic()) {
            return;
        }
        super.visitMethod(obj);
        String methodName = this.getMethodName();
        if (!("writeReplace".equals(methodName) || "readResolve".equals(methodName) || "readObject".equals(methodName) || "readObjectNoData".equals(methodName) || "writeObject".equals(methodName) || methodName.indexOf("debug") != -1 || methodName.indexOf("Debug") != -1 || methodName.indexOf("trace") != -1 || methodName.indexOf("Trace") != -1 || "<init>".equals(methodName) || "<clinit>".equals(methodName))) {
            for (AnnotationEntry a : obj.getAnnotationEntries()) {
                String typeName = a.getAnnotationType();
                if (!"Ljavax/annotation/PostConstruct;".equals(typeName) && !"Ljavax/annotation/PreDestroy;".equals(typeName)) continue;
                return;
            }
            this.definedPrivateMethods.add(MethodAnnotation.fromVisitedMethod(this));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: {
                if (!this.getDottedClassConstantOperand().equals(this.className)) break;
                String className = this.getDottedClassConstantOperand();
                MethodAnnotation called = new MethodAnnotation(className, this.getNameConstantOperand(), this.getSigConstantOperand(), seen == 184);
                this.calledMethods.add(called);
                this.calledMethodNames.add(this.getNameConstantOperand().toLowerCase());
                break;
            }
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.definedPrivateMethods = new HashSet();
        this.calledMethods = new HashSet();
        this.calledMethodNames = new HashSet();
        JavaClass javaClass = classContext.getJavaClass();
        this.className = javaClass.getClassName();
        String[] parts = this.className.split("[$+.]");
        String simpleClassName = parts[parts.length - 1];
        if (NestedAccessUtil.supportsNestedAccess(javaClass)) {
            this.checkForNestedAccess(classContext, javaClass);
        }
        ConstantPool cp = classContext.getJavaClass().getConstantPool();
        for (Constant constant : cp.getConstantPool()) {
            Constant ref;
            int kind;
            if (!(constant instanceof ConstantMethodHandle) || (kind = ((ConstantMethodHandle)constant).getReferenceKind()) < 5 || kind > 9 || !((ref = cp.getConstant(((ConstantMethodHandle)constant).getReferenceIndex())) instanceof ConstantCP)) continue;
            String className = cp.getConstantString(((ConstantCP)ref).getClassIndex(), (byte)7);
            ConstantNameAndType nameAndType = (ConstantNameAndType)cp.getConstant(((ConstantCP)ref).getNameAndTypeIndex());
            String name = ((ConstantUtf8)cp.getConstant(nameAndType.getNameIndex())).getBytes();
            String signature = ((ConstantUtf8)cp.getConstant(nameAndType.getSignatureIndex())).getBytes();
            MethodAnnotation called = new MethodAnnotation(ClassName.toDottedClassName(className), name, signature, kind == 6);
            this.calledMethods.add(called);
            this.calledMethodNames.add(name.toLowerCase());
        }
        super.visitClassContext(classContext);
        this.definedPrivateMethods.removeAll(this.calledMethods);
        for (MethodAnnotation m : this.definedPrivateMethods) {
            int priority = 3;
            String methodName = m.getMethodName();
            if (methodName.equals(simpleClassName) && "()V".equals(m.getMethodSignature())) continue;
            if (methodName.length() > 1 && this.calledMethodNames.contains(methodName.toLowerCase())) {
                priority = 2;
            }
            BugInstance bugInstance = new BugInstance(this, "UPM_UNCALLED_PRIVATE_METHOD", priority).addClass(this).addMethod(m);
            this.bugReporter.reportBug(bugInstance);
        }
        this.definedPrivateMethods = null;
        this.calledMethods = null;
    }

    private void checkForNestedAccess(ClassContext classContext, JavaClass javaClass) {
        AnalysisContext analysisContext = classContext.getAnalysisContext();
        List<String> nestMateClassNames = Collections.EMPTY_LIST;
        try {
            nestMateClassNames = NestedAccessUtil.getNestMateClassNames(javaClass, analysisContext);
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        for (String nestMateClassName : nestMateClassNames) {
            try {
                JavaClass nestMemberClass = analysisContext.lookupClass(nestMateClassName);
                if (nestMemberClass.equals((Object)javaClass)) continue;
                ConstantPool cp = nestMemberClass.getConstantPool();
                for (Constant constant : nestMemberClass.getConstantPool().getConstantPool()) {
                    if (!(constant instanceof ConstantMethodref)) continue;
                    ConstantMethodref ref = (ConstantMethodref)constant;
                    ConstantNameAndType nt = (ConstantNameAndType)cp.getConstant(ref.getNameAndTypeIndex());
                    String name = ((ConstantUtf8)cp.getConstant(nt.getNameIndex(), (byte)1)).getBytes();
                    String signature = ((ConstantUtf8)cp.getConstant(nt.getSignatureIndex(), (byte)1)).getBytes();
                    boolean isStatic = false;
                    String nestMemberClassName = FindUncalledPrivateMethods.getClassName(nestMemberClass, ref.getClassIndex());
                    MethodAnnotation called = new MethodAnnotation(ClassName.toDottedClassName(nestMemberClassName), name, signature, isStatic);
                    this.calledMethods.add(called);
                    this.calledMethodNames.add(name.toLowerCase());
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }

    private static String getClassName(JavaClass c, int classIndex) {
        String name = c.getConstantPool().getConstantString(classIndex, (byte)7);
        return ClassName.extractClassName(name).replace('/', '.');
    }
}

