/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.MutableClasses;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindReturnRef
extends OpcodeStackDetector {
    boolean check = false;
    boolean publicClass = false;
    boolean staticMethod = false;
    int parameterCount;
    private XField fieldUnderClone = null;
    private OpcodeStack.Item paramUnderClone = null;
    private XField fieldCloneUnderCast = null;
    private OpcodeStack.Item paramCloneUnderCast = null;
    private XField bufferFieldUnderDuplication = null;
    private OpcodeStack.Item bufferParamUnderDuplication = null;
    private XField fieldUnderWrapToBuffer = null;
    private OpcodeStack.Item paramUnderWrapToBuffer = null;
    private Map<OpcodeStack.Item, XField> bufferFieldDuplicates = new HashMap<OpcodeStack.Item, XField>();
    private Map<OpcodeStack.Item, OpcodeStack.Item> bufferParamDuplicates = new HashMap<OpcodeStack.Item, OpcodeStack.Item>();
    private Map<OpcodeStack.Item, XField> arrayFieldsWrappedToBuffers = new HashMap<OpcodeStack.Item, XField>();
    private Map<OpcodeStack.Item, OpcodeStack.Item> arrayParamsWrappedToBuffers = new HashMap<OpcodeStack.Item, OpcodeStack.Item>();
    private Map<OpcodeStack.Item, XField> arrayFieldClones = new HashMap<OpcodeStack.Item, XField>();
    private Map<OpcodeStack.Item, OpcodeStack.Item> arrayParamClones = new HashMap<OpcodeStack.Item, OpcodeStack.Item>();
    private final BugAccumulator bugAccumulator;
    private static final Matcher BUFFER_CLASS_MATCHER = Pattern.compile("Ljava/nio/[A-Za-z]+Buffer;").matcher("");
    private static final Matcher DUPLICATE_METHODS_SIGNATURE_MATCHER = Pattern.compile("\\(\\)Ljava/nio/[A-Za-z]+Buffer;").matcher("");
    private static final Matcher WRAP_METHOD_SIGNATURE_MATCHER = Pattern.compile("\\(\\[.\\)Ljava/nio/[A-Za-z]+Buffer;").matcher("");

    public FindReturnRef(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        this.publicClass = obj.isPublic();
        super.visit(obj);
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(Method obj) {
        boolean bl = this.check = this.publicClass && (obj.getAccessFlags() & 1) != 0;
        if (!this.check) {
            return;
        }
        this.staticMethod = (obj.getAccessFlags() & 8) != 0;
        this.parameterCount = this.getNumberMethodArguments();
        if (!this.staticMethod) {
            ++this.parameterCount;
        }
        super.visit(obj);
    }

    @Override
    public void visit(Code obj) {
        if (this.check) {
            super.visit(obj);
        }
    }

    @Override
    public void sawOpcode(int seen) {
        MethodDescriptor method;
        XField field;
        OpcodeStack.Item item;
        OpcodeStack.Item top;
        CaptureKind capture;
        if (!this.check) {
            return;
        }
        this.fieldUnderClone = null;
        this.paramUnderClone = null;
        this.fieldCloneUnderCast = null;
        this.paramCloneUnderCast = null;
        this.fieldUnderWrapToBuffer = null;
        this.paramUnderWrapToBuffer = null;
        this.bufferFieldUnderDuplication = null;
        this.bufferParamUnderDuplication = null;
        if (this.staticMethod && seen == 179 && this.nonPublicFieldOperand() && MutableClasses.mutableSignature(this.getSigConstantOperand()) && (capture = this.getPotentialCapture(top = this.stack.getStackItem(0))) != CaptureKind.NONE) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "EI_EXPOSE_STATIC_" + (capture == CaptureKind.BUF ? "BUF2" : "REP2"), capture == CaptureKind.REP ? 2 : 3).addClassAndMethod(this).addReferencedField(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), top.getRegisterNumber(), this.getPC(), this.getPC() - 1)), this);
        }
        if (!this.staticMethod && seen == 181 && this.nonPublicFieldOperand() && MutableClasses.mutableSignature(this.getSigConstantOperand())) {
            top = this.stack.getStackItem(0);
            OpcodeStack.Item target = this.stack.getStackItem(1);
            CaptureKind capture2 = this.getPotentialCapture(top);
            if (capture2 != CaptureKind.NONE && target.getRegisterNumber() == 0) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, "EI_EXPOSE_" + (capture2 == CaptureKind.BUF ? "BUF2" : "REP2"), capture2 == CaptureKind.REP ? 2 : 3).addClassAndMethod(this).addReferencedField(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), top.getRegisterNumber(), this.getPC(), this.getPC() - 1)), this);
            }
        }
        if (seen == 176) {
            item = this.stack.getStackItem(0);
            field = item.getXField();
            boolean isBuf = false;
            boolean isArrayClone = false;
            if (field == null && (field = this.arrayFieldClones.get(item)) != null) {
                isArrayClone = true;
            }
            if (field == null && (field = this.bufferFieldDuplicates.get(item)) != null) {
                isBuf = true;
            }
            if (field == null && (field = this.arrayFieldsWrappedToBuffers.get(item)) != null) {
                isBuf = true;
            }
            if (field == null || !this.isFieldOf(field, this.getClassDescriptor()) || field.isPublic() || AnalysisContext.currentXFactory().isEmptyArrayField(field) || field.getName().indexOf("EMPTY") != -1 || !MutableClasses.mutableSignature(field.getSignature())) {
                return;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, (this.staticMethod ? "MS" : "EI") + "_EXPOSE_" + (isBuf ? "BUF" : "REP"), isBuf || isArrayClone ? 3 : 2).addClassAndMethod(this).addField(field.getClassName(), field.getName(), field.getSignature(), field.isStatic()), this);
        }
        if (seen == 185 || seen == 182) {
            method = this.getMethodDescriptorOperand();
            OpcodeStack.Item item2 = this.stack.getStackItem(0);
            XField field2 = item2.getXField();
            if (method == null) {
                return;
            }
            if ("clone".equals(method.getName()) && item2.isArray() && MutableClasses.mutableSignature(item2.getSignature().substring(1))) {
                if (field2 != null && field2.getClassDescriptor().equals(this.getClassDescriptor()) && !field2.isPublic()) {
                    this.fieldUnderClone = field2;
                } else if (item2.isInitialParameter()) {
                    this.paramUnderClone = item2;
                }
            }
            if (seen == 182 && "duplicate".equals(method.getName()) && DUPLICATE_METHODS_SIGNATURE_MATCHER.reset(method.getSignature()).matches() && BUFFER_CLASS_MATCHER.reset(method.getClassDescriptor().getSignature()).matches()) {
                if (field2 != null && field2.getClassDescriptor().equals(this.getClassDescriptor()) && !field2.isPublic()) {
                    this.bufferFieldUnderDuplication = field2;
                } else if (item2.isInitialParameter()) {
                    this.bufferParamUnderDuplication = item2;
                }
            }
        }
        if (seen == 184) {
            method = this.getMethodDescriptorOperand();
            if (!(method != null && "wrap".equals(method.getName()) && WRAP_METHOD_SIGNATURE_MATCHER.reset(method.getSignature()).matches() && BUFFER_CLASS_MATCHER.reset(method.getClassDescriptor().getSignature()).matches())) {
                return;
            }
            OpcodeStack.Item arg = this.stack.getStackItem(0);
            XField fieldArg = arg.getXField();
            if (fieldArg != null && fieldArg.getClassDescriptor().equals(this.getClassDescriptor()) && !fieldArg.isPublic()) {
                this.fieldUnderWrapToBuffer = fieldArg;
            } else if (arg.isInitialParameter()) {
                this.paramUnderWrapToBuffer = arg;
            }
        }
        if (seen == 192) {
            OpcodeStack.Item param;
            item = this.stack.getStackItem(0);
            field = this.arrayFieldClones.get(item);
            if (field != null) {
                this.fieldCloneUnderCast = field;
            }
            if ((param = this.arrayParamClones.get(item)) != null) {
                this.paramCloneUnderCast = param;
            }
        }
    }

    @Override
    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        if (seen == 185 || seen == 182) {
            if (this.fieldUnderClone != null) {
                this.arrayFieldClones.put(this.stack.getStackItem(0), this.fieldUnderClone);
            }
            if (this.paramUnderClone != null) {
                this.arrayParamClones.put(this.stack.getStackItem(0), this.paramUnderClone);
            }
            if (seen == 182) {
                if (this.bufferFieldUnderDuplication != null) {
                    this.bufferFieldDuplicates.put(this.stack.getStackItem(0), this.bufferFieldUnderDuplication);
                }
                if (this.bufferParamUnderDuplication != null) {
                    this.bufferParamDuplicates.put(this.stack.getStackItem(0), this.bufferParamUnderDuplication);
                }
            }
        }
        if (seen == 184) {
            if (this.fieldUnderWrapToBuffer != null) {
                this.arrayFieldsWrappedToBuffers.put(this.stack.getStackItem(0), this.fieldUnderWrapToBuffer);
            }
            if (this.paramUnderWrapToBuffer != null) {
                this.arrayParamsWrappedToBuffers.put(this.stack.getStackItem(0), this.paramUnderWrapToBuffer);
            }
        }
        if (seen == 192) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            if (this.fieldCloneUnderCast != null) {
                this.arrayFieldClones.put(item, this.fieldCloneUnderCast);
            }
            if (this.paramCloneUnderCast != null) {
                this.arrayParamClones.put(item, this.paramCloneUnderCast);
            }
        }
    }

    private boolean nonPublicFieldOperand() {
        XField xField = this.getXFieldOperand();
        return xField == null || !xField.isPublic();
    }

    private CaptureKind getPotentialCapture(OpcodeStack.Item top) {
        CaptureKind kind = CaptureKind.REP;
        if (!top.isInitialParameter()) {
            OpcodeStack.Item newTop = this.arrayParamClones.get(top);
            if (newTop == null) {
                newTop = this.arrayParamsWrappedToBuffers.get(top);
                if (newTop == null && (newTop = this.bufferParamDuplicates.get(top)) == null) {
                    return CaptureKind.NONE;
                }
                kind = CaptureKind.BUF;
            } else {
                kind = CaptureKind.ARRAY_CLONE;
            }
            top = newTop;
        }
        if ((this.getMethod().getAccessFlags() & 0x80) == 0) {
            return kind;
        }
        return top.getRegisterNumber() != this.parameterCount - 1 ? kind : CaptureKind.NONE;
    }

    private boolean isFieldOf(XField field, ClassDescriptor klass) {
        do {
            if (field.getClassDescriptor().equals(klass)) {
                return true;
            }
            try {
                klass = klass.getXClass().getSuperclassDescriptor();
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error checking for class " + klass, e);
                return false;
            }
        } while (klass != null);
        return false;
    }

    private static enum CaptureKind {
        NONE,
        REP,
        ARRAY_CLONE,
        BUF;

    }
}

