/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashMap;
import render.ChartContext;
import render.Renderer;
import render.Signals;
import s57.S57att;
import s57.S57map;
import s57.S57obj;
import s57.S57val;
import symbols.Areas;
import symbols.Beacons;
import symbols.Buoys;
import symbols.Facilities;
import symbols.Harbours;
import symbols.Landmarks;
import symbols.Notices;
import symbols.Symbols;
import symbols.Topmarks;

public class Rules {
    static final DecimalFormat df = new DecimalFormat("#.#");
    static final EnumMap<S57val.ColCOL, Color> bodyColours = new EnumMap(S57val.ColCOL.class);
    static final EnumMap<S57val.ColCOL, String> colourLetters;
    static final EnumMap<S57val.ColPAT, Symbols.Patt> pattMap;
    public static S57map.Feature feature;
    static ArrayList<S57map.Feature> objects;

    static String getName() {
        S57map.AttMap atts;
        S57val.AttVal name = (S57val.AttVal)Rules.feature.atts.get((Object)S57att.Att.OBJNAM);
        if (name == null && (atts = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)Rules.feature.type)).get(0)) != null) {
            name = (S57val.AttVal)atts.get((Object)S57att.Att.OBJNAM);
        }
        return name != null ? ((String)name.val).replace("&quot;", "\"") : null;
    }

    public static void addName(int z, Font font) {
        Rules.addName(z, font, Color.black, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
    }

    public static void addName(int z, Font font, Color colour) {
        Rules.addName(z, font, colour, new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
    }

    public static void addName(int z, Font font, Symbols.Delta delta) {
        Rules.addName(z, font, Color.black, delta);
    }

    public static void addName(int z, Font font, Color colour, Symbols.Delta delta) {
        String name;
        if (Renderer.zoom >= z && (name = Rules.getName()) != null) {
            Renderer.labelText(name, font, colour, delta);
        }
    }

    static S57map.AttMap getAtts(S57obj.Obj obj, int idx) {
        HashMap objs = (HashMap)Rules.feature.objs.get((Object)obj);
        if (objs == null) {
            return null;
        }
        return (S57map.AttMap)objs.get(idx);
    }

    public static Object getAttVal(S57obj.Obj obj, S57att.Att att) {
        S57val.AttVal item;
        HashMap objs = (HashMap)Rules.feature.objs.get((Object)obj);
        if (objs == null) {
            return null;
        }
        S57map.AttMap atts = (S57map.AttMap)objs.get(0);
        if (atts == null || (item = (S57val.AttVal)atts.get((Object)att)) == null) {
            return null;
        }
        return item.val;
    }

    public static String getAttStr(S57obj.Obj obj, S57att.Att att) {
        String str = (String)Rules.getAttVal(obj, att);
        if (str != null) {
            return str;
        }
        return "";
    }

    public static Enum<?> getAttEnum(S57obj.Obj obj, S57att.Att att) {
        ArrayList list = (ArrayList)Rules.getAttVal(obj, att);
        if (list != null) {
            return (Enum)list.get(0);
        }
        return S57val.unknAtt(att);
    }

    public static ArrayList<?> getAttList(S57obj.Obj obj, S57att.Att att) {
        ArrayList list = (ArrayList)Rules.getAttVal(obj, att);
        if (list != null) {
            return list;
        }
        list = new ArrayList();
        list.add(S57val.unknAtt(att));
        return list;
    }

    static Symbols.Scheme getScheme(S57obj.Obj obj) {
        ArrayList<Color> colours = new ArrayList<Color>();
        for (S57val.ColCOL col : Rules.getAttList(obj, S57att.Att.COLOUR)) {
            colours.add(bodyColours.get((Object)col));
        }
        ArrayList<Symbols.Patt> patterns = new ArrayList<Symbols.Patt>();
        for (S57val.ColPAT pat : Rules.getAttList(obj, S57att.Att.COLPAT)) {
            patterns.add(pattMap.get((Object)pat));
        }
        return new Symbols.Scheme(patterns, colours);
    }

    static boolean hasAttribute(S57obj.Obj obj, S57att.Att att) {
        S57map.AttMap atts = Rules.getAtts(obj, 0);
        if (atts != null) {
            S57val.AttVal item = (S57val.AttVal)atts.get((Object)att);
            return item != null;
        }
        return false;
    }

    static boolean testAttribute(S57obj.Obj obj, S57att.Att att, Object val) {
        S57val.AttVal item;
        S57map.AttMap atts = Rules.getAtts(obj, 0);
        if (atts != null && (item = (S57val.AttVal)atts.get((Object)att)) != null) {
            switch (item.conv) {
                case S: 
                case A: {
                    return ((String)item.val).equals(val);
                }
                case E: 
                case L: {
                    return ((ArrayList)item.val).contains(val);
                }
                case F: 
                case I: {
                    return item.val == val;
                }
            }
        }
        return false;
    }

    static boolean hasObject(S57obj.Obj obj) {
        return Rules.feature.objs.containsKey((Object)obj);
    }

    static boolean testObject(S57obj.Obj obj) {
        objects = (ArrayList)Renderer.map.features.get((Object)obj);
        return objects != null;
    }

    static boolean testFeature(S57map.Feature f) {
        feature = f;
        return Rules.feature.reln == S57map.Rflag.MASTER;
    }

    public static boolean rules() {
        try {
            if (Renderer.context.ruleset() == ChartContext.RuleSet.ALL || Renderer.context.ruleset() == ChartContext.RuleSet.BASE) {
                if (Rules.testObject(S57obj.Obj.LNDARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SOUNDG)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.depths();
                    }
                }
                if (Rules.testObject(S57obj.Obj.DEPCNT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.depths();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TESARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BUAARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.HRBFAC)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.HRBBSN)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LOKBSN)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LKBSPT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.COALNE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LAKARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RIVERS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.waterways();
                    }
                }
                if (Rules.testObject(S57obj.Obj.CANALS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.waterways();
                    }
                }
                if (Rules.testObject(S57obj.Obj.DEPARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.ROADWY)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.highways();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RAILWY)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.highways();
                    }
                }
            }
            if (Rules.testObject(S57obj.Obj.SLCONS)) {
                for (S57map.Feature f : objects) {
                    if (!Rules.testFeature(f)) continue;
                    Rules.shoreline();
                }
            }
            if (Renderer.context.ruleset() == ChartContext.RuleSet.ALL || Renderer.context.ruleset() == ChartContext.RuleSet.SEAMARK) {
                if (Rules.testObject(S57obj.Obj.PIPSOL)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.pipelines();
                    }
                }
                if (Rules.testObject(S57obj.Obj.CBLSUB)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.cables();
                    }
                }
                if (Rules.testObject(S57obj.Obj.PIPOHD)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.pipelines();
                    }
                }
                if (Rules.testObject(S57obj.Obj.CBLOHD)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.cables();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TSEZNE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TSSCRS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TSSRON)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TSELNE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TSSLPT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TSSBND)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.ISTZNE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.separation();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SBDARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SPRING)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SNDWAV)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.WEDKLP)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SEGRAS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.OSPARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.FAIRWY)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.DRGARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RESARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.PRCARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SPLARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SEAARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.CBLARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.PIPARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.DMPGRD)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.OBSTRN)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.obstructions();
                    }
                }
                if (Rules.testObject(S57obj.Obj.UWTROC)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.obstructions();
                    }
                }
                if (Rules.testObject(S57obj.Obj.MARCUL)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.areas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RECTRC)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.transits();
                    }
                }
                if (Rules.testObject(S57obj.Obj.NAVLNE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.transits();
                    }
                }
                if (Rules.testObject(S57obj.Obj.HRBFAC)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.harbours();
                    }
                }
                if (Rules.testObject(S57obj.Obj.ACHARE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.harbours();
                    }
                }
                if (Rules.testObject(S57obj.Obj.ACHBRT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.harbours();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BERTHS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.harbours();
                    }
                }
                if (Rules.testObject(S57obj.Obj.DISMAR)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.distances();
                    }
                }
                if (Rules.testObject(S57obj.Obj.HULKES)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.ports();
                    }
                }
                if (Rules.testObject(S57obj.Obj.CRANES)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.ports();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LNDMRK)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.landmarks();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SILTNK)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.landmarks();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BUISGL)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.harbours();
                    }
                }
                if (Rules.testObject(S57obj.Obj.MORFAC)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.moorings();
                    }
                }
                if (Rules.testObject(S57obj.Obj.NOTMRK)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.notices();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SMCFAC)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.marinas();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BRIDGE)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.bridges();
                    }
                }
                if (Rules.testObject(S57obj.Obj.PILPNT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.points();
                    }
                }
                if (Rules.testObject(S57obj.Obj.TOPMAR)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.points();
                    }
                }
                if (Rules.testObject(S57obj.Obj.DAYMAR)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.points();
                    }
                }
                if (Rules.testObject(S57obj.Obj.FOGSIG)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.points();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RDOCAL)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.callpoint();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LITMIN)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.lights();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LITMAJ)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.lights();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LIGHTS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.lights();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SISTAT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.SISTAW)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.CGUSTA)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RDOSTA)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RADRFL)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RADSTA)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RTPBCN)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.RSCSTA)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.PILBOP)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.stations();
                    }
                }
                if (Rules.testObject(S57obj.Obj.WTWGAG)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.gauges();
                    }
                }
                if (Rules.testObject(S57obj.Obj.OFSPLF)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.platforms();
                    }
                }
                if (Rules.testObject(S57obj.Obj.WRECKS)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.wrecks();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LITVES)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.floats();
                    }
                }
                if (Rules.testObject(S57obj.Obj.LITFLT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.floats();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BOYINB)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.floats();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BOYLAT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.buoys();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BOYCAR)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.buoys();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BOYISD)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.buoys();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BOYSAW)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.buoys();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BOYSPP)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.buoys();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BCNLAT)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.beacons();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BCNCAR)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.beacons();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BCNISD)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.beacons();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BCNSAW)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.beacons();
                    }
                }
                if (Rules.testObject(S57obj.Obj.BCNSPP)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.beacons();
                    }
                }
                if (Rules.testObject(S57obj.Obj.VAATON)) {
                    for (S57map.Feature f : objects) {
                        if (!Rules.testFeature(f)) continue;
                        Rules.virtual();
                    }
                }
            }
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        return true;
    }

    private static void areas() {
        String name = Rules.getName();
        block0 : switch (Rules.feature.type) {
            case TESARE: {
                Renderer.lineSymbols(Areas.LimitDash, 0.0, Areas.LimitCC, null, 30, Symbols.Mline);
                break;
            }
            case BUAARE: {
                Renderer.lineVector(new Symbols.LineStyle(new Color(0x20000000, true)));
                break;
            }
            case COALNE: {
                if (Renderer.zoom < 12) break;
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f));
                break;
            }
            case DEPARE: {
                Double depmax = (Double)Rules.getAttVal(S57obj.Obj.DEPARE, S57att.Att.DRVAL2);
                if (depmax == null) break;
                if (depmax <= 0.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Symbols.Gdries));
                    break;
                }
                if (depmax <= 2.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(2134271)));
                    break;
                }
                if (depmax <= 5.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(4235519)));
                    break;
                }
                if (depmax <= 10.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(6336767)));
                    break;
                }
                if (depmax <= 15.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(8438015)));
                    break;
                }
                if (depmax <= 20.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(10539263)));
                    break;
                }
                if (depmax <= 50.0) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(12640511)));
                    break;
                }
                Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f, new Color(0xE0F0FF)));
                break;
            }
            case CANALS: 
            case LAKARE: 
            case RIVERS: {
                if (Renderer.zoom < 12 && !(Rules.feature.geom.area > 10.0)) break;
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Bwater, 11.0f, Symbols.Bwater));
                break;
            }
            case DRGARE: {
                if (Renderer.zoom < 16) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.black, 8.0f, new float[]{25.0f, 25.0f}, new Color(0x40FFFFFF, true)));
                } else {
                    Renderer.lineVector(new Symbols.LineStyle(Color.black, 8.0f, new float[]{25.0f, 25.0f}));
                }
                Rules.addName(12, new Font("Arial", 0, 100), new Symbols.Delta(Symbols.Handle.CC, new AffineTransform()));
                break;
            }
            case FAIRWY: {
                if (Renderer.zoom < 12) break;
                if (Rules.feature.geom.area > 1.0) {
                    if (Renderer.zoom < 16) {
                        Renderer.lineVector(new Symbols.LineStyle(new Color(0x20FFFFFF, true)));
                        break;
                    }
                    Renderer.lineVector(new Symbols.LineStyle(Symbols.Mline, 8.0f, new float[]{50.0f, 50.0f}));
                    break;
                }
                if (Renderer.zoom < 14) break;
                Renderer.lineVector(new Symbols.LineStyle(new Color(0x20FFFFFF, true)));
                break;
            }
            case LKBSPT: 
            case LOKBSN: 
            case HRBBSN: {
                if (Renderer.zoom >= 12) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f, Symbols.Bwater));
                    break;
                }
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Bwater));
                break;
            }
            case HRBFAC: {
                if (Rules.feature.objs.get((Object)S57obj.Obj.HRBBSN) == null) break;
                if (Renderer.zoom >= 12) {
                    Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f, Symbols.Bwater));
                    break;
                }
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Bwater));
                break;
            }
            case LNDARE: {
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Yland));
                break;
            }
            case MARCUL: {
                if (Renderer.zoom < 12) break;
                if (Renderer.zoom >= 14) {
                    Renderer.symbol(Areas.MarineFarm);
                }
                if (!(Rules.feature.geom.area > 0.2 || Rules.feature.geom.area > 0.05 && Renderer.zoom >= 14) && (!(Rules.feature.geom.area > 0.005) || Renderer.zoom < 16)) break;
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 4.0f, new float[]{10.0f, 10.0f}));
                break;
            }
            case OSPARE: {
                if (!Rules.testAttribute(Rules.feature.type, S57att.Att.CATOPA, (Object)S57val.CatOPA.OPA_WIND)) break;
                Renderer.symbol(Areas.WindFarm);
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 12.0f, new float[]{40.0f, 40.0f}));
                Rules.addName(15, new Font("Arial", 1, 80), new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 120.0)));
                break;
            }
            case RESARE: 
            case MIPARE: 
            case DMPGRD: {
                if (Renderer.zoom < 12) break;
                Renderer.lineSymbols(Areas.Restricted, 1.0, null, null, 0, Symbols.Mline);
                if (!Rules.testAttribute(Rules.feature.type, S57att.Att.CATREA, (Object)S57val.CatREA.REA_NWAK)) break;
                Renderer.symbol(Areas.NoWake);
                break;
            }
            case PRCARE: {
                if (Renderer.zoom < 12) break;
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Mline, 10.0f, new float[]{40.0f, 40.0f}));
                break;
            }
            case SEAARE: {
                switch ((S57val.CatSEA)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATSEA)) {
                    case SEA_RECH: {
                        if (Renderer.zoom < 15 || name == null) break block0;
                        if (Rules.feature.geom.prim == S57map.Pflag.LINE) {
                            Renderer.lineText(name, new Font("Arial", 0, 60), Color.black, -40.0);
                            break block0;
                        }
                        Renderer.labelText(name, new Font("Arial", 0, 60), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 0.0)));
                        break block0;
                    }
                    case SEA_BAY: {
                        if (Renderer.zoom < 15 || name == null) break block0;
                        if (Rules.feature.geom.prim == S57map.Pflag.LINE) {
                            Renderer.lineText(name, new Font("Arial", 0, 60), Color.black, -40.0);
                            break block0;
                        }
                        Renderer.labelText(name, new Font("Arial", 0, 60), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 0.0)));
                        break block0;
                    }
                    case SEA_SHOL: {
                        if (Renderer.zoom < 14) break block0;
                        if (Rules.feature.geom.prim == S57map.Pflag.AREA) {
                            Renderer.lineVector(new Symbols.LineStyle(new Color(12878079), 4.0f, new float[]{25.0f, 25.0f}));
                            if (name == null) break block0;
                            Renderer.labelText(name, new Font("Arial", 2, 75), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -40.0)));
                            Renderer.labelText("(Shoal)", new Font("Arial", 0, 60), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 20.0)));
                            break block0;
                        }
                        if (Rules.feature.geom.prim == S57map.Pflag.LINE) {
                            if (name == null) break block0;
                            Renderer.lineText(name, new Font("Arial", 2, 75), Color.black, -40.0);
                            Renderer.lineText("(Shoal)", new Font("Arial", 0, 60), Color.black, 20.0);
                            break block0;
                        }
                        if (name == null) break block0;
                        Renderer.labelText(name, new Font("Arial", 2, 75), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -40.0)));
                        Renderer.labelText("(Shoal)", new Font("Arial", 0, 60), Color.black, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 20.0)));
                        break block0;
                    }
                    case SEA_GAT: 
                    case SEA_NRRW: {
                        Rules.addName(12, new Font("Arial", 0, 100));
                        break block0;
                    }
                }
                break;
            }
            case SNDWAV: {
                if (Renderer.zoom < 14) break;
                Renderer.fillPattern(Areas.Sandwaves);
                break;
            }
            case SBDARE: {
                if (Renderer.zoom < 14) break;
                String str = "";
                String sep = ".";
                if (!Rules.hasAttribute(Rules.feature.type, S57att.Att.NATSUR)) break;
                ArrayList<?> surs = Rules.getAttList(Rules.feature.type, S57att.Att.NATSUR);
                ArrayList<Object> quas = new ArrayList();
                if (Rules.hasAttribute(Rules.feature.type, S57att.Att.NATQUA)) {
                    quas = Rules.getAttList(Rules.feature.type, S57att.Att.NATQUA);
                }
                block64: for (int i = 0; i < surs.size(); ++i) {
                    if (!str.isEmpty()) {
                        str = str + sep;
                        sep = ".";
                    }
                    if (quas.size() > i) {
                        switch ((S57val.NatQUA)((Object)quas.get(i))) {
                            case QUA_FINE: {
                                str = str + "f";
                                break;
                            }
                            case QUA_MEDM: {
                                str = str + "m";
                                break;
                            }
                            case QUA_CORS: {
                                str = str + "c";
                                break;
                            }
                            case QUA_BRKN: {
                                str = str + "bk";
                                break;
                            }
                            case QUA_STKY: {
                                str = str + "sy";
                                break;
                            }
                            case QUA_SOFT: {
                                str = str + "so";
                                break;
                            }
                            case QUA_STIF: {
                                str = str + "sf";
                                break;
                            }
                            case QUA_VCNC: {
                                str = str + "v";
                                break;
                            }
                            case QUA_CALC: {
                                str = str + "ca";
                                break;
                            }
                            case QUA_HARD: {
                                str = str + "h";
                                break;
                            }
                        }
                    }
                    switch ((S57val.NatSUR)((Object)surs.get(i))) {
                        case SUR_MUD: {
                            str = str + "M";
                            continue block64;
                        }
                        case SUR_CLAY: {
                            str = str + "Cy";
                            continue block64;
                        }
                        case SUR_SILT: {
                            str = str + "Si";
                            continue block64;
                        }
                        case SUR_SAND: {
                            str = str + "S";
                            continue block64;
                        }
                        case SUR_STON: {
                            str = str + "St";
                            continue block64;
                        }
                        case SUR_GRVL: {
                            str = str + "G";
                            continue block64;
                        }
                        case SUR_PBBL: {
                            str = str + "P";
                            continue block64;
                        }
                        case SUR_CBBL: {
                            str = str + "Cb";
                            continue block64;
                        }
                        case SUR_ROCK: {
                            str = str + "R";
                            if (Rules.feature.geom.prim == S57map.Pflag.POINT) continue block64;
                            Renderer.lineSymbols(Areas.Rocks, 1.0, null, null, 0, Color.black);
                            continue block64;
                        }
                        case SUR_LAVA: {
                            str = str + "Lv";
                            continue block64;
                        }
                        case SUR_CORL: {
                            str = str + "Co";
                            if (Rules.feature.geom.prim == S57map.Pflag.POINT) continue block64;
                            Renderer.lineSymbols(Areas.Coral, 1.0, null, null, 0, Color.black);
                            continue block64;
                        }
                        case SUR_SHEL: {
                            str = str + "Sh";
                            continue block64;
                        }
                        case SUR_BLDR: {
                            str = str + "Bo";
                            continue block64;
                        }
                        default: {
                            str = str.substring(0, str.length() - 1) + "/";
                            sep = "";
                        }
                    }
                }
                if (str.isEmpty()) break;
                Renderer.labelText(str, new Font("Arial", 2, 40), Color.black, new Symbols.Delta(Symbols.Handle.CC));
                break;
            }
            case WEDKLP: {
                if (Renderer.zoom < 14) break;
                switch ((S57val.CatWED)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATWED)) {
                    case WED_KELP: {
                        Renderer.fillPattern(Areas.Kelp);
                        break block0;
                    }
                    case WED_SWED: {
                        Renderer.labelText("Wd", new Font("Arial", 2, 40), Color.black, new Symbols.Delta(Symbols.Handle.CC));
                        break block0;
                    }
                    case WED_SGRS: {
                        Renderer.fillPattern(Areas.Seagrass);
                        break block0;
                    }
                    case WED_SGSO: {
                        break block0;
                    }
                }
                break;
            }
            case SEGRAS: {
                if (Renderer.zoom < 14) break;
                Renderer.fillPattern(Areas.Seagrass);
                break;
            }
            case SPRING: {
                Renderer.symbol(Areas.Spring);
                break;
            }
            case SPLARE: {
                if (Renderer.zoom < 12) break;
                Renderer.symbol(Areas.Plane, new Symbols.Scheme(Symbols.Msymb));
                Renderer.lineSymbols(Areas.Restricted, 0.5, Areas.LinePlane, null, 10, Symbols.Mline);
                Rules.addName(15, new Font("Arial", 1, 80), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -90.0)));
                break;
            }
            case CBLARE: {
                if (Renderer.zoom < 12) break;
                Renderer.lineSymbols(Areas.Restricted, 1.0, Areas.Cable, null, 4, Symbols.Mline);
                break;
            }
            case PIPARE: {
                if (Renderer.zoom < 12) break;
                Renderer.lineSymbols(Areas.Restricted, 1.0, Areas.Pipeline, null, 4, Symbols.Mline);
                break;
            }
        }
    }

    private static void beacons() {
        if (Renderer.zoom >= 14 || Renderer.zoom >= 12 && (Rules.feature.type == S57obj.Obj.BCNLAT || Rules.feature.type == S57obj.Obj.BCNCAR) || Renderer.zoom >= 11 && (Rules.feature.type == S57obj.Obj.BCNSAW || Rules.hasObject(S57obj.Obj.RTPBCN))) {
            S57val.BcnSHP shape;
            if (Rules.testAttribute(Rules.feature.type, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
                Renderer.symbol(Beacons.Floodlight);
            }
            if ((shape = (S57val.BcnSHP)Rules.getAttEnum(Rules.feature.type, S57att.Att.BCNSHP)) == S57val.BcnSHP.BCN_UNKN) {
                shape = S57val.BcnSHP.BCN_PILE;
            }
            if (shape == S57val.BcnSHP.BCN_WTHY && Rules.feature.type == S57obj.Obj.BCNLAT) {
                switch ((S57val.CatLAM)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATLAM)) {
                    case LAM_PORT: {
                        Renderer.symbol(Beacons.WithyPort);
                        break;
                    }
                    case LAM_STBD: {
                        Renderer.symbol(Beacons.WithyStarboard);
                        break;
                    }
                    default: {
                        Renderer.symbol(Beacons.Stake, Rules.getScheme(Rules.feature.type));
                        break;
                    }
                }
            } else if (shape == S57val.BcnSHP.BCN_PRCH && Rules.feature.type == S57obj.Obj.BCNLAT && !Rules.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                switch ((S57val.CatLAM)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATLAM)) {
                    case LAM_PORT: {
                        Renderer.symbol(Beacons.PerchPort);
                        break;
                    }
                    case LAM_STBD: {
                        Renderer.symbol(Beacons.PerchStarboard);
                        break;
                    }
                    default: {
                        Renderer.symbol(Beacons.Stake, Rules.getScheme(Rules.feature.type));
                        break;
                    }
                }
            } else {
                S57map.AttMap topmap;
                Renderer.symbol(Beacons.Shapes.get((Object)shape), Rules.getScheme(Rules.feature.type));
                if (Rules.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                    S57map.AttMap topmap2 = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.TOPMAR)).get(0);
                    if (Rules.testAttribute(S57obj.Obj.TOPMAR, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
                        Renderer.symbol(Beacons.Floodlight);
                    }
                    if (topmap2.containsKey((Object)S57att.Att.TOPSHP)) {
                        Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap2.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.TOPMAR), Topmarks.BeaconDelta);
                    }
                } else if (Rules.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmap = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.DAYMAR)).get(0)).containsKey((Object)S57att.Att.TOPSHP)) {
                    Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.DAYMAR), Topmarks.BeaconDelta);
                }
            }
            if (Rules.hasObject(S57obj.Obj.NOTMRK)) {
                Rules.notices();
            }
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(60.0, -50.0)));
            Signals.addSignals();
        }
    }

    private static void buoys() {
        if (Renderer.zoom >= 14 || Renderer.zoom >= 12 && (Rules.feature.type == S57obj.Obj.BOYLAT || Rules.feature.type == S57obj.Obj.BOYCAR) || Renderer.zoom >= 11 && (Rules.feature.type == S57obj.Obj.BOYSAW || Rules.hasObject(S57obj.Obj.RTPBCN))) {
            S57map.AttMap topmap;
            S57val.BoySHP shape = (S57val.BoySHP)Rules.getAttEnum(Rules.feature.type, S57att.Att.BOYSHP);
            if (shape == S57val.BoySHP.BOY_UNKN) {
                shape = S57val.BoySHP.BOY_PILR;
            }
            Renderer.symbol(Buoys.Shapes.get((Object)shape), Rules.getScheme(Rules.feature.type));
            if (Rules.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                S57map.AttMap topmap2 = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.TOPMAR)).get(0);
                if (topmap2.containsKey((Object)S57att.Att.TOPSHP)) {
                    Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap2.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.TOPMAR), Topmarks.BuoyDeltas.get((Object)shape));
                }
            } else if (Rules.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmap = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.DAYMAR)).get(0)).containsKey((Object)S57att.Att.TOPSHP)) {
                Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.DAYMAR), Topmarks.BuoyDeltas.get((Object)shape));
            }
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(60.0, -50.0)));
            Signals.addSignals();
        }
    }

    private static void bridges() {
        if (Renderer.zoom >= 16) {
            S57map.AttMap atts = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.BRIDGE)).get(0);
            String vstr = "";
            String hstr = "";
            if (atts != null) {
                double vercop;
                if (atts.containsKey((Object)S57att.Att.HORCLR)) {
                    double horclr = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.HORCLR))).val;
                    hstr = String.valueOf(horclr);
                }
                double verclr = atts.containsKey((Object)S57att.Att.VERCLR) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCLR))).val : (atts.containsKey((Object)S57att.Att.VERCSA) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCSA))).val : 0.0);
                double verccl = atts.containsKey((Object)S57att.Att.VERCCL) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCCL))).val : 0.0;
                double d = vercop = atts.containsKey((Object)S57att.Att.VERCOP) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCOP))).val : 0.0;
                if (verclr > 0.0) {
                    vstr = vstr + String.valueOf(verclr);
                } else if (verccl > 0.0) {
                    vstr = vercop == 0.0 ? vstr + String.valueOf(verccl) + "/-" : vstr + String.valueOf(verccl) + "/" + String.valueOf(vercop);
                }
                if (hstr.isEmpty() && !vstr.isEmpty()) {
                    Renderer.labelText(vstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.VCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.CC));
                } else if (!hstr.isEmpty() && !vstr.isEmpty()) {
                    Renderer.labelText(vstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.VCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.BC));
                    Renderer.labelText(hstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.HCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.TC));
                } else if (!hstr.isEmpty() && vstr.isEmpty()) {
                    Renderer.labelText(hstr, new Font("Arial", 0, 30), Color.black, Renderer.LabelStyle.HCLR, Color.black, Color.white, new Symbols.Delta(Symbols.Handle.CC));
                }
            }
            Signals.addSignals();
        }
    }

    private static void cables() {
        if (Renderer.zoom >= 14 && Rules.feature.geom.length > 2.0 && Rules.feature.geom.length < 20.0 || Renderer.zoom >= 16 && Rules.feature.geom.length <= 2.0) {
            if (Rules.feature.type == S57obj.Obj.CBLSUB) {
                Renderer.lineSymbols(Areas.Cable, 0.0, null, null, 0, Symbols.Mline);
            } else if (Rules.feature.type == S57obj.Obj.CBLOHD) {
                S57map.AttMap atts = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.CBLOHD)).get(0);
                if (atts != null && atts.containsKey((Object)S57att.Att.CATCBL) && ((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATCBL))).val == S57val.CatCBL.CBL_POWR) {
                    Renderer.lineSymbols(Areas.CableDash, 0.0, Areas.CableDot, Areas.CableFlash, 2, Color.black);
                } else {
                    Renderer.lineSymbols(Areas.CableDash, 0.0, Areas.CableDot, null, 2, Color.black);
                }
                if (atts != null) {
                    if (atts.containsKey((Object)S57att.Att.VERCLR)) {
                        Renderer.labelText(String.valueOf(((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCLR))).val), new Font("Arial", 0, 50), Color.black, Renderer.LabelStyle.VCLR, Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 25.0)));
                    } else if (atts.containsKey((Object)S57att.Att.VERCSA)) {
                        Renderer.labelText(String.valueOf(((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCSA))).val), new Font("Arial", 0, 50), Color.black, Renderer.LabelStyle.PCLR, Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 25.0)));
                    }
                }
            }
        }
    }

    private static void callpoint() {
        if (Renderer.zoom >= 14) {
            Symbols.Symbol symb = Harbours.CallPoint2;
            S57val.TrfTRF trf = (S57val.TrfTRF)Rules.getAttEnum(Rules.feature.type, S57att.Att.TRAFIC);
            if (trf != S57val.TrfTRF.TRF_TWOW) {
                symb = Harbours.CallPoint1;
            }
            Double orient = 0.0;
            orient = (Double)Rules.getAttVal(Rules.feature.type, S57att.Att.ORIENT);
            if (orient == null) {
                orient = 0.0;
            }
            Renderer.symbol(symb, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getRotateInstance(Math.toRadians(orient))));
            String chn = Rules.getAttStr(Rules.feature.type, S57att.Att.COMCHA);
            if (!chn.isEmpty()) {
                Renderer.labelText("Ch." + chn, new Font("Arial", 0, 50), Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 50.0)));
            }
        }
    }

    private static void depths() {
        switch (Rules.feature.type) {
            case SOUNDG: {
                if (Rules.testAttribute(S57obj.Obj.SOUNDG, S57att.Att.TECSOU, (Object)S57val.TecSOU.SOU_COMP) && Rules.hasAttribute(S57obj.Obj.SOUNDG, S57att.Att.VALSOU)) {
                    double depth = (Double)Rules.getAttVal(S57obj.Obj.SOUNDG, S57att.Att.VALSOU);
                    Color col = new Color(0xFFFFFF, true);
                    if (depth > 0.0) {
                        col = new Color(2134271);
                    }
                    if (depth > 2.0) {
                        col = new Color(4235519);
                    }
                    if (depth > 5.0) {
                        col = new Color(6336767);
                    }
                    if (depth > 10.0) {
                        col = new Color(8438015);
                    }
                    if (depth > 15.0) {
                        col = new Color(10539263);
                    }
                    if (depth > 20.0) {
                        col = new Color(12640511);
                    }
                    if (depth > 50.0) {
                        col = new Color(0xE0F0FF);
                    }
                    Renderer.rasterPixel(Math.toRadians(0.0010416666666666667), col);
                    break;
                }
                if (Renderer.zoom < 14 || !Rules.hasAttribute(S57obj.Obj.SOUNDG, S57att.Att.VALSOU)) break;
                double depth = (Double)Rules.getAttVal(S57obj.Obj.SOUNDG, S57att.Att.VALSOU);
                String dstr = df.format(depth);
                String[] tok = dstr.split("[-.]");
                String ul = "";
                String id = tok[0];
                String dd = "";
                if (tok[0].equals("")) {
                    for (int i = 0; i < tok[1].length(); ++i) {
                        ul = ul + "_";
                    }
                    id = tok[1];
                    dd = tok.length == 3 ? tok[2] : "";
                } else {
                    dd = tok.length == 2 ? tok[1] : "";
                }
                Renderer.labelText(ul, new Font("Arial", 0, 30), Color.black, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(10.0, 15.0)));
                Renderer.labelText(id, new Font("Arial", 0, 30), Color.black, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(10.0, 0.0)));
                Renderer.labelText(dd, new Font("Arial", 0, 20), Color.black, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(15.0, 10.0)));
                break;
            }
            case DEPCNT: {
                Renderer.lineVector(new Symbols.LineStyle(Color.blue, 2.0f));
                break;
            }
        }
    }

    private static void distances() {
        if (Renderer.zoom >= 14) {
            S57map.AttMap atts;
            if (!Rules.testAttribute(S57obj.Obj.DISMAR, S57att.Att.CATDIS, (Object)S57val.CatDIS.DIS_NONI)) {
                Renderer.symbol(Harbours.DistanceI);
            } else {
                Renderer.symbol(Harbours.DistanceU);
            }
            if (Renderer.zoom >= 15 && (atts = Rules.getAtts(S57obj.Obj.DISMAR, 0)) != null && atts.containsKey((Object)S57att.Att.WTWDIS)) {
                Double dist = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.WTWDIS))).val;
                String str = "";
                if (atts.containsKey((Object)S57att.Att.HUNITS)) {
                    switch ((S57val.UniHLU)Rules.getAttEnum(S57obj.Obj.DISMAR, S57att.Att.HUNITS)) {
                        case HLU_METR: {
                            str = str + "m ";
                            break;
                        }
                        case HLU_FEET: {
                            str = str + "ft ";
                            break;
                        }
                        case HLU_HMTR: {
                            str = str + "hm ";
                            break;
                        }
                        case HLU_KMTR: {
                            str = str + "km ";
                            break;
                        }
                        case HLU_SMIL: {
                            str = str + "M ";
                            break;
                        }
                        case HLU_NMIL: {
                            str = str + "NM ";
                            break;
                        }
                    }
                }
                str = str + String.format("%3.1f", dist);
                Renderer.labelText(str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(0.0, 45.0)));
            }
        }
    }

    private static void floats() {
        if (Renderer.zoom >= 12 || Renderer.zoom >= 11 && (Rules.feature.type == S57obj.Obj.LITVES || Rules.feature.type == S57obj.Obj.BOYINB || Rules.hasObject(S57obj.Obj.RTPBCN))) {
            S57map.AttMap topmap;
            switch (Rules.feature.type) {
                case LITVES: {
                    Renderer.symbol(Buoys.Super, Rules.getScheme(Rules.feature.type));
                    break;
                }
                case LITFLT: {
                    Renderer.symbol(Buoys.Float, Rules.getScheme(Rules.feature.type));
                    break;
                }
                case BOYINB: {
                    Renderer.symbol(Buoys.Super, Rules.getScheme(Rules.feature.type));
                    break;
                }
            }
            if (Rules.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                S57map.AttMap topmap2 = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.TOPMAR)).get(0);
                if (topmap2.containsKey((Object)S57att.Att.TOPSHP)) {
                    Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap2.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.TOPMAR), Topmarks.FloatDelta);
                }
            } else if (Rules.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmap = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.DAYMAR)).get(0)).containsKey((Object)S57att.Att.TOPSHP)) {
                Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.DAYMAR), Topmarks.FloatDelta);
            }
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(20.0, -50.0)));
            Signals.addSignals();
        }
    }

    private static void gauges() {
        if (Renderer.zoom >= 14) {
            Renderer.symbol(Harbours.TideGauge);
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(20.0, -50.0)));
            Signals.addSignals();
        }
    }

    private static void harbours() {
        String name = Rules.getName();
        switch (Rules.feature.type) {
            case ACHBRT: {
                double radius;
                if (Renderer.zoom >= 14) {
                    Renderer.symbol(Harbours.Anchor, new Symbols.Scheme(Symbols.Msymb));
                    if (Renderer.zoom >= 15) {
                        Renderer.labelText(name == null ? "" : name, new Font("Arial", 0, 30), Symbols.Msymb, Renderer.LabelStyle.RRCT, Symbols.Msymb, Color.white, new Symbols.Delta(Symbols.Handle.BC));
                    }
                }
                if (Rules.getAttVal(S57obj.Obj.ACHBRT, S57att.Att.RADIUS) == null || (radius = ((Double)Rules.getAttVal(S57obj.Obj.ACHBRT, S57att.Att.RADIUS)).doubleValue()) == 0.0) break;
                S57val.UniHLU units = (S57val.UniHLU)Rules.getAttEnum(S57obj.Obj.ACHBRT, S57att.Att.HUNITS);
                if (units == S57val.UniHLU.HLU_UNKN) {
                    units = S57val.UniHLU.HLU_METR;
                }
                Renderer.lineCircle(new Symbols.LineStyle(Symbols.Mline, 4.0f, new float[]{10.0f, 10.0f}, null), radius, units);
                break;
            }
            case ACHARE: {
                if (Renderer.zoom < 12) break;
                ArrayList<S57val.CatACH> cats = Rules.getAttList(S57obj.Obj.ACHARE, S57att.Att.CATACH);
                if (Rules.feature.geom.prim != S57map.Pflag.AREA) {
                    Renderer.symbol(Harbours.Anchorage, new Symbols.Scheme(Color.black));
                } else {
                    if (cats.contains((Object)S57val.CatACH.ACH_SMCM)) {
                        Renderer.symbol(Buoys.Shapes.get((Object)S57val.BoySHP.BOY_SPHR), new Symbols.Scheme(Symbols.Msymb));
                        Renderer.symbol(Topmarks.TopMooring, Topmarks.BuoyDeltas.get((Object)S57val.BoySHP.BOY_SPHR));
                    } else {
                        Renderer.symbol(Harbours.Anchorage, new Symbols.Scheme(Symbols.Mline));
                    }
                    Renderer.lineSymbols(Areas.Restricted, 1.0, Areas.LineAnchor, null, 10, Symbols.Mline);
                }
                Rules.addName(15, new Font("Arial", 1, 60), Symbols.Mline, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(70.0, 0.0)));
                ArrayList<?> sts = Rules.getAttList(S57obj.Obj.ACHARE, S57att.Att.STATUS);
                if (Renderer.zoom >= 15 && sts.contains((Object)S57val.StsSTS.STS_RESV)) {
                    Renderer.labelText("Reserved", new Font("Arial", 0, 50), Symbols.Mline, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 60.0)));
                }
                int dy = (cats.size() - 1) * -30;
                for (S57val.CatACH cat : cats) {
                    switch (cat) {
                        case ACH_DEEP: {
                            Renderer.labelText("DW", new Font("Arial", 1, 50), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_TANK: {
                            Renderer.labelText("Tanker", new Font("Arial", 1, 50), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_H24P: {
                            Renderer.labelText("24h", new Font("Arial", 1, 50), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_EXPL: {
                            Renderer.symbol(Harbours.Explosives, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_QUAR: {
                            Renderer.symbol(Harbours.Hospital, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_SEAP: {
                            Renderer.symbol(Areas.Seaplane, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            dy += 60;
                            break;
                        }
                        case ACH_SMCF: 
                        case ACH_SMCM: {
                            Renderer.labelText("Small", new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.RC, AffineTransform.getTranslateInstance(-60.0, dy)));
                            Renderer.labelText("Craft", new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(60.0, dy)));
                            dy += 60;
                            break;
                        }
                    }
                }
                break;
            }
            case BERTHS: {
                if (Renderer.zoom < 14) break;
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Mline, 6.0f, new float[]{20.0f, 20.0f}));
                Renderer.labelText(name == null ? " " : name, new Font("Arial", 0, 40), Symbols.Msymb, Renderer.LabelStyle.RRCT, Symbols.Mline, Color.white);
                break;
            }
            case BUISGL: {
                if (Renderer.zoom < 15) break;
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 8.0f, new Color(-4144960, true)));
                if (Rules.testAttribute(S57obj.Obj.BUISGL, S57att.Att.FUNCTN, (Object)S57val.FncFNC.FNC_LOOK)) {
                    Renderer.labelText("Lookout", new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(0.0, 50.0)));
                    Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(0.0, -50.0)));
                }
                if (Renderer.zoom < 16) break;
                if (Rules.testAttribute(S57obj.Obj.BUISGL, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
                    Renderer.symbol(Beacons.Floodlight);
                }
                ArrayList<Symbols.Symbol> symbols = new ArrayList<Symbols.Symbol>();
                ArrayList<S57val.FncFNC> fncs = Rules.getAttList(S57obj.Obj.BUISGL, S57att.Att.FUNCTN);
                for (S57val.FncFNC fnc : fncs) {
                    symbols.add(Landmarks.Funcs.get((Object)fnc));
                }
                if (Rules.feature.objs.containsKey((Object)S57obj.Obj.SMCFAC)) {
                    ArrayList<S57val.CatSCF> scfs = Rules.getAttList(S57obj.Obj.SMCFAC, S57att.Att.CATSCF);
                    for (S57val.CatSCF scf : scfs) {
                        symbols.add(Facilities.Cats.get((Object)scf));
                    }
                }
                Renderer.cluster(symbols);
                Signals.addSignals();
                break;
            }
            case HRBFAC: {
                if (Renderer.zoom < 12) break;
                ArrayList<?> cathaf = Rules.getAttList(S57obj.Obj.HRBFAC, S57att.Att.CATHAF);
                if (cathaf.size() == 1) {
                    switch ((S57val.CatHAF)((Object)cathaf.get(0))) {
                        case HAF_MRNA: {
                            Renderer.symbol(Harbours.Marina);
                            break;
                        }
                        case HAF_MANF: {
                            Renderer.symbol(Harbours.MarinaNF);
                            break;
                        }
                        case HAF_FISH: {
                            Renderer.symbol(Harbours.Fishing);
                            break;
                        }
                        default: {
                            Renderer.symbol(Harbours.Harbour);
                            break;
                        }
                    }
                } else {
                    Renderer.symbol(Harbours.Harbour);
                }
                Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(0.0, -80.0)));
                break;
            }
        }
    }

    private static void highways() {
        block0 : switch (Rules.feature.type) {
            case ROADWY: {
                ArrayList<?> cat = Rules.getAttList(S57obj.Obj.ROADWY, S57att.Att.CATROD);
                if (cat.size() > 0) {
                    switch ((S57val.CatROD)((Object)cat.get(0))) {
                        case ROD_MWAY: {
                            Renderer.lineVector(new Symbols.LineStyle(Color.black, 20.0f));
                            break block0;
                        }
                        case ROD_MAJR: {
                            Renderer.lineVector(new Symbols.LineStyle(Color.black, 15.0f));
                            break block0;
                        }
                        case ROD_MINR: {
                            Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f));
                            break block0;
                        }
                    }
                    Renderer.lineVector(new Symbols.LineStyle(Color.black, 5.0f));
                    break;
                }
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 5.0f));
                break;
            }
            case RAILWY: {
                Renderer.lineVector(new Symbols.LineStyle(Color.gray, 10.0f));
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f, new float[]{30.0f, 30.0f}));
                break;
            }
        }
    }

    private static void landmarks() {
        if (!Rules.hasAttribute(S57obj.Obj.LNDMRK, S57att.Att.CATLMK) && (!Rules.hasAttribute(S57obj.Obj.LNDMRK, S57att.Att.FUNCTN) || Rules.testAttribute(S57obj.Obj.LNDMRK, S57att.Att.FUNCTN, (Object)S57val.FncFNC.FNC_LGHT)) && Rules.hasObject(S57obj.Obj.LIGHTS)) {
            Rules.lights();
        } else if (Renderer.zoom >= 12) {
            switch (Rules.feature.type) {
                case LNDMRK: {
                    if (Rules.testAttribute(S57obj.Obj.LNDMRK, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
                        Renderer.symbol(Beacons.Floodlight);
                    }
                    ArrayList<?> cats = Rules.getAttList(Rules.feature.type, S57att.Att.CATLMK);
                    Symbols.Symbol catSym = Landmarks.Shapes.get(cats.get(0));
                    ArrayList<?> fncs = Rules.getAttList(Rules.feature.type, S57att.Att.FUNCTN);
                    Symbols.Symbol fncSym = Landmarks.Funcs.get(fncs.get(0));
                    if (fncs.get(0) == S57val.FncFNC.FNC_CHCH && cats.get(0) == S57val.CatLMK.LMK_TOWR) {
                        catSym = Landmarks.ChurchTower;
                    }
                    if (cats.get(0) == S57val.CatLMK.LMK_RADR) {
                        fncSym = Landmarks.RadioTV;
                    }
                    Renderer.symbol(catSym);
                    Renderer.symbol(fncSym);
                    break;
                }
                case SILTNK: {
                    if (!Rules.testAttribute(Rules.feature.type, S57att.Att.CATSIL, (Object)S57val.CatSIL.SIL_WTRT)) break;
                    Renderer.symbol(Landmarks.WaterTower);
                    break;
                }
            }
            if (Renderer.zoom >= 15) {
                Renderer.colLetters(Rules.getAttList(Rules.feature.type, S57att.Att.COLOUR));
            }
            Signals.addSignals();
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(60.0, -50.0)));
        }
    }

    private static void lights() {
        boolean ok = false;
        switch (Rules.feature.type) {
            case LNDMRK: 
            case LITMAJ: {
                Renderer.symbol(Beacons.LightMajor);
                if (Renderer.zoom >= 12) {
                    ok = true;
                    break;
                }
                Signals.lights();
                break;
            }
            case LITMIN: 
            case LIGHTS: 
            case PILPNT: {
                if (Renderer.zoom < 14) break;
                if (Rules.testAttribute(S57obj.Obj.LIGHTS, S57att.Att.CATLIT, (Object)S57val.CatLIT.LIT_FLDL)) {
                    Renderer.symbol(Beacons.Floodlight, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getRotateInstance(Math.toRadians(90.0))));
                    Renderer.symbol(Harbours.SignalStation);
                } else {
                    Renderer.symbol(Beacons.LightMinor);
                }
                ok = true;
                break;
            }
        }
        if (ok) {
            S57map.AttMap topmap;
            if (Rules.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                S57map.AttMap topmap2;
                if (Rules.testAttribute(S57obj.Obj.TOPMAR, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
                    Renderer.symbol(Beacons.Floodlight);
                }
                if ((topmap2 = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.TOPMAR)).get(0)).containsKey((Object)S57att.Att.TOPSHP)) {
                    Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap2.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.TOPMAR), Topmarks.LightDelta);
                }
            } else if (Rules.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmap = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.DAYMAR)).get(0)).containsKey((Object)S57att.Att.TOPSHP)) {
                Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.DAYMAR), Topmarks.LightDelta);
            }
            Signals.addSignals();
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(0.0, -50.0)));
        }
    }

    private static void marinas() {
        if (Renderer.zoom >= 16) {
            ArrayList<Symbols.Symbol> symbols = new ArrayList<Symbols.Symbol>();
            ArrayList<S57val.CatSCF> scfs = Rules.getAttList(S57obj.Obj.SMCFAC, S57att.Att.CATSCF);
            for (S57val.CatSCF scf : scfs) {
                Symbols.Symbol sym = Facilities.Cats.get((Object)scf);
                if (sym == null) continue;
                symbols.add(sym);
            }
            Renderer.cluster(symbols);
        }
    }

    private static void moorings() {
        if (Renderer.zoom >= 14) {
            switch ((S57val.CatMOR)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATMOR)) {
                case MOR_DLPN: {
                    if (Rules.feature.geom.prim == S57map.Pflag.AREA) {
                        Renderer.lineVector(new Symbols.LineStyle(Color.black, 4.0f, Symbols.Yland));
                        break;
                    }
                    Renderer.symbol(Harbours.Dolphin);
                    break;
                }
                case MOR_DDPN: {
                    Renderer.symbol(Harbours.DeviationDolphin);
                    break;
                }
                case MOR_BLRD: 
                case MOR_POST: {
                    Renderer.symbol(Harbours.Bollard);
                    break;
                }
                case MOR_BUOY: {
                    if (Renderer.zoom < 16) break;
                    S57val.BoySHP shape = (S57val.BoySHP)Rules.getAttEnum(Rules.feature.type, S57att.Att.BOYSHP);
                    if (shape == S57val.BoySHP.BOY_UNKN) {
                        shape = S57val.BoySHP.BOY_SPHR;
                    }
                    Renderer.symbol(Buoys.Shapes.get((Object)shape), 1.0 / (1.0 + 0.25 * (double)(18 - Renderer.zoom)), Rules.getScheme(Rules.feature.type));
                    Renderer.symbol(Topmarks.TopMooring, 1.0 / (1.0 + 0.25 * (double)(18 - Renderer.zoom)), Topmarks.BuoyDeltas.get((Object)shape));
                    Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(60.0, -50.0)));
                    break;
                }
                default: {
                    Renderer.symbol(Harbours.Post);
                }
            }
            Signals.addSignals();
        }
    }

    private static void notices() {
        if (Renderer.zoom >= 14) {
            S57map.ObjTab objs;
            int n;
            double dx = 0.0;
            double dy = 0.0;
            switch (Rules.feature.type) {
                case BCNCAR: 
                case BCNISD: 
                case BCNLAT: 
                case BCNSAW: 
                case BCNSPP: {
                    if (Rules.testAttribute(S57obj.Obj.TOPMAR, S57att.Att.TOPSHP, (Object)S57val.TopSHP.TOP_BORD) || Rules.testAttribute(S57obj.Obj.DAYMAR, S57att.Att.TOPSHP, (Object)S57val.TopSHP.TOP_BORD)) {
                        dy = -100.0;
                        break;
                    }
                    dy = -45.0;
                    break;
                }
                case NOTMRK: {
                    dy = 0.0;
                    break;
                }
                default: {
                    return;
                }
            }
            S57val.MarSYS sys = S57val.MarSYS.SYS_CEVN;
            S57val.BnkWTW bnk = S57val.BnkWTW.BWW_UNKN;
            S57val.AttVal att = (S57val.AttVal)Rules.feature.atts.get((Object)S57att.Att.MARSYS);
            if (att != null) {
                sys = (S57val.MarSYS)((Object)att.val);
            }
            if ((att = (S57val.AttVal)Rules.feature.atts.get((Object)S57att.Att.BNKWTW)) != null) {
                bnk = (S57val.BnkWTW)((Object)att.val);
            }
            if ((n = (objs = (S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.NOTMRK)).size()) > 5) {
                Renderer.symbol(Notices.Notice, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(dx, dy)));
            } else {
                int i = 0;
                for (S57map.AttMap atts : objs.values()) {
                    if (atts.get((Object)S57att.Att.MARSYS) != null) {
                        sys = (S57val.MarSYS)((Object)((ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.MARSYS))).val).get(0));
                    }
                    if (atts.get((Object)S57att.Att.BNKWTW) != null) {
                        bnk = (S57val.BnkWTW)((Object)((ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.BNKWTW))).val).get(0));
                    }
                    S57val.CatNMK cat = S57val.CatNMK.NMK_UNKN;
                    if (atts.get((Object)S57att.Att.CATNMK) != null) {
                        cat = (S57val.CatNMK)((Object)((ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.CATNMK))).val).get(0));
                    }
                    Symbols.Symbol sym = Notices.getNotice(cat, sys, bnk);
                    Symbols.Scheme sch = Notices.getScheme(sys, bnk);
                    ArrayList add = new ArrayList();
                    if (atts.get((Object)S57att.Att.ADDMRK) != null) {
                        add = (ArrayList)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.ADDMRK))).val;
                    }
                    Symbols.Handle h = Symbols.Handle.CC;
                    double ax = 0.0;
                    double ay = 0.0;
                    switch (i) {
                        case 0: {
                            if (n == 1) break;
                            h = null;
                            break;
                        }
                        case 1: {
                            if (n <= 3) {
                                h = Symbols.Handle.RC;
                                ax = -30.0;
                                ay = dy;
                                break;
                            }
                            h = Symbols.Handle.BR;
                            break;
                        }
                        case 2: {
                            if (n <= 3) {
                                h = Symbols.Handle.LC;
                                break;
                            }
                            h = Symbols.Handle.BL;
                            break;
                        }
                        case 3: {
                            if (n == 4) {
                                h = Symbols.Handle.TC;
                                break;
                            }
                            h = Symbols.Handle.TR;
                            break;
                        }
                        case 4: {
                            h = Symbols.Handle.TL;
                        }
                    }
                    if (h != null) {
                        Renderer.symbol(sym, sch, new Symbols.Delta(h, AffineTransform.getTranslateInstance(dx, dy)));
                        if (!add.isEmpty()) {
                            Renderer.symbol(Notices.NoticeBoard, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(ax, ay - 30.0)));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static void obstructions() {
        if (Renderer.zoom >= 12 && Rules.feature.type == S57obj.Obj.OBSTRN) {
            if (Rules.getAttEnum(Rules.feature.type, S57att.Att.CATOBS) == S57val.CatOBS.OBS_BOOM) {
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 5.0f, new float[]{20.0f, 20.0f}, null));
                if (Renderer.zoom >= 15) {
                    Renderer.lineText("Boom", new Font("Arial", 0, 40), Color.black, -20.0);
                }
            }
            if (Rules.getAttEnum(Rules.feature.type, S57att.Att.CATOBS) == S57val.CatOBS.OBS_FLGD) {
                Renderer.symbol(Areas.Foul, new Symbols.Scheme(Color.black));
                if (Rules.feature.geom.prim == S57map.Pflag.AREA) {
                    Renderer.lineSymbols(Areas.Dash, 1.0, Areas.LineFoul, null, 10, Color.black);
                }
            }
        }
        if (Renderer.zoom >= 14 && Rules.feature.type == S57obj.Obj.UWTROC) {
            switch ((S57val.WatLEV)Rules.getAttEnum(Rules.feature.type, S57att.Att.WATLEV)) {
                case LEV_CVRS: {
                    Renderer.symbol(Areas.RockC);
                    break;
                }
                case LEV_AWSH: {
                    Renderer.symbol(Areas.RockA);
                    break;
                }
                default: {
                    Renderer.symbol(Areas.Rock);
                }
            }
        }
    }

    private static void pipelines() {
        if (Renderer.zoom >= 14 && Rules.feature.geom.length < 20.0) {
            if (Rules.feature.type == S57obj.Obj.PIPSOL) {
                switch ((S57val.CatPIP)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATPIP)) {
                    case PIP_ITAK: 
                    case PIP_OFAL: 
                    case PIP_SEWR: {
                        Renderer.lineSymbols(Areas.Pipeline, 0.33, null, null, 0, Color.black);
                        break;
                    }
                    default: {
                        Renderer.lineSymbols(Areas.Pipeline, 0.33, null, null, 0, Symbols.Msymb);
                        break;
                    }
                }
            } else if (Rules.feature.type == S57obj.Obj.PIPOHD) {
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 8.0f));
                S57map.AttMap atts = Rules.feature.atts;
                double verclr = 0.0;
                if (atts != null) {
                    if (atts.containsKey((Object)S57att.Att.VERCLR)) {
                        verclr = (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCLR))).val;
                    } else {
                        double d = verclr = atts.containsKey((Object)S57att.Att.VERCSA) ? (Double)((S57val.AttVal)atts.get((Object)((Object)S57att.Att.VERCSA))).val : 0.0;
                    }
                    if (verclr > 0.0) {
                        Renderer.labelText(String.valueOf(verclr), new Font("Arial", 0, 50), Color.black, Renderer.LabelStyle.VCLR, Color.black, new Symbols.Delta(Symbols.Handle.TC, AffineTransform.getTranslateInstance(0.0, 25.0)));
                    }
                }
            }
        }
    }

    private static void platforms() {
        ArrayList<?> cats = Rules.getAttList(S57obj.Obj.OFSPLF, S57att.Att.CATOFP);
        if (cats.get(0) == S57val.CatOFP.OFP_FPSO) {
            Renderer.symbol(Buoys.Storage);
        } else {
            Renderer.symbol(Landmarks.Platform);
        }
        if (Rules.testAttribute(Rules.feature.type, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
            Renderer.symbol(Beacons.Floodlight);
        }
        Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(20.0, -50.0)));
        Signals.addSignals();
    }

    private static void points() {
        boolean ok = false;
        switch (Rules.feature.type) {
            case FOGSIG: {
                if (Renderer.zoom < 12) break;
                if (Rules.feature.objs.containsKey((Object)S57obj.Obj.LIGHTS)) {
                    Rules.lights();
                } else {
                    Renderer.symbol(Harbours.Post);
                }
                ok = true;
                break;
            }
            default: {
                if (Renderer.zoom < 14) break;
                if (Rules.testAttribute(Rules.feature.type, S57att.Att.STATUS, (Object)S57val.StsSTS.STS_ILLD)) {
                    Renderer.symbol(Beacons.Floodlight);
                }
                if (Rules.feature.objs.containsKey((Object)S57obj.Obj.LIGHTS)) {
                    Rules.lights();
                } else {
                    Renderer.symbol(Harbours.Post);
                }
                ok = true;
            }
        }
        if (ok) {
            S57map.AttMap topmap;
            if (Rules.feature.objs.containsKey((Object)S57obj.Obj.TOPMAR)) {
                S57map.AttMap topmap2 = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.TOPMAR)).get(0);
                if (topmap2.containsKey((Object)S57att.Att.TOPSHP)) {
                    Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap2.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.TOPMAR), null);
                }
            } else if (Rules.feature.objs.containsKey((Object)S57obj.Obj.DAYMAR) && (topmap = (S57map.AttMap)((S57map.ObjTab)Rules.feature.objs.get((Object)S57obj.Obj.DAYMAR)).get(0)).containsKey((Object)S57att.Att.TOPSHP)) {
                Renderer.symbol(Topmarks.Shapes.get(((ArrayList)((S57val.AttVal)topmap.get((Object)((Object)S57att.Att.TOPSHP))).val).get(0)), Rules.getScheme(S57obj.Obj.DAYMAR), null);
            }
            Signals.addSignals();
        }
    }

    private static void ports() {
        if (Renderer.zoom >= 14) {
            if (Rules.feature.type == S57obj.Obj.CRANES) {
                if ((S57val.CatCRN)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATCRN) == S57val.CatCRN.CRN_CONT) {
                    Renderer.symbol(Harbours.ContainerCrane);
                } else {
                    Renderer.symbol(Harbours.PortCrane);
                }
            } else if (Rules.feature.type == S57obj.Obj.HULKES) {
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 4.0f, null, new Color(0xFFE000)));
                Rules.addName(15, new Font("Arial", 1, 40));
            }
        }
    }

    private static void separation() {
        switch (Rules.feature.type) {
            case TSEZNE: 
            case TSSCRS: 
            case TSSRON: {
                if (Renderer.zoom <= 15) {
                    Renderer.lineVector(new Symbols.LineStyle(Symbols.Mtss));
                } else {
                    Renderer.lineVector(new Symbols.LineStyle(Symbols.Mtss, 20.0f, null, null));
                }
                Rules.addName(10, new Font("Arial", 1, 150), Symbols.Mline);
                break;
            }
            case TSELNE: {
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Mtss, 20.0f, null, null));
                break;
            }
            case TSSLPT: {
                Renderer.lineSymbols(Areas.LaneArrow, 0.5, null, null, 0, Symbols.Mtss);
                break;
            }
            case TSSBND: {
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Mtss, 20.0f, new float[]{40.0f, 40.0f}, null));
                break;
            }
            case ISTZNE: {
                Renderer.lineSymbols(Areas.Restricted, 1.0, null, null, 0, Symbols.Mtss);
                break;
            }
        }
    }

    private static void shoreline() {
        S57val.CatSLC cat = (S57val.CatSLC)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATSLC);
        if ((Renderer.context.ruleset() == ChartContext.RuleSet.ALL || Renderer.context.ruleset() == ChartContext.RuleSet.BASE) && cat != S57val.CatSLC.SLC_SWAY && cat != S57val.CatSLC.SLC_TWAL) {
            if (Renderer.zoom >= 12) {
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f, Symbols.Yland));
            } else {
                Renderer.lineVector(new Symbols.LineStyle(Symbols.Yland));
            }
        }
        if ((Renderer.context.ruleset() == ChartContext.RuleSet.ALL || Renderer.context.ruleset() == ChartContext.RuleSet.SEAMARK) && Renderer.zoom >= 12) {
            switch (cat) {
                case SLC_TWAL: {
                    S57val.WatLEV lev = (S57val.WatLEV)Rules.getAttEnum(Rules.feature.type, S57att.Att.WATLEV);
                    if (lev == S57val.WatLEV.LEV_CVRS) {
                        Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f, new float[]{40.0f, 40.0f}, null));
                        if (Renderer.zoom >= 15) {
                            Renderer.lineText("(covers)", new Font("Arial", 0, 40), Color.black, 80.0);
                        }
                    } else {
                        Renderer.lineVector(new Symbols.LineStyle(Color.black, 10.0f, null, null));
                    }
                    if (Renderer.zoom < 15) break;
                    Renderer.lineText("Training Wall", new Font("Arial", 0, 40), Color.black, -30.0);
                    break;
                }
                case SLC_SWAY: {
                    Renderer.lineVector(new Symbols.LineStyle(Color.black, 2.0f, null, new Color(0xFFE000)));
                    if (Renderer.zoom < 16 || !Rules.feature.objs.containsKey((Object)S57obj.Obj.SMCFAC)) break;
                    ArrayList<Symbols.Symbol> symbols = new ArrayList<Symbols.Symbol>();
                    ArrayList<S57val.CatSCF> scfs = Rules.getAttList(S57obj.Obj.SMCFAC, S57att.Att.CATSCF);
                    for (S57val.CatSCF scf : scfs) {
                        symbols.add(Facilities.Cats.get((Object)scf));
                    }
                    Renderer.cluster(symbols);
                    break;
                }
            }
        }
    }

    private static void stations() {
        if (Renderer.zoom >= 14) {
            String str = "";
            block0 : switch (Rules.feature.type) {
                case SISTAT: {
                    Renderer.symbol(Harbours.SignalStation);
                    str = "SS";
                    ArrayList<?> tcats = Rules.getAttList(S57obj.Obj.SISTAT, S57att.Att.CATSIT);
                    switch ((S57val.CatSIT)((Object)tcats.get(0))) {
                        case SIT_IPT: {
                            str = str + "(INT)";
                            break block0;
                        }
                        case SIT_PRTE: {
                            str = str + "(Traffic)";
                            break block0;
                        }
                        case SIT_PRTC: {
                            str = str + "(Port Control)";
                            break block0;
                        }
                        case SIT_LOCK: {
                            str = str + "(Lock)";
                            break block0;
                        }
                        case SIT_BRDG: {
                            str = str + "(Bridge)";
                            break block0;
                        }
                    }
                    break;
                }
                case SISTAW: {
                    Renderer.symbol(Harbours.SignalStation);
                    str = "SS";
                    str = "SS";
                    ArrayList<?> wcats = Rules.getAttList(S57obj.Obj.SISTAW, S57att.Att.CATSIW);
                    switch ((S57val.CatSIW)((Object)wcats.get(0))) {
                        case SIW_STRM: {
                            str = str + "(Storm)";
                            break block0;
                        }
                        case SIW_WTHR: {
                            str = str + "(Weather)";
                            break block0;
                        }
                        case SIW_ICE: {
                            str = str + "(Ice)";
                            break block0;
                        }
                        case SIW_TIDG: {
                            str = "Tide gauge";
                            break block0;
                        }
                        case SIW_TIDS: {
                            str = "Tide scale";
                            break block0;
                        }
                        case SIW_TIDE: {
                            str = str + "(Tide)";
                            break block0;
                        }
                        case SIW_TSTR: {
                            str = str + "(Stream)";
                            break block0;
                        }
                        case SIW_DNGR: {
                            str = str + "(Danger)";
                            break block0;
                        }
                        case SIW_MILY: {
                            str = str + "(Firing)";
                            break block0;
                        }
                        case SIW_TIME: {
                            str = str + "(Time)";
                            break block0;
                        }
                    }
                    break;
                }
                case RDOSTA: 
                case RTPBCN: {
                    Renderer.symbol(Harbours.SignalStation);
                    Renderer.symbol(Beacons.RadarStation);
                    break;
                }
                case RADRFL: {
                    Renderer.symbol(Topmarks.RadarReflector);
                    break;
                }
                case RADSTA: {
                    Renderer.symbol(Harbours.SignalStation);
                    Renderer.symbol(Beacons.RadarStation);
                    break;
                }
                case PILBOP: {
                    Renderer.symbol(Harbours.Pilot);
                    Rules.addName(15, new Font("Arial", 1, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(70.0, -40.0)));
                    S57val.CatPIL cat = (S57val.CatPIL)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATPIL);
                    if (cat != S57val.CatPIL.PIL_HELI) break;
                    Renderer.labelText("H", new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.LC, AffineTransform.getTranslateInstance(70.0, 0.0)));
                    break;
                }
                case CGUSTA: {
                    Renderer.symbol(Harbours.SignalStation);
                    str = "CG";
                    if (!Rules.feature.objs.containsKey((Object)S57obj.Obj.RSCSTA)) break;
                    Renderer.symbol(Harbours.Rescue, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(130.0, 0.0)));
                    break;
                }
                case RSCSTA: {
                    Renderer.symbol(Harbours.Rescue);
                    break;
                }
            }
            if (Renderer.zoom >= 15 && !str.isEmpty()) {
                Renderer.labelText(str, new Font("Arial", 0, 40), Color.black, new Symbols.Delta(Symbols.Handle.CC, AffineTransform.getTranslateInstance(0.0, -50.0)));
            }
            Signals.addSignals();
        }
    }

    private static void transits() {
        if (Renderer.zoom >= 14) {
            if (Rules.feature.type == S57obj.Obj.RECTRC) {
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 5.0f, null, null));
            } else if (Rules.feature.type == S57obj.Obj.NAVLNE) {
                Renderer.lineVector(new Symbols.LineStyle(Color.black, 5.0f, new float[]{25.0f, 25.0f}, null));
            }
        }
        if (Renderer.zoom >= 15) {
            Double ort;
            String str = "";
            String name = Rules.getName();
            if (name != null) {
                str = str + name + " ";
            }
            if ((ort = (Double)Rules.getAttVal(Rules.feature.type, S57att.Att.ORIENT)) != null && !(str = str + df.format(ort) + "\u00ba").isEmpty()) {
                Renderer.lineText(str, new Font("Arial", 0, 40), Color.black, -20.0);
            }
        }
    }

    private static void virtual() {
        if (Renderer.zoom >= 12) {
            Renderer.symbol(Harbours.SignalStation, new Symbols.Scheme(Symbols.Msymb));
            Renderer.symbol(Beacons.RadarStation, new Symbols.Scheme(Symbols.Msymb));
            ArrayList<S57val.CatVAN> cats = Rules.getAttList(S57obj.Obj.VAATON, S57att.Att.CATVAN);
            for (S57val.CatVAN van : cats) {
                switch (van) {
                    case VAN_NCAR: {
                        Renderer.symbol(Topmarks.TopNorth, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_SCAR: {
                        Renderer.symbol(Topmarks.TopSouth, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_ECAR: {
                        Renderer.symbol(Topmarks.TopEast, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_WCAR: {
                        Renderer.symbol(Topmarks.TopWest, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_PLAT: 
                    case VAN_PCHS: {
                        Renderer.symbol(Topmarks.TopCan, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_SLAT: 
                    case VAN_PCHP: {
                        Renderer.symbol(Topmarks.TopCone, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_IDGR: {
                        Renderer.symbol(Topmarks.TopIsol, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_SAFW: {
                        Renderer.symbol(Topmarks.TopSphere, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_SPPM: {
                        Renderer.symbol(Topmarks.TopX, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                    case VAN_WREK: {
                        Renderer.symbol(Topmarks.TopCross, new Symbols.Scheme(Symbols.Msymb), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -25.0)));
                        break;
                    }
                }
            }
        }
        Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BL, AffineTransform.getTranslateInstance(50.0, 0.0)));
        if (Renderer.zoom >= 15) {
            Renderer.labelText("V-AIS", new Font("Arial", 0, 40), Symbols.Msymb, new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, 70.0)));
        }
    }

    private static void waterways() {
        Renderer.lineVector(new Symbols.LineStyle(Symbols.Bwater, 20.0f, Rules.feature.geom.prim == S57map.Pflag.AREA ? Symbols.Bwater : null));
    }

    private static void wrecks() {
        if (Renderer.zoom >= 14) {
            switch ((S57val.CatWRK)Rules.getAttEnum(Rules.feature.type, S57att.Att.CATWRK)) {
                case WRK_DNGR: 
                case WRK_MSTS: {
                    Renderer.symbol(Areas.WreckD);
                    break;
                }
                case WRK_HULS: {
                    Renderer.symbol(Areas.WreckS);
                    break;
                }
                default: {
                    Renderer.symbol(Areas.WreckND);
                }
            }
            Rules.addName(15, new Font("Arial", 1, 40), new Symbols.Delta(Symbols.Handle.BC, AffineTransform.getTranslateInstance(0.0, -60.0)));
        }
    }

    static {
        bodyColours.put(S57val.ColCOL.COL_UNK, new Color(0, true));
        bodyColours.put(S57val.ColCOL.COL_WHT, new Color(0xFFFFFF));
        bodyColours.put(S57val.ColCOL.COL_BLK, new Color(0));
        bodyColours.put(S57val.ColCOL.COL_RED, new Color(0xD40000));
        bodyColours.put(S57val.ColCOL.COL_GRN, new Color(54272));
        bodyColours.put(S57val.ColCOL.COL_BLU, Color.blue);
        bodyColours.put(S57val.ColCOL.COL_YEL, new Color(16765952));
        bodyColours.put(S57val.ColCOL.COL_GRY, Color.gray);
        bodyColours.put(S57val.ColCOL.COL_BRN, new Color(9127187));
        bodyColours.put(S57val.ColCOL.COL_AMB, new Color(0xFBF00F));
        bodyColours.put(S57val.ColCOL.COL_VIO, new Color(0xEE82EE));
        bodyColours.put(S57val.ColCOL.COL_ORG, Color.orange);
        bodyColours.put(S57val.ColCOL.COL_MAG, new Color(0xF000F0));
        bodyColours.put(S57val.ColCOL.COL_PNK, Color.pink);
        colourLetters = new EnumMap(S57val.ColCOL.class);
        colourLetters.put(S57val.ColCOL.COL_UNK, "");
        colourLetters.put(S57val.ColCOL.COL_WHT, "W");
        colourLetters.put(S57val.ColCOL.COL_BLK, "B");
        colourLetters.put(S57val.ColCOL.COL_RED, "R");
        colourLetters.put(S57val.ColCOL.COL_GRN, "G");
        colourLetters.put(S57val.ColCOL.COL_BLU, "Bu");
        colourLetters.put(S57val.ColCOL.COL_YEL, "Y");
        colourLetters.put(S57val.ColCOL.COL_GRY, "Gr");
        colourLetters.put(S57val.ColCOL.COL_BRN, "Bn");
        colourLetters.put(S57val.ColCOL.COL_AMB, "Am");
        colourLetters.put(S57val.ColCOL.COL_VIO, "Vi");
        colourLetters.put(S57val.ColCOL.COL_ORG, "Or");
        colourLetters.put(S57val.ColCOL.COL_MAG, "Mg");
        colourLetters.put(S57val.ColCOL.COL_PNK, "Pk");
        pattMap = new EnumMap(S57val.ColPAT.class);
        pattMap.put(S57val.ColPAT.PAT_UNKN, Symbols.Patt.Z);
        pattMap.put(S57val.ColPAT.PAT_HORI, Symbols.Patt.H);
        pattMap.put(S57val.ColPAT.PAT_VERT, Symbols.Patt.V);
        pattMap.put(S57val.ColPAT.PAT_DIAG, Symbols.Patt.D);
        pattMap.put(S57val.ColPAT.PAT_BRDR, Symbols.Patt.B);
        pattMap.put(S57val.ColPAT.PAT_SQUR, Symbols.Patt.S);
        pattMap.put(S57val.ColPAT.PAT_CROS, Symbols.Patt.C);
        pattMap.put(S57val.ColPAT.PAT_SALT, Symbols.Patt.X);
        pattMap.put(S57val.ColPAT.PAT_STRP, Symbols.Patt.H);
    }
}

