/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.javafx.io.audio;

import com.sun.javafx.application.PlatformImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.openstreetmap.josm.io.audio.AudioException;
import org.openstreetmap.josm.io.audio.AudioListener;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.io.audio.SoundPlayer;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.ListenerList;

public class JavaFxMediaPlayer
implements SoundPlayer {
    private final ListenerList<AudioListener> listeners = ListenerList.create();
    private MediaPlayer mediaPlayer;

    JavaFxMediaPlayer() {
        try {
            JavaFxMediaPlayer.initFxPlatform();
        }
        catch (InterruptedException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
    }

    public static void initFxPlatform() throws InterruptedException {
        CountDownLatch startupLatch = new CountDownLatch(1);
        PlatformImpl.startup(startupLatch::countDown);
        startupLatch.await();
    }

    public synchronized void play(AudioPlayer.Execute command, AudioPlayer.State stateChange, URL playingUrl) throws AudioException, IOException {
        try {
            Duration seekTime;
            URL url = command.url();
            if (playingUrl != url) {
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.stop();
                }
                if ("file".equals(url.getProtocol()) && !new File(url.toURI()).exists()) {
                    throw new FileNotFoundException(url.toString());
                }
                this.mediaPlayer = new MediaPlayer(new Media(url.toString()));
                this.mediaPlayer.setOnPlaying(() -> this.listeners.fireEvent(l -> l.playing(url)));
            }
            this.mediaPlayer.setRate(command.speed());
            if (MediaPlayer.Status.PLAYING == this.mediaPlayer.getStatus() && !(seekTime = Duration.seconds((double)command.offset())).equals((Object)this.mediaPlayer.getCurrentTime())) {
                this.mediaPlayer.seek(seekTime);
            }
            this.mediaPlayer.play();
        }
        catch (URISyntaxException | MediaException e) {
            throw new AudioException(e);
        }
    }

    public synchronized void pause(AudioPlayer.Execute command, AudioPlayer.State stateChange, URL playingUrl) throws AudioException, IOException {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.pause();
            }
            catch (MediaException e) {
                throw new AudioException((Throwable)e);
            }
        }
    }

    public boolean playing(AudioPlayer.Execute command) throws AudioException, IOException, InterruptedException {
        return false;
    }

    public synchronized double position() {
        return this.mediaPlayer != null ? this.mediaPlayer.getCurrentTime().toSeconds() : -1.0;
    }

    public synchronized double speed() {
        return this.mediaPlayer != null ? this.mediaPlayer.getCurrentRate() : -1.0;
    }

    public void addAudioListener(AudioListener listener) {
        this.listeners.addWeakListener((Object)listener);
    }
}

