/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.javafx;

import java.awt.Component;
import java.util.Collections;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.javafx.io.audio.JavaFxMediaPlayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;

public class JavaFxPlugin
extends Plugin {
    protected JavaFxPlugin(PluginInformation info) {
        super(info);
        if (!this.isJavaFx()) {
            Logging.error((String)"JavaFX is not available");
            StringBuilder message = new StringBuilder(I18n.tr((String)"JavaFX is not available.", (Object[])new Object[0]));
            PlatformManager.getPlatform();
            if (PlatformManager.isPlatformUnixoid()) {
                message.append(I18n.tr((String)" Please install OpenJFX through your package manager.", (Object[])new Object[0]));
            } else {
                message.append(I18n.tr((String)" Please update to Java 11+.", (Object[])new Object[0]));
            }
            if (PluginHandler.confirmDisablePlugin((Component)MainApplication.getMainFrame(), (String)message.toString(), (String)info.getName())) {
                PluginHandler.removePlugins(Collections.singletonList(info));
            }
            return;
        }
        AudioPlayer.setSoundPlayerClass(JavaFxMediaPlayer.class);
    }

    private boolean isJavaFx() {
        try {
            return Class.forName("javafx.scene.Node") != null && Class.forName("javafx.scene.media.Media") != null;
        }
        catch (ClassNotFoundException e) {
            Logging.trace((Throwable)e);
            return false;
        }
    }
}

