/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.rasterfilters.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FilterInfo;
import org.openstreetmap.josm.plugins.rasterfilters.preferences.FiltersDownloader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class RasterFiltersPreferences
implements SubPreferenceSetting {
    private AbstractTableModel model;
    private JPanel holder;

    public void addGui(PreferenceTabbedPane gui) {
        this.model = new FiltersTableModel();
        if (this.holder == null) {
            this.holder = new JPanel(new GridBagLayout());
            this.holder.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.model.addTableModelListener(e -> {
                int row = e.getFirstRow();
                int col = e.getColumn();
                TableModel tmodel = (TableModel)e.getSource();
                ((FilterInfo)((FiltersTableModel)tmodel).filtersInfoList.get(row)).setNeedToDownload((Boolean)tmodel.getValueAt(row, col));
            });
            JTable table = new JTable(this.model);
            table.getTableHeader().setReorderingAllowed(false);
            table.getColumnModel().getColumn(3).setMaxWidth(20);
            JScrollPane pane = new JScrollPane(table);
            this.holder.add((Component)pane, GBC.eol().fill(1));
            JButton download = new JButton(I18n.tr((String)"Download", (Object[])new Object[0]));
            download.addActionListener(new FiltersDownloader());
            this.holder.add((Component)download, GBC.eol().anchor(13));
        }
        this.getTabPreferenceSetting(gui).addSubTab((SubPreferenceSetting)this, I18n.tr((String)"Image Filters", (Object[])new Object[0]), (Component)this.holder);
    }

    public boolean ok() {
        for (FilterInfo temp : ((FiltersTableModel)this.model).getFiltersInfoList()) {
            Config.getPref().putBoolean("rasterfilters." + temp.getMeta().getString("name"), temp.isNeedToDownload());
        }
        return false;
    }

    public boolean isExpert() {
        return false;
    }

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getImageryPreference();
    }

    private static class FiltersTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{I18n.tr((String)"Filter Name", (Object[])new Object[0]), I18n.tr((String)"Author", (Object[])new Object[0]), I18n.tr((String)"Description", (Object[])new Object[0]), ""};
        private final Class<?>[] columnClasses = new Class[]{String.class, String.class, String.class, Boolean.class};
        private final List<FilterInfo> filtersInfoList = FiltersDownloader.downloadFiltersInfoList();
        private final Object[][] data = new Object[this.filtersInfoList.size()][4];

        FiltersTableModel() {
            for (int i = 0; i < this.filtersInfoList.size(); ++i) {
                this.data[i][0] = this.filtersInfoList.get(i).getName();
                this.data[i][1] = this.filtersInfoList.get(i).getOwner();
                this.data[i][2] = this.filtersInfoList.get(i).getDescription();
                this.data[i][3] = this.filtersInfoList.get(i).isNeedToDownload();
            }
        }

        @Override
        public int getRowCount() {
            return this.filtersInfoList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.filtersInfoList.get(rowIndex).getName();
                }
                case 1: {
                    return this.filtersInfoList.get(rowIndex).getOwner();
                }
                case 2: {
                    return this.filtersInfoList.get(rowIndex).getDescription();
                }
                case 3: {
                    return this.filtersInfoList.get(rowIndex).isNeedToDownload();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.columnClasses[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 3) {
                this.filtersInfoList.get(row).setNeedToDownload((Boolean)value);
                this.fireTableCellUpdated(row, col);
            }
        }

        public List<FilterInfo> getFiltersInfoList() {
            return this.filtersInfoList;
        }
    }
}

