/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RestyAuthenticator
extends Authenticator {
    List<Site> sites = Collections.synchronizedList(new ArrayList());
    Map<String, Realm> realms = new ConcurrentHashMap<String, Realm>();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String realm;
        Realm r;
        URL requestURL = this.getRequestingURL();
        if (requestURL != null) {
            try {
                String uri = requestURL.toURI().normalize().toString();
                Site site = this.findBestMatch(uri);
                if (site != null) {
                    return new PasswordAuthentication(site.login, site.pwd);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((r = this.findRealm(realm = this.getRequestingPrompt())) != null) {
            return new PasswordAuthentication(r.login, r.pwd);
        }
        return null;
    }

    public void addSite(URI aRootUrl, String login, char[] pwd) {
        String rootUri = aRootUrl.normalize().toString();
        boolean replaced = false;
        for (Site site : this.sites) {
            if (!site.root.equals(rootUri)) continue;
            site.login = login;
            site.pwd = pwd;
            replaced = true;
            break;
        }
        if (!replaced) {
            Site s = new Site();
            s.root = rootUri;
            s.login = login;
            s.pwd = pwd;
            this.sites.add(s);
        }
    }

    private Site findBestMatch(String uri) {
        int max = 0;
        Site bestSite = null;
        for (Site s : this.sites) {
            int prefixLength = s.match(uri);
            if (prefixLength <= max) continue;
            max = prefixLength;
            bestSite = s;
        }
        return bestSite;
    }

    public void addRealm(String aRealm, String aLogin, char[] charArray) {
        Realm r = new Realm(aLogin, charArray);
        this.realms.put(aRealm, r);
    }

    Realm findRealm(String aRealm) {
        return this.realms.get(aRealm);
    }

    static class Site {
        String root;
        String login;
        char[] pwd;

        Site() {
        }

        public int match(String uri) {
            if (uri.startsWith(this.root)) {
                return this.root.length();
            }
            return 0;
        }
    }

    static class Realm {
        String login;
        char[] pwd;

        public Realm(String aLogin, char[] charArray) {
            this.login = aLogin;
            this.pwd = charArray;
        }
    }
}

