/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;

public class InterpolateImages
extends JosmAction
implements LayerManager.LayerChangeListener,
ImageData.ImageDataUpdateListener {
    public InterpolateImages() {
        super(I18n.tr((String)"Interpolate position between the 2 images", (Object[])new Object[0]), null, I18n.tr((String)"Interpolate images position between the 2 selected images", (Object[])new Object[0]), null, false, false);
        this.installAdapters();
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent evt) {
        if (!InterpolateImages.getLayerWithTwoSelectedImages().isPresent()) {
            return;
        }
        GeoImageLayer layer = InterpolateImages.getLayerWithTwoSelectedImages().get();
        ImageData data = layer.getImageData();
        this.interpolate(data, MainApplication.getMap().mapView);
    }

    public void interpolate(ImageData data, MapView mapView) {
        List images = data.getImages();
        List selectedImages = data.getSelectedImages();
        Collections.sort(selectedImages);
        ImageEntry firstPhoto = (ImageEntry)selectedImages.get(0);
        ImageEntry lastPhoto = (ImageEntry)selectedImages.get(1);
        Point2D firstPos = mapView.getPoint2D((LatLon)firstPhoto.getPos());
        Point2D lastPos = mapView.getPoint2D((LatLon)lastPhoto.getPos());
        int nbSegments = images.indexOf(lastPhoto) - images.indexOf(firstPhoto);
        double firstPosX = firstPos.getX();
        double firstPosY = firstPos.getY();
        double offsetX = (lastPos.getX() - firstPosX) / (double)nbSegments;
        double offsetY = (lastPos.getY() - firstPosY) / (double)nbSegments;
        int firstIndex = images.indexOf(firstPhoto);
        for (int idx = 1; idx < nbSegments; ++idx) {
            ImageEntry image = (ImageEntry)images.get(firstIndex + idx);
            LatLon newPos = mapView.getLatLon(firstPosX + offsetX * (double)idx, firstPosY + offsetY * (double)idx);
            image.setPos(newPos);
            image.flagNewGpsData();
        }
        data.notifyImageUpdate();
    }

    protected void installAdapters() {
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    protected void updateEnabledState() {
        this.setEnabled(InterpolateImages.getLayerWithTwoSelectedImages().isPresent());
    }

    private static Optional<GeoImageLayer> getLayerWithTwoSelectedImages() {
        List list = MainApplication.getLayerManager().getLayersOfType(GeoImageLayer.class);
        return list.stream().filter(l -> l.getImageData().getSelectedImages().size() == 2).findFirst();
    }

    public void layerAdded(LayerManager.LayerAddEvent evt) {
        Layer layer = evt.getAddedLayer();
        if (layer instanceof GeoImageLayer) {
            ((GeoImageLayer)layer).getImageData().addImageDataUpdateListener((ImageData.ImageDataUpdateListener)this);
        }
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent evt) {
        Layer layer = evt.getRemovedLayer();
        if (layer instanceof GeoImageLayer) {
            ((GeoImageLayer)layer).getImageData().removeImageDataUpdateListener((ImageData.ImageDataUpdateListener)this);
        }
        this.updateEnabledState();
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent evt) {
    }

    public void imageDataUpdated(ImageData data) {
    }

    public void selectedImageChanged(ImageData data) {
        this.updateEnabledState();
    }
}

