/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeAddrPointsAction
extends JosmAction {
    public MergeAddrPointsAction() {
        super(I18n.tr((String)"Merge address points", (Object[])new Object[0]), "mergeaddr", I18n.tr((String)"Move tags from address nodes inside buildings to building ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:mergeaddrpoints", (String)I18n.tr((String)"Data: {0}", (Object[])new Object[]{I18n.tr((String)"Merge address points", (Object[])new Object[0])}), (int)65535, (int)5000), true);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (!this.isEnabled()) {
            return;
        }
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        if (selection.isEmpty()) {
            new Notification(I18n.tr((String)"Select both address nodes and building ways to merge", (Object[])new Object[0])).setIcon(1).show();
            return;
        }
        LinkedList<Node> addrNodes = new LinkedList<Node>();
        LinkedList<Way> buildings = new LinkedList<Way>();
        block0: for (OsmPrimitive p2 : selection) {
            if (p2.getType() == OsmPrimitiveType.NODE) {
                boolean refsOK = true;
                for (OsmPrimitive r : p2.getReferrers()) {
                    if (r.getType() != OsmPrimitiveType.WAY) continue;
                    refsOK = false;
                    break;
                }
                if (!refsOK) continue;
                for (Object key : p2.getKeys().keySet()) {
                    if (!((String)key).startsWith("addr:")) continue;
                    addrNodes.add((Node)p2);
                    continue block0;
                }
                continue;
            }
            if (p2.getType() != OsmPrimitiveType.WAY || !p2.getKeys().containsKey((Object)"building")) continue;
            buildings.add((Way)p2);
        }
        if (addrNodes.isEmpty()) {
            new Notification(I18n.tr((String)"No address nodes found in the selection", (Object[])new Object[0])).setIcon(0).show();
            return;
        }
        if (buildings.isEmpty()) {
            new Notification(I18n.tr((String)"No building ways found in the selection", (Object[])new Object[0])).setIcon(0).show();
            return;
        }
        HashMap<Node, Way> nodeToWayMap = new HashMap<Node, Way>();
        HashSet<Way> overlappingWays = new HashSet<Way>();
        for (Way w : buildings) {
            for (Node n : addrNodes) {
                Way old;
                if (!Geometry.nodeInsidePolygon((INode)n, (List)w.getNodes()) || (old = nodeToWayMap.put(n, w)) == null) continue;
                overlappingWays.add(w);
                overlappingWays.add(old);
            }
        }
        buildings.removeAll(overlappingWays);
        LinkedList<Object> cmds = new LinkedList<Object>();
        int multi = 0;
        int conflicts = 0;
        ArrayList<Pair> replaced = new ArrayList<Pair>();
        HashSet modifiedRelations = new HashSet();
        for (Way w : buildings) {
            Node mergeNode = null;
            int oldMulti = multi;
            for (Node n : addrNodes) {
                if (!Geometry.nodeInsidePolygon((INode)n, (List)w.getNodes())) continue;
                if (mergeNode != null) {
                    ++multi;
                    break;
                }
                mergeNode = n;
            }
            if (oldMulti != multi || mergeNode == null) continue;
            boolean hasConflicts = false;
            HashMap<String, String> tags = new HashMap<String, String>();
            for (Map.Entry entry : mergeNode.getKeys().entrySet()) {
                String oldValue;
                String newValue = (String)entry.getValue();
                if (newValue == null || newValue.equals(oldValue = w.getKeys().get(entry.getKey()))) continue;
                if (oldValue == null) {
                    tags.put((String)entry.getKey(), newValue);
                    continue;
                }
                hasConflicts = true;
            }
            if (hasConflicts) {
                ++conflicts;
            }
            if (!tags.isEmpty()) {
                cmds.add(new ChangePropertyCommand(Collections.singleton(w), tags));
            }
            if (hasConflicts) continue;
            replaced.add(Pair.create((Object)mergeNode, (Object)w));
            modifiedRelations.addAll(mergeNode.referrers(Relation.class).collect(Collectors.toList()));
        }
        for (Relation r : modifiedRelations) {
            ArrayList<RelationMember> members = new ArrayList<RelationMember>(r.getMembers());
            boolean modified = false;
            for (Pair repl : replaced) {
                for (int i = 0; i < members.size(); ++i) {
                    RelationMember member = (RelationMember)members.get(i);
                    if (!((Node)repl.a).equals((Object)member.getMember())) continue;
                    members.set(i, new RelationMember(member.getRole(), (OsmPrimitive)repl.b));
                    modified = true;
                }
            }
            if (!modified) continue;
            cmds.add(new ChangeMembersCommand(r, members));
        }
        if (!replaced.isEmpty()) {
            cmds.add(new DeleteCommand((Collection)replaced.stream().map(p -> (Node)p.a).collect(Collectors.toList())));
        }
        if (multi != 0) {
            new Notification(I18n.trn((String)"There is {0} building with multiple address nodes inside", (String)"There are {0} buildings with multiple address nodes inside", (long)multi, (Object[])new Object[]{multi})).setIcon(2).show();
        }
        if (conflicts != 0) {
            new Notification(I18n.trn((String)"There is {0} building with address conflicts", (String)"There are {0} buildings with address conflicts", (long)conflicts, (Object[])new Object[]{conflicts})).setIcon(2).show();
        }
        if (!overlappingWays.isEmpty()) {
            new Notification(I18n.tr((String)"There are {0} buildings covering the same address node", (Object[])new Object[]{overlappingWays.size()})).setIcon(2).show();
        }
        if (cmds.isEmpty() && multi == 0 && conflicts == 0 && overlappingWays.isEmpty()) {
            new Notification(I18n.tr((String)"No address nodes inside buildings found", (Object[])new Object[0])).setIcon(1).show();
        }
        if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand("Merge addresses", cmds));
        }
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }
}

