/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.alignways.AlignWaysPlugin;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSegmentMgr;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelAlgnState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelBothState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelNoneState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysSelRefState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysState;
import org.openstreetmap.josm.plugins.alignways.AlignWaysTipsPanel;
import org.openstreetmap.josm.plugins.alignways.AlignWaysWhatsNewPanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AlignWaysMode
extends MapMode
implements DataSetListener {
    private static final long serialVersionUID = -1090955708412011141L;
    private final AlignWaysState noneSelected = new AlignWaysSelNoneState();
    private final AlignWaysState referenceSelected = new AlignWaysSelRefState();
    private final AlignWaysState aligneeSelected = new AlignWaysSelAlgnState();
    private final AlignWaysState bothSelected = new AlignWaysSelBothState();
    private AlignWaysState currentState;
    private AlignWaysSegmentMgr awSegs;
    boolean tipShown = false;

    public AlignWaysMode(String name, String desc) {
        super(I18n.tr((String)name, (Object[])new Object[0]), "alignways.png", I18n.tr((String)desc, (Object[])new Object[0]), Shortcut.registerShortcut((String)"mapmode:alignways", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Align Ways", (Object[])new Object[0])}), (int)78, (int)5005), Cursor.getPredefinedCursor(0));
    }

    public void enterMode() {
        int majorVer;
        boolean showTips;
        super.enterMode();
        AlignWaysPlugin.getAwDialog().activate(true);
        IconToggleButton optBtn = AlignWaysPlugin.getOptBtn();
        if (!optBtn.isSelected()) {
            optBtn.doClick();
        }
        if ((showTips = Boolean.parseBoolean(Config.getPref().get("alignways.showtips", "true"))) && !this.tipShown) {
            this.showTips();
        }
        if ((majorVer = Integer.parseInt(Config.getPref().get("alignways.majorver", "-1"))) != 2) {
            this.showWhatsNew();
        }
        this.awSegs = AlignWaysSegmentMgr.getInstance(MainApplication.getMap().mapView);
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.addDataSetListener((DataSetListener)this);
        }
        this.setCurrentState(this.noneSelected);
    }

    public void exitMode() {
        super.exitMode();
        AlignWaysPlugin.getAwDialog().activate(false);
        IconToggleButton optBtn = AlignWaysPlugin.getOptBtn();
        if (optBtn.isSelected()) {
            optBtn.doClick();
        }
        this.setCurrentState(this.noneSelected);
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.removeDataSetListener((DataSetListener)this);
        }
        AlignWaysPlugin.getAwAction().setEnabled(false);
    }

    public void mouseClicked(MouseEvent e) {
        boolean altPressed;
        boolean ctrlPressed = (e.getModifiers() & 2) != 0;
        boolean bl = altPressed = (e.getModifiers() & 0x28) != 0;
        if (e.getButton() == 1) {
            if (altPressed) {
                this.currentState.altLClick(this);
            } else {
                Point clickedPoint = new Point(e.getX(), e.getY());
                if (!ctrlPressed) {
                    if (this.awSegs.algnUpdate(clickedPoint)) {
                        this.currentState.leftClick(this);
                    }
                } else if (this.awSegs.refUpdate(clickedPoint)) {
                    this.currentState.ctrlLClick(this);
                }
            }
        }
        MainApplication.getMap().mapView.repaint();
    }

    public void setCurrentState(AlignWaysSegmentMgr mgr) {
        boolean refSelected;
        boolean algnSelected = mgr.getAlgnSeg() != null;
        boolean bl = refSelected = mgr.getRefSeg() != null;
        if (algnSelected && refSelected) {
            this.setCurrentState(this.getBothSelected());
        } else if (algnSelected) {
            this.setCurrentState(this.getAligneeSelected());
        } else if (refSelected) {
            this.setCurrentState(this.getReferenceSelected());
        } else {
            this.setCurrentState(this.getNoneSelected());
        }
    }

    public void setCurrentState(AlignWaysState currentState) {
        this.currentState = currentState;
        currentState.setHelpText();
        AlignWaysPlugin.getAwAction().setEnabled(currentState == this.bothSelected);
        if (currentState == this.noneSelected) {
            this.awSegs.cleanupWays();
            DataSet ds = this.getLayerManager().getEditDataSet();
            if (ds != null) {
                ds.clearSelection();
            }
        }
    }

    public AlignWaysState getNoneSelected() {
        return this.noneSelected;
    }

    public AlignWaysState getReferenceSelected() {
        return this.referenceSelected;
    }

    public AlignWaysState getAligneeSelected() {
        return this.aligneeSelected;
    }

    public AlignWaysState getBothSelected() {
        return this.bothSelected;
    }

    private void showTips() {
        AlignWaysTipsPanel atp = new AlignWaysTipsPanel();
        Object[] okButton = new Object[]{I18n.tr((String)"I''m ready!", (Object[])new Object[0])};
        JOptionPane tipPane = new JOptionPane(atp, -1, -1, null, okButton, okButton[0]);
        tipPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 30, 10));
        JDialog tipDialog = tipPane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"AlignWays Tips", (Object[])new Object[0]));
        tipDialog.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/alignways.png")).getImage());
        tipDialog.setResizable(true);
        tipDialog.setVisible(true);
        this.tipShown = true;
        tipDialog.dispose();
        Config.getPref().putBoolean("alignways.showtips", !atp.isChkBoxSelected());
    }

    private void showWhatsNew() {
        AlignWaysWhatsNewPanel awnp = new AlignWaysWhatsNewPanel();
        JOptionPane wnPane = new JOptionPane(awnp, -1, -1, null);
        wnPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JDialog wnDialog = wnPane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"AlignWays: What''s New...", (Object[])new Object[0]));
        wnDialog.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/alignways.png")).getImage());
        wnDialog.setResizable(true);
        wnDialog.setVisible(true);
        wnDialog.dispose();
        Config.getPref().put("alignways.majorver", Integer.toString(2));
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
        this.awSegs = AlignWaysSegmentMgr.getInstance(MainApplication.getMap().mapView);
        if (this.awSegs.primitivesRemoved(event.getPrimitives())) {
            this.setCurrentState(this.awSegs);
        }
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void dataChanged(DataChangedEvent event) {
    }
}

