/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pbf.io;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import crosby.binary.file.FileBlockPosition;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.ImportCancelException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class PbfReader
extends AbstractReader {
    private PbfParser parser = new PbfParser();

    public static DataSet parseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        ProgressMonitor monitor = progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor;
        CheckParameterUtil.ensureParameterNotNull((Object)source, (String)"source");
        return new PbfReader().doParseDataSet(source, monitor);
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor monitor) throws IllegalDataException {
        ProgressMonitor.CancelListener cancelListener = () -> {
            this.cancel = true;
            monitor.indeterminateSubTask(I18n.tr((String)"Canceled: Waiting for reader to react", (Object[])new Object[0]));
        };
        monitor.addCancelListener(cancelListener);
        try {
            monitor.beginTask(I18n.tr((String)"Prepare OSM data...", (Object[])new Object[0]), 3);
            monitor.indeterminateSubTask(I18n.tr((String)"Reading OSM data...", (Object[])new Object[0]));
            this.parse(source);
            monitor.worked(1);
            if (this.cancel) {
                throw new ParsingCancelException(I18n.tr((String)"Import was canceled", (Object[])new Object[0]));
            }
            monitor.indeterminateSubTask(I18n.tr((String)"Preparing data set...", (Object[])new Object[0]));
            this.prepareDataSet();
            if (this.cancel) {
                throw new ParsingCancelException(I18n.tr((String)"Import was canceled", (Object[])new Object[0]));
            }
            monitor.worked(1);
            DataSet dataSet = this.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalDataException((Throwable)e);
        }
        finally {
            monitor.finishTask();
            monitor.removeCancelListener(cancelListener);
        }
    }

    public void parse(InputStream source) throws IOException, IllegalDataException {
        new BlockInputStream(source, this.parser).process();
        if (this.parser.exception != null) {
            throw this.parser.exception;
        }
    }

    private static final class ParsingCancelException
    extends Exception
    implements ImportCancelException {
        private static final long serialVersionUID = 1L;

        ParsingCancelException(String msg) {
            super(msg);
        }
    }

    protected class PbfParser
    extends BinaryParser {
        private IllegalDataException exception;
        private boolean discourageUpload;

        protected PbfParser() {
        }

        private double parseRawDegrees(long raw) {
            return (double)raw * 1.0E-9;
        }

        @Override
        protected void parse(Osmformat.HeaderBlock header) {
            Iterator<String> iterator = header.getRequiredFeaturesList().iterator();
            block8: while (iterator.hasNext()) {
                String requiredFeature;
                switch (requiredFeature = iterator.next()) {
                    case "OsmSchema-V0.6": {
                        PbfReader.this.ds.setVersion("0.6");
                        continue block8;
                    }
                    case "DenseNodes": {
                        continue block8;
                    }
                }
                throw new UnsupportedOperationException("Unsupported feature: " + requiredFeature);
            }
            if (header.hasBbox()) {
                double maxlon;
                double maxlat;
                double minlon;
                Osmformat.HeaderBBox bbox = header.getBbox();
                double minlat = this.parseRawDegrees(bbox.getBottom());
                Bounds b = new Bounds(minlat, minlon = this.parseRawDegrees(bbox.getLeft()), maxlat = this.parseRawDegrees(bbox.getTop()), maxlon = this.parseRawDegrees(bbox.getRight()));
                if (!b.isCollapsed() && this.areCoordinatesValid(minlat, minlon, maxlat, maxlon)) {
                    PbfReader.this.ds.addDataSource(new DataSource(b, header.getSource()));
                } else {
                    Logging.error((String)("Invalid Bounds: " + b));
                }
            }
        }

        private boolean areCoordinatesValid(double minlat, double minlon, double maxlat, double maxlon) {
            return LatLon.isValidLat((double)minlat) && LatLon.isValidLat((double)maxlat) && LatLon.isValidLon((double)minlon) && LatLon.isValidLon((double)maxlon);
        }

        private void setMetadata(PrimitiveData osm, Osmformat.Info info) throws IllegalDataException {
            if (info.hasChangeset()) {
                this.checkChangesetId(info.getChangeset());
                osm.setChangesetId((int)info.getChangeset());
            }
            if (info.hasUid() && info.hasUserSid()) {
                osm.setUser(User.createOsmUser((long)info.getUid(), (String)this.getStringById(info.getUserSid())));
            }
            if (info.hasTimestamp()) {
                this.checkTimestamp(info.getTimestamp());
                osm.setTimestamp(this.getDate(info));
            }
        }

        @Override
        public boolean skipBlock(FileBlockPosition block) {
            return this.exception != null || PbfReader.this.cancel;
        }

        protected void checkCoordinates(LatLon coor) throws IllegalDataException {
            if (!coor.isValid()) {
                throw new IllegalDataException(I18n.tr((String)"Invalid coordinates: {0}", (Object[])new Object[]{coor}));
            }
        }

        protected void checkChangesetId(long id) throws IllegalDataException {
            if (id > Integer.MAX_VALUE) {
                throw new IllegalDataException(I18n.tr((String)"Invalid changeset id: {0}", (Object[])new Object[]{id}));
            }
        }

        protected void checkTimestamp(long timestamp) throws IllegalDataException {
            if (timestamp < 0L) {
                throw new IllegalDataException(I18n.tr((String)"Invalid timestamp: {0}", (Object[])new Object[]{timestamp}));
            }
        }

        @Override
        protected void parseDense(Osmformat.DenseNodes nodes) {
            if (!nodes.hasDenseinfo()) {
                this.discourageUpload = true;
            }
            if (this.exception == null) {
                try {
                    int keyIndex = 0;
                    long nodeId = 0L;
                    long nodeLat = 0L;
                    long nodeLon = 0L;
                    long changesetId = 0L;
                    int uid = 0;
                    int suid = 0;
                    long timestamp = 0L;
                    for (int i = 0; i < nodes.getIdCount(); ++i) {
                        int keyId;
                        NodeData nd = new NodeData(nodeId += nodes.getId(i));
                        nd.setVersion(nodes.hasDenseinfo() ? nodes.getDenseinfo().getVersion(i) : 1);
                        nd.setCoor(new LatLon(this.parseLat(nodeLat += nodes.getLat(i)), this.parseLon(nodeLon += nodes.getLon(i))).getRoundedToOsmPrecision());
                        this.checkCoordinates(nd.getCoor());
                        if (nodes.hasDenseinfo()) {
                            Osmformat.DenseInfo info = nodes.getDenseinfo();
                            if (info.getChangesetCount() > i) {
                                this.checkChangesetId(changesetId += info.getChangeset(i));
                                nd.setChangesetId((int)changesetId);
                            }
                            if (info.getUidCount() > i && info.getUserSidCount() > i) {
                                nd.setUser(User.createOsmUser((long)(uid += info.getUid(i)), (String)this.getStringById(suid += info.getUserSid(i))));
                            }
                            if (info.getTimestampCount() > i) {
                                this.checkTimestamp(timestamp += info.getTimestamp(i));
                                nd.setTimestamp(new Date((long)this.date_granularity * timestamp));
                            }
                        }
                        HashMap<String, String> keys = new HashMap<String, String>();
                        while (keyIndex < nodes.getKeysValsCount() && (keyId = nodes.getKeysVals(keyIndex++)) != 0) {
                            if (keyIndex < nodes.getKeysValsCount()) {
                                keys.put(this.getStringById(keyId), this.getStringById(nodes.getKeysVals(keyIndex++)));
                                continue;
                            }
                            throw new IllegalDataException(I18n.tr((String)"Invalid DenseNodes key/values table", (Object[])new Object[0]));
                        }
                        nd.setKeys(keys);
                        PbfReader.this.buildPrimitive((PrimitiveData)nd);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        protected void parseNodes(List<Osmformat.Node> osmNodes) {
            if (this.exception == null) {
                try {
                    for (Osmformat.Node n : osmNodes) {
                        Osmformat.Info info = n.getInfo();
                        if (!info.hasVersion()) {
                            this.discourageUpload = true;
                        }
                        NodeData nd = new NodeData(n.getId());
                        nd.setVersion(info.hasVersion() ? info.getVersion() : 1);
                        nd.setCoor(new LatLon(this.parseLat(n.getLat()), this.parseLon(n.getLon())).getRoundedToOsmPrecision());
                        this.checkCoordinates(nd.getCoor());
                        this.setMetadata((PrimitiveData)nd, info);
                        HashMap<String, String> keys = new HashMap<String, String>();
                        for (int i = 0; i < n.getKeysCount(); ++i) {
                            keys.put(this.getStringById(n.getKeys(i)), this.getStringById(n.getVals(i)));
                        }
                        nd.setKeys(keys);
                        PbfReader.this.buildPrimitive((PrimitiveData)nd);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        protected void parseWays(List<Osmformat.Way> osmWays) {
            if (this.exception == null) {
                try {
                    for (Osmformat.Way w : osmWays) {
                        Osmformat.Info info = w.getInfo();
                        if (!info.hasVersion()) {
                            this.discourageUpload = true;
                        }
                        WayData wd = new WayData(w.getId());
                        wd.setVersion(info.hasVersion() ? info.getVersion() : 1);
                        this.setMetadata((PrimitiveData)wd, info);
                        HashMap<String, String> keys = new HashMap<String, String>();
                        for (int i = 0; i < w.getKeysCount(); ++i) {
                            keys.put(this.getStringById(w.getKeys(i)), this.getStringById(w.getVals(i)));
                        }
                        wd.setKeys(keys);
                        long id = 0L;
                        ArrayList<Long> nodeIds = new ArrayList<Long>();
                        for (Long idDelta : w.getRefsList()) {
                            nodeIds.add(id += idDelta.longValue());
                        }
                        PbfReader.this.ways.put(wd.getUniqueId(), nodeIds);
                        PbfReader.this.buildPrimitive((PrimitiveData)wd);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
        }

        @Override
        protected void parseRelations(List<Osmformat.Relation> osmRels) {
            if (this.exception == null) {
                try {
                    for (Osmformat.Relation r : osmRels) {
                        Osmformat.Info info = r.getInfo();
                        if (!info.hasVersion()) {
                            this.discourageUpload = true;
                        }
                        RelationData rd = new RelationData(r.getId());
                        rd.setVersion(info.hasVersion() ? info.getVersion() : 1);
                        this.setMetadata((PrimitiveData)rd, info);
                        HashMap<String, String> keys = new HashMap<String, String>();
                        for (int i = 0; i < r.getKeysCount(); ++i) {
                            keys.put(this.getStringById(r.getKeys(i)), this.getStringById(r.getVals(i)));
                        }
                        rd.setKeys(keys);
                        long memId = 0L;
                        ArrayList<RelationMemberData> members = new ArrayList<RelationMemberData>();
                        for (int i = 0; i < r.getMemidsCount(); ++i) {
                            members.add(new RelationMemberData(this.getStringById(r.getRolesSid(i)), this.mapOsmType(r.getTypes(i)), memId += r.getMemids(i)));
                        }
                        PbfReader.this.relations.put(rd.getUniqueId(), members);
                        PbfReader.this.buildPrimitive((PrimitiveData)rd);
                    }
                }
                catch (IllegalDataException e) {
                    this.exception = e;
                }
            }
            if (this.discourageUpload) {
                PbfReader.this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
            }
        }

        private OsmPrimitiveType mapOsmType(Osmformat.Relation.MemberType type) {
            switch (type) {
                case NODE: {
                    return OsmPrimitiveType.NODE;
                }
                case WAY: {
                    return OsmPrimitiveType.WAY;
                }
                case RELATION: {
                    return OsmPrimitiveType.RELATION;
                }
            }
            return null;
        }

        @Override
        public void complete() {
            if (this.discourageUpload) {
                PbfReader.this.ds.setUploadPolicy(UploadPolicy.DISCOURAGED);
            }
        }
    }
}

