/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.test;

import crosby.binary.BinaryParser;
import crosby.binary.Osmformat;
import crosby.binary.file.BlockInputStream;
import java.io.InputStream;
import java.util.List;

public class ReadFileExample {
    public static void main(String[] stringArray) throws Exception {
        InputStream inputStream = ReadFileExample.class.getResourceAsStream("/sample.pbf");
        TestBinaryParser testBinaryParser = new TestBinaryParser();
        new BlockInputStream(inputStream, testBinaryParser).process();
    }

    private static class TestBinaryParser
    extends BinaryParser {
        private TestBinaryParser() {
        }

        @Override
        protected void parseRelations(List<Osmformat.Relation> list) {
            if (!list.isEmpty()) {
                System.out.println("Got some relations to parse.");
            }
            Object var2_2 = null;
        }

        @Override
        protected void parseDense(Osmformat.DenseNodes denseNodes) {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            for (int i = 0; i < denseNodes.getIdCount(); ++i) {
                System.out.printf("Dense node, ID %d @ %.6f,%.6f\n", l += denseNodes.getId(i), this.parseLat(l2 += denseNodes.getLat(i)), this.parseLon(l3 += denseNodes.getLon(i)));
            }
        }

        @Override
        protected void parseNodes(List<Osmformat.Node> list) {
            for (Osmformat.Node node : list) {
                System.out.printf("Regular node, ID %d @ %.6f,%.6f\n", node.getId(), this.parseLat(node.getLat()), this.parseLon(node.getLon()));
            }
        }

        @Override
        protected void parseWays(List<Osmformat.Way> list) {
            for (Osmformat.Way way : list) {
                System.out.println("Way ID " + way.getId());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("  Nodes: ");
                long l = 0L;
                for (Long l2 : way.getRefsList()) {
                    stringBuilder.append(l += l2.longValue()).append(" ");
                }
                stringBuilder.append("\n  Key=value pairs: ");
                for (int i = 0; i < way.getKeysCount(); ++i) {
                    stringBuilder.append(this.getStringById(way.getKeys(i))).append("=").append(this.getStringById(way.getVals(i))).append(" ");
                }
                System.out.println(stringBuilder.toString());
            }
        }

        @Override
        protected void parse(Osmformat.HeaderBlock headerBlock) {
            System.out.println("Got header block.");
        }

        @Override
        public void complete() {
            System.out.println("Complete!");
        }
    }
}

