/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.application.Platform;

final class MonocleWindowManager {
    private static MonocleWindowManager instance = new MonocleWindowManager();
    private MonocleWindow[] windows = new MonocleWindow[0];
    private int nextID = 1;
    private MonocleWindow focusedWindow = null;

    private MonocleWindowManager() {
    }

    static MonocleWindowManager getInstance() {
        return instance;
    }

    private int getWindowIndex(MonocleWindow window) {
        for (int i = 0; i < this.windows.length; ++i) {
            if (this.windows[i] != window) continue;
            return i;
        }
        return -1;
    }

    void toBack(MonocleWindow window) {
        int index = this.getWindowIndex(window);
        if (index != 0 && index != -1) {
            System.arraycopy(this.windows, 0, this.windows, 1, index);
            this.windows[0] = window;
        }
    }

    void toFront(MonocleWindow window) {
        int index = this.getWindowIndex(window);
        if (index != this.windows.length - 1 && index != -1) {
            System.arraycopy(this.windows, index + 1, this.windows, index, this.windows.length - index - 1);
            this.windows[this.windows.length - 1] = window;
        }
    }

    int addWindow(MonocleWindow window) {
        int index = this.getWindowIndex(window);
        if (index == -1) {
            this.windows = Arrays.copyOf(this.windows, this.windows.length + 1);
            this.windows[this.windows.length - 1] = window;
        }
        return this.nextID++;
    }

    boolean closeWindow(MonocleWindow window) {
        int index = this.getWindowIndex(window);
        if (index != -1) {
            System.arraycopy(this.windows, index + 1, this.windows, index, this.windows.length - index - 1);
            this.windows = Arrays.copyOf(this.windows, this.windows.length - 1);
        }
        ArrayList<MonocleWindow> windowsToNotify = new ArrayList<MonocleWindow>();
        for (MonocleWindow otherWindow : this.windows) {
            if (otherWindow.getOwner() != window) continue;
            windowsToNotify.add(otherWindow);
        }
        for (int i = 0; i < windowsToNotify.size(); ++i) {
            ((MonocleWindow)windowsToNotify.get(i)).notifyClose();
        }
        window.notifyDestroy();
        return true;
    }

    boolean minimizeWindow(MonocleWindow window) {
        return true;
    }

    boolean maximizeWindow(MonocleWindow window) {
        return true;
    }

    boolean requestFocus(MonocleWindow window) {
        int index = this.getWindowIndex(window);
        if (index != -1) {
            this.focusedWindow = window;
            window.notifyFocus(542);
            return true;
        }
        return false;
    }

    boolean grabFocus(MonocleWindow window) {
        return true;
    }

    void ungrabFocus(MonocleWindow window) {
    }

    MonocleWindow getWindowForLocation(int x, int y) {
        for (int i = this.windows.length - 1; i >= 0; --i) {
            MonocleWindow w = this.windows[i];
            if (x < w.getX() || y < w.getY() || x >= w.getX() + w.getWidth() || y >= w.getY() + w.getHeight() || !w.isEnabled()) continue;
            return w;
        }
        return null;
    }

    void notifyFocusDisabled(MonocleWindow window) {
        if (window != null) {
            window._notifyFocusDisabled();
        }
    }

    MonocleWindow getFocusedWindow() {
        return this.focusedWindow;
    }

    void repaintAll() {
        for (int i = 0; i < this.windows.length; ++i) {
            MonocleView view = (MonocleView)this.windows[i].getView();
            if (view == null) continue;
            view.notifyRepaint();
        }
    }

    static void repaintFromNative() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                Screen.notifySettingsChanged();
                instance.getFocusedWindow().setFullScreen(true);
                instance.repaintAll();
                Toolkit.getToolkit().requestNextPulse();
            }
        });
    }
}

