/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.javafx.gui;

import java.awt.Dimension;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import org.openstreetmap.josm.tools.Logging;

public class JavaFxWrapper<T extends Node>
extends JFXPanel {
    private static final long serialVersionUID = 1L;
    transient T node;
    private static UncaughtExceptionHandler handler;

    public JavaFxWrapper(Class<T> node) throws ExecutionException {
        try {
            this.initialize((Node)node.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            Logging.logWithStackTrace((Level)Logging.LEVEL_ERROR, (Throwable)e);
        }
    }

    public JavaFxWrapper(T node) throws ExecutionException {
        this.initialize(node);
    }

    private void initialize(T node) throws ExecutionException {
        this.node = node;
        FutureTask<Scene> task = new FutureTask<Scene>(this::initFX);
        Platform.runLater(task);
        Platform.setImplicitExit(false);
        this.setFocusTraversalKeysEnabled(((Node)node).isFocusTraversable());
        try {
            task.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Logging.error((Throwable)e);
        }
    }

    protected Scene initFX() {
        JavaFxWrapper.initializeExceptionHandler();
        Scene scene = this.createScene();
        this.setScene(scene);
        return scene;
    }

    private static void initializeExceptionHandler() {
        if (handler == null) {
            handler = new UncaughtExceptionHandler();
        }
    }

    private Scene createScene() {
        Group group = new Group();
        Scene scene = new Scene(group);
        group.getChildren().add((Node)this.node);
        return scene;
    }

    public T getNode() {
        return this.node;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension size = null;
        if (this.node != null) {
            size = new Dimension();
            size.setSize(((Node)this.node).minWidth(-1.0), ((Node)this.node).minHeight(-1.0));
        }
        return size != null ? size : super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = new Dimension();
        dimension.setSize(((Node)this.node).prefWidth(-1.0), ((Node)this.node).prefHeight(-1.0));
        return dimension;
    }

    private static class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler currentHandler = Thread.currentThread().getUncaughtExceptionHandler();

        public UncaughtExceptionHandler() {
            Thread.currentThread().setUncaughtExceptionHandler(this);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (this.currentHandler != null && !(e instanceof NoClassDefFoundError)) {
                this.currentHandler.uncaughtException(t, e);
            } else {
                Logging.error((Throwable)e);
            }
        }
    }
}

