/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.X;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;

class X11Screen
implements NativeScreen {
    private int depth;
    private int nativeFormat;
    private int width;
    private int height;
    private long nativeHandle;
    private long display;
    private static X xLib = X.getX();

    X11Screen(boolean showCursor) {
        xLib.XInitThreads();
        this.display = xLib.XOpenDisplay(null);
        xLib.XLockDisplay(this.display);
        if (this.display == 0L) {
            throw new NullPointerException("Cannot open X11 display");
        }
        long screen = xLib.DefaultScreenOfDisplay(this.display);
        X.XSetWindowAttributes attrs = new X.XSetWindowAttributes();
        X.XSetWindowAttributes.setEventMask(attrs.p, 76L);
        long cwMask = 2048L;
        if (!showCursor) {
            cwMask |= 0x4000L;
            X.XSetWindowAttributes.setCursor(attrs.p, 0L);
        }
        int x = 0;
        int y = 0;
        int w = xLib.WidthOfScreen(screen);
        int h = xLib.HeightOfScreen(screen);
        boolean fullScreen = true;
        String geometry = AccessController.doPrivileged(() -> System.getProperty("x11.geometry"));
        if (geometry != null) {
            try {
                String size;
                if (geometry.contains(",")) {
                    String location;
                    int i = geometry.indexOf("+");
                    if (i >= 0) {
                        location = geometry.substring(0, i);
                        size = geometry.substring(i + 1);
                    } else {
                        location = geometry;
                        size = "";
                    }
                    i = location.indexOf(",");
                    x = Integer.parseInt(location.substring(0, i));
                    y = Integer.parseInt(location.substring(i + 1));
                    fullScreen = false;
                } else {
                    size = geometry;
                }
                if (size.length() > 0) {
                    int i = size.indexOf("x");
                    w = Integer.parseInt(size.substring(0, i));
                    h = Integer.parseInt(size.substring(i + 1));
                    fullScreen = false;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Cannot parse geometry string: '" + geometry + "'");
            }
        }
        if (fullScreen) {
            X.XSetWindowAttributes.setOverrideRedirect(attrs.p, true);
            cwMask |= 0x200L;
        }
        long window = xLib.XCreateWindow(this.display, xLib.RootWindowOfScreen(screen), x, y, w, h, 0, 0, 1, 0L, cwMask, attrs.p);
        xLib.XMapWindow(this.display, window);
        if (fullScreen) {
            X.XClientMessageEvent event = new X.XClientMessageEvent(new X.XEvent());
            X.XEvent.setWindow(event.p, window);
            X.XClientMessageEvent.setMessageType(event.p, xLib.XInternAtom(this.display, "_NET_WM_STATE", false));
            X.XClientMessageEvent.setFormat(event.p, 32L);
            X.XClientMessageEvent.setDataLong(event.p, 0, 1L);
            X.XClientMessageEvent.setDataLong(event.p, 1, xLib.XInternAtom(this.display, "_NET_WM_STATE_FULLSCREEN", false));
            X.XClientMessageEvent.setDataLong(event.p, 2, 0L);
            xLib.XSendEvent(this.display, xLib.RootWindowOfScreen(screen), false, 0x180000L, event.p);
            xLib.XGrabKeyboard(this.display, window, true, 1L, 1L, 0L);
        }
        xLib.XStoreName(this.display, window, "JavaFX framebuffer container");
        xLib.XSync(this.display, false);
        int[] widthA = new int[1];
        int[] heightA = new int[1];
        int[] depthA = new int[1];
        xLib.XGetGeometry(this.display, window, null, null, null, widthA, heightA, null, depthA);
        xLib.XUnlockDisplay(this.display);
        this.width = widthA[0];
        this.height = heightA[0];
        this.depth = depthA[0];
        this.nativeFormat = 1;
        this.nativeHandle = window;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getNativeFormat() {
        return this.nativeFormat;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    @Override
    public long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public int getDPI() {
        return 96;
    }

    @Override
    public void shutdown() {
    }

    long getDisplay() {
        return this.display;
    }

    @Override
    public void uploadPixels(Buffer b, int x, int y, int width, int height, float alpha) {
    }

    @Override
    public void swapBuffers() {
    }

    @Override
    public ByteBuffer getScreenCapture() {
        return null;
    }
}

