/*
 * Decompiled with CFR 0.152.
 */
package net.simon04.comfort0;

import java.util.Collection;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.KeyValueVisitor;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;

public class OsmToLevel0L
implements OsmPrimitiveVisitor,
KeyValueVisitor {
    private final StringBuilder sb = new StringBuilder();

    public OsmToLevel0L visit(Collection<OsmPrimitive> primitives) {
        primitives.stream().sorted(OsmPrimitiveComparator.orderingWaysRelationsNodes().thenComparing(OsmPrimitiveComparator.comparingUniqueId())).forEachOrdered(p -> p.accept((OsmPrimitiveVisitor)this));
        return this;
    }

    public void visit(Node n) {
        this.appendCommon((OsmPrimitive)n);
    }

    public void visit(Way w) {
        this.appendCommon((OsmPrimitive)w);
        for (Node node : w.getNodes()) {
            this.appendRef((OsmPrimitive)node, "");
        }
    }

    public void visit(Relation r) {
        this.appendCommon((OsmPrimitive)r);
        for (RelationMember member : r.getMembers()) {
            this.appendRef(member.getMember(), " " + member.getRole());
        }
    }

    private void appendRef(OsmPrimitive primitive, String mixin) {
        this.sb.append("  ");
        switch (primitive.getType()) {
            case NODE: {
                this.sb.append("nd ");
                break;
            }
            case WAY: {
                this.sb.append("wy ");
                break;
            }
            case RELATION: {
                this.sb.append("rel ");
                break;
            }
        }
        this.sb.append(primitive.getUniqueId());
        this.sb.append(mixin);
        this.appendDisplayName(primitive);
    }

    void appendCommon(OsmPrimitive p) {
        LatLon latLon;
        this.sb.append("\n");
        this.sb.append(p.getType().getAPIName()).append(" ").append(p.getUniqueId());
        if (p instanceof Node && (latLon = ((Node)p).getCoor()) != null) {
            this.sb.append(": ").append(latLon.lat()).append(", ").append(latLon.lon());
        }
        this.appendDisplayName(p);
        p.visitKeys((KeyValueVisitor)this);
    }

    void appendDisplayName(OsmPrimitive p) {
        this.sb.append(" #").append(p.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())).append("\n");
    }

    public void visitKeyValue(Tagged primitive, String key, String value) {
        if (key.contains("#") || key.contains("=")) {
            throw new UnsupportedOperationException("# and = are not supported in keys");
        }
        this.sb.append("  ").append(key).append(" = ").append(value).append("\n");
    }

    public String toString() {
        return this.sb.toString().replace("\u200c", "").replace("\u200e", "").replace("\u200f", "").replaceFirst("^\\n", "");
    }
}

