/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.editor;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.plugins.tageditor.editor.TagEditorModel;

public class TagTableCellRenderer
extends org.openstreetmap.josm.plugins.tageditor.editor.TagTableCellRenderer {
    protected void renderColor(TagModel tagModel, TagEditorModel model, boolean isSelected, boolean isvalTag) {
        if (isvalTag) {
            this.setBackground(new Color(247, 246, 225));
        } else if (isSelected) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
        if (this.belongsToSelectedPreset(tagModel, model)) {
            this.setBackground(BG_COLOR_HIGHLIGHTED);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        this.resetRenderer();
        TagModel tagModel = (TagModel)value;
        switch (vColIndex) {
            case 0: {
                this.renderTagName(tagModel);
                break;
            }
            case 1: {
                this.renderTagValue(tagModel);
            }
        }
        String[] val_tags = new String[]{"lanes:backward", "turn:lanes:backward", "lanes:both_ways", "turn:lanes:both_ways", "lanes:forward", "turn:lanes:forward", "lanes", "turn:lanes"};
        if (Arrays.asList(val_tags).indexOf(tagModel.getName()) > -1) {
            this.renderColor(tagModel, (TagEditorModel)table.getModel(), isSelected, true);
            if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1 && table.getEditorComponent() != null) {
                table.getEditorComponent().requestFocusInWindow();
            }
        } else {
            this.renderColor(tagModel, (TagEditorModel)table.getModel(), isSelected, false);
            if (hasFocus && isSelected && table.getSelectedColumnCount() == 1 && table.getSelectedRowCount() == 1 && table.getEditorComponent() != null) {
                table.getEditorComponent().requestFocusInWindow();
            }
        }
        return this;
    }
}

