/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geojson;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.geojson.GeoJsonReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class GeoJsonFileImporter
extends FileImporter {
    private static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions((String)"geojson,json", (String)"geojson", (String)(I18n.tr((String)"GeoJSON file", (Object[])new Object[0]) + " (*.geojson, *.geojson.gz, *.geojson.bz2, *.geojson.xz, *.geojson.zip, *.json)"), (ExtensionFileFilter.AddArchiveExtension)ExtensionFileFilter.AddArchiveExtension.NONE, Arrays.asList("gz", "bz", "bz2", "xz", "zip"));

    public GeoJsonFileImporter() {
        super(FILE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(File file, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr((String)"Loading json file\u2026", (Object[])new Object[0]));
        progressMonitor.setTicksCount(2);
        Logging.info((String)"Parsing GeoJSON: {0}", (Object[])new Object[]{file.getAbsolutePath()});
        try (InputStream fileInputStream = Compression.getUncompressedFileInputStream((File)file);){
            DataSet data = new GeoJsonReader().doParseDataSet(fileInputStream, progressMonitor);
            progressMonitor.worked(1);
            MainApplication.getLayerManager().addLayer((Layer)new OsmDataLayer(data, file.getName(), file));
        }
        catch (Exception e) {
            Logging.error((String)"Error while reading json file!");
            Logging.error((Throwable)e);
            GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(null, I18n.tr((String)"Error loading geojson file {0}", (Object[])new Object[]{file.getAbsolutePath()}), I18n.tr((String)"Error", (Object[])new Object[0]), 2));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public DataSet parseDataSet(String source) throws IOException, IllegalDataException {
        try (CachedFile cf = new CachedFile(source);){
            InputStream fileInputStream = Compression.getUncompressedFileInputStream((File)cf.getFile());
            DataSet dataSet = GeoJsonReader.parseDataSet(fileInputStream, NullProgressMonitor.INSTANCE);
            return dataSet;
        }
    }
}

