/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.function.PiDivisorConverter;
import tec.uom.lib.common.function.ValueSupplier;

public final class PiMultiplierConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = -5763262154104962367L;
    private static final Logger logger = Logger.getLogger(PiMultiplierConverter.class.getName());
    private static final BigDecimal TWO = new BigDecimal("2");
    private static final BigDecimal THREE = new BigDecimal("3");
    private static final BigDecimal FOUR = new BigDecimal("4");
    private static final BigDecimal FIVE = new BigDecimal("5");
    private static final BigDecimal TWO_THIRTY_NINE = new BigDecimal("239");

    @Override
    public double convert(double value) {
        return value * Math.PI;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = Pi.pi(nbrDigits);
        return value.multiply(pi, ctx);
    }

    @Override
    public AbstractConverter inverse() {
        return new PiDivisorConverter();
    }

    public final String toString() {
        return "(\u03c0)";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PiMultiplierConverter;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ValueSupplier) {
            return this.getValue().compareTo(String.valueOf(((ValueSupplier)((Object)o)).getValue()));
        }
        return -1;
    }

    static final class Pi {
        private Pi() {
        }

        public static BigDecimal pi(int numDigits) {
            int calcDigits = numDigits + 10;
            return FOUR.multiply(FOUR.multiply(Pi.arccot(FIVE, calcDigits)).subtract(Pi.arccot(TWO_THIRTY_NINE, calcDigits))).setScale(numDigits, RoundingMode.DOWN);
        }

        private static BigDecimal arccot(BigDecimal x, int numDigits) {
            BigDecimal unity = BigDecimal.ONE.setScale(numDigits, RoundingMode.DOWN);
            BigDecimal sum = unity.divide(x, RoundingMode.DOWN);
            BigDecimal xpower = new BigDecimal(sum.toString());
            BigDecimal term = null;
            int nTerms = 0;
            BigDecimal nearZero = BigDecimal.ONE.scaleByPowerOfTen(-numDigits);
            logger.log(Level.FINER, "arccot: ARGUMENT=" + x + " (nearZero=" + nearZero + ")");
            boolean add = false;
            BigDecimal n = THREE;
            while (!(term != null && term.equals(BigDecimal.ZERO) || term != null && term.compareTo(nearZero) < 0)) {
                xpower = xpower.divide(x.pow(2), RoundingMode.DOWN);
                term = xpower.divide(n, RoundingMode.DOWN);
                sum = add ? sum.add(term) : sum.subtract(term);
                add = !add;
                logger.log(Level.FINEST, "arccot: term=" + term);
                ++nTerms;
                n = n.add(TWO);
            }
            logger.log(Level.FINER, "arccot: done. nTerms=" + nTerms);
            return sum;
        }
    }
}

