/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LengthFunction;
import org.geotools.util.Classes;
import org.geotools.util.SimpleInternationalString;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class AttributeTypeBuilder {
    protected FeatureTypeFactory factory;
    protected String name;
    private String separator = ":";
    protected String namespaceURI;
    protected boolean isAbstract = false;
    protected List<Filter> restrictions;
    protected String description;
    protected boolean isIdentifiable = false;
    protected Class<?> binding;
    protected AttributeType superType;
    protected Object defaultValue;
    protected boolean isDefaultValueSet = false;
    protected CoordinateReferenceSystem crs;
    protected boolean isCrsSet = false;
    protected Integer minOccurs = null;
    protected Integer maxOccurs = null;
    protected boolean isNillable = true;
    protected Integer length = null;
    protected Map<Object, Object> userData = null;
    protected FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public AttributeTypeBuilder() {
        this(CommonFactoryFinder.getFeatureTypeFactory(null));
        this.init();
    }

    public AttributeTypeBuilder(FeatureTypeFactory factory) {
        this.factory = factory;
        this.init();
    }

    protected void init() {
        this.resetTypeState();
        this.resetDescriptorState();
    }

    protected void resetTypeState() {
        this.name = null;
        this.namespaceURI = null;
        this.isAbstract = false;
        this.restrictions = null;
        this.description = null;
        this.isIdentifiable = false;
        this.binding = null;
        this.superType = null;
        this.crs = null;
        this.length = null;
        this.isCrsSet = false;
    }

    protected void resetDescriptorState() {
        this.resetTypeState();
        this.minOccurs = null;
        this.maxOccurs = null;
        this.isNillable = true;
        this.userData = new HashMap<Object, Object>();
        this.defaultValue = null;
        this.isDefaultValueSet = false;
    }

    public AttributeTypeBuilder setFactory(FeatureTypeFactory factory) {
        this.factory = factory;
        return this;
    }

    public AttributeTypeBuilder init(AttributeType type) {
        this.name = type.getName().getLocalPart();
        this.separator = type.getName().getSeparator();
        this.namespaceURI = type.getName().getNamespaceURI();
        this.isAbstract = type.isAbstract();
        if (type.getRestrictions() != null) {
            this.restrictions().addAll(type.getRestrictions());
        }
        this.description = type.getDescription() != null ? type.getDescription().toString() : null;
        this.isIdentifiable = type.isIdentified();
        this.binding = type.getBinding();
        this.superType = type.getSuper();
        if (type instanceof GeometryType) {
            this.crs = ((GeometryType)type).getCoordinateReferenceSystem();
        }
        return this;
    }

    public void init(AttributeDescriptor descriptor) {
        this.init(descriptor.getType());
        this.minOccurs = descriptor.getMinOccurs();
        this.maxOccurs = descriptor.getMaxOccurs();
        this.isNillable = descriptor.isNillable();
        this.userData = descriptor.getUserData();
    }

    public void setBinding(Class<?> binding) {
        this.binding = binding;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.isCrsSet = true;
    }

    public boolean isCRSSet() {
        return this.isCrsSet;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIdentifiable(boolean isIdentifiable) {
        this.isIdentifiable = isIdentifiable;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void addRestriction(Filter restriction) {
        this.restrictions().add(restriction);
    }

    public void addUserData(Object key, Object value) {
        this.userData.put(key, value);
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.isDefaultValueSet = true;
    }

    public AttributeTypeBuilder binding(Class<?> binding) {
        this.setBinding(binding);
        return this;
    }

    public AttributeTypeBuilder name(String name) {
        this.setName(name);
        return this;
    }

    public AttributeTypeBuilder namespaceURI(String namespaceURI) {
        this.setNamespaceURI(namespaceURI);
        return this;
    }

    public AttributeTypeBuilder crs(CoordinateReferenceSystem crs) {
        this.setCRS(crs);
        return this;
    }

    public AttributeTypeBuilder description(String description) {
        this.setDescription(description);
        return this;
    }

    public AttributeTypeBuilder abstrct(boolean isAbstract) {
        this.setAbstract(isAbstract);
        return this;
    }

    public AttributeTypeBuilder identifiable(boolean isIdentifiable) {
        this.setIdentifiable(isIdentifiable);
        return this;
    }

    public AttributeTypeBuilder length(int length) {
        this.setLength(length);
        return this;
    }

    public AttributeTypeBuilder restriction(Filter restriction) {
        this.addRestriction(restriction);
        return this;
    }

    public AttributeTypeBuilder nillable(boolean isNillable) {
        this.setNillable(isNillable);
        return this;
    }

    public AttributeTypeBuilder maxOccurs(int maxOccurs) {
        this.setMaxOccurs(maxOccurs);
        return this;
    }

    public AttributeTypeBuilder minOccurs(int minOccurs) {
        this.setMinOccurs(minOccurs);
        return this;
    }

    public AttributeTypeBuilder defaultValue(Object defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public AttributeTypeBuilder userData(Object key, Object value) {
        this.addUserData(key, value);
        return this;
    }

    public AttributeType buildType() {
        if (this.length != null) {
            Filter lengthRestriction = this.lengthRestriction(this.length);
            this.restrictions().add(lengthRestriction);
        }
        AttributeType type = this.factory.createAttributeType(this.name(), this.binding, this.isIdentifiable, this.isAbstract, this.restrictions(), this.superType, this.description());
        this.resetTypeState();
        return type;
    }

    protected String typeName() {
        if (this.name == null) {
            return Classes.getShortName(this.binding);
        }
        return this.name;
    }

    private InternationalString description() {
        return this.description != null ? new SimpleInternationalString(this.description) : null;
    }

    public GeometryType buildGeometryType() {
        GeometryType type = this.factory.createGeometryType(this.name(), this.binding, this.crs, this.isIdentifiable, this.isAbstract, this.restrictions(), this.superType, this.description());
        this.resetTypeState();
        return type;
    }

    public AttributeDescriptor buildDescriptor(String name) {
        this.setName(name);
        if (this.binding == null) {
            throw new IllegalStateException("No binding has been provided for this attribute");
        }
        if (this.crs != null || Geometry.class.isAssignableFrom(this.binding)) {
            return this.buildDescriptor(name, this.buildGeometryType());
        }
        return this.buildDescriptor(name, this.buildType());
    }

    public AttributeDescriptor buildDescriptor(String name, AttributeType type) {
        return this.buildDescriptor((Name)new NameImpl(name), type);
    }

    public GeometryDescriptor buildDescriptor(String name, GeometryType type) {
        return this.buildDescriptor((Name)new NameImpl(name), type);
    }

    public AttributeDescriptor buildDescriptor(Name name, AttributeType type) {
        AttributeDescriptor descriptor = this.factory.createAttributeDescriptor(type, name, this.minOccurs(), this.maxOccurs(), this.isNillable, this.defaultValue());
        descriptor.getUserData().putAll(this.userData);
        this.resetDescriptorState();
        return descriptor;
    }

    public GeometryDescriptor buildDescriptor(Name name, GeometryType type) {
        GeometryDescriptor descriptor = this.factory.createGeometryDescriptor(type, name, this.minOccurs(), this.maxOccurs(), this.isNillable, this.defaultValue());
        descriptor.getUserData().putAll(this.userData);
        this.resetDescriptorState();
        return descriptor;
    }

    private int minOccurs() {
        if (this.minOccurs == null) {
            return this.isNillable ? 0 : 1;
        }
        return this.minOccurs;
    }

    private int maxOccurs() {
        if (this.maxOccurs == null) {
            return 1;
        }
        return this.maxOccurs;
    }

    private Name name() {
        if (this.separator == null) {
            return new NameImpl(this.namespaceURI, this.typeName());
        }
        return new NameImpl(this.namespaceURI, this.separator, this.typeName());
    }

    private Object defaultValue() {
        if (this.defaultValue == null && !this.isNillable && this.binding != null) {
            this.defaultValue = DataUtilities.defaultValue(this.binding);
        }
        return this.defaultValue;
    }

    protected List<Filter> restrictions() {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<Filter>();
        }
        return this.restrictions;
    }

    protected Filter lengthRestriction(int length) {
        if (length < 0) {
            return null;
        }
        LengthFunction lengthFunction = (LengthFunction)this.ff.function("LengthFunction", this.ff.property("."));
        if (lengthFunction == null) {
            return null;
        }
        PropertyIsLessThanOrEqualTo cf = null;
        try {
            cf = this.ff.lessOrEqual(lengthFunction, this.ff.literal(length));
        }
        catch (IllegalFilterException illegalFilterException) {
            // empty catch block
        }
        return cf == null ? Filter.EXCLUDE : cf;
    }
}

