/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jts;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;

public final class CoordinateSequence2D
implements CoordinateSequence,
Cloneable {
    private final double[] x;
    private final double[] y;

    public CoordinateSequence2D(int n) {
        this.x = new double[n];
        this.y = new double[n];
    }

    public CoordinateSequence2D(double ... xy) {
        if (xy == null) {
            this.x = new double[0];
            this.y = new double[0];
        } else {
            if (xy.length % 2 != 0) {
                throw new IllegalArgumentException("xy must have an even number of values");
            }
            this.x = new double[xy.length / 2];
            this.y = new double[xy.length / 2];
            int i = 0;
            for (int k = 0; k < xy.length; k += 2) {
                this.x[i] = xy[k];
                this.y[i] = xy[k + 1];
                ++i;
            }
        }
    }

    public int getDimension() {
        return 2;
    }

    public Coordinate getCoordinate(int index) {
        return new Coordinate(this.x[index], this.y[index]);
    }

    public Coordinate getCoordinateCopy(int index) {
        return this.getCoordinate(index);
    }

    public void getCoordinate(int index, Coordinate coord) {
        if (coord == null) {
            coord = new Coordinate();
        }
        coord.x = this.x[index];
        coord.y = this.y[index];
    }

    public double getX(int index) {
        return this.x[index];
    }

    public double getY(int index) {
        return this.y[index];
    }

    public double getOrdinate(int index, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x[index];
            }
            case 1: {
                return this.y[index];
            }
        }
        throw new IllegalArgumentException("invalid ordinate index: " + ordinateIndex);
    }

    public int size() {
        return this.x.length;
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x[index] = value;
                break;
            }
            case 1: {
                this.y[index] = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    public void setX(int index, double value) {
        this.setOrdinate(index, 0, value);
    }

    public void setY(int index, double value) {
        this.setOrdinate(index, 1, value);
    }

    public void setXY(int index, double x, double y) {
        this.setOrdinate(index, 0, x);
        this.setOrdinate(index, 1, y);
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = new Coordinate[this.x.length];
        for (int i = 0; i < this.x.length; ++i) {
            coords[i] = new Coordinate(this.x[i], this.y[i]);
        }
        return coords;
    }

    public Envelope expandEnvelope(Envelope env) {
        if (env == null) {
            env = new Envelope();
        }
        for (int i = 0; i < this.x.length; ++i) {
            env.expandToInclude(this.x[i], this.y[i]);
        }
        return env;
    }

    public Object clone() {
        CoordinateSequence2D copy = new CoordinateSequence2D(this.x.length);
        for (int i = 0; i < this.x.length; ++i) {
            copy.x[i] = this.x[i];
            copy.y[i] = this.y[i];
        }
        return copy;
    }

    public CoordinateSequence copy() {
        return (CoordinateSequence2D)this.clone();
    }
}

